/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools;

import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.MoveCoordinateListener;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.AbstractModalTool;

public class MoveCoordinateTool
extends AbstractModalTool {
    public static final String ID = "eu.udig.image.georeferencing.tools.movecoordinate";
    public static final String CATEGORY_ID = "eu.udig.image.georeferencing.categorytools";
    private Set<MoveCoordinateListener> listeners = new HashSet<MoveCoordinateListener>();
    private static int targets = 7;

    public MoveCoordinateTool() {
        super(targets);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        for (MoveCoordinateListener listener : this.listeners) {
            listener.activated(active);
        }
    }

    public void mousePressed(MapMouseEvent e) {
        if (e.button != 8) {
            return;
        }
        Point point = e.getPoint();
        this.broadcastCoordinate(point, InputEvent.MOUSE_DOWN);
    }

    public void mouseDragged(MapMouseEvent e) {
        Point point = e.getPoint();
        this.broadcastCoordinate(point, InputEvent.MOUSE_DRAG);
    }

    public void mouseReleased(MapMouseEvent e) {
        if (e.button != 8) {
            return;
        }
        Point point = e.getPoint();
        this.broadcastCoordinate(point, InputEvent.MOUSE_UP);
    }

    public void mouseMoved(MapMouseEvent e) {
        Point point = e.getPoint();
        this.broadcastCoordinate(point, InputEvent.MOUSE_DRAG);
    }

    public void addMoveCoordinateListener(MoveCoordinateListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    public void removeMoveCoordinateListener(MoveCoordinateListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    private void broadcastCoordinate(Point point, InputEvent event) {
        if (point == null) {
            return;
        }
        for (MoveCoordinateListener listener : this.listeners) {
            listener.MoveCoordinate(point, event);
        }
    }
}

