/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools;

import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.DeletedCoordinateListener;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.AbstractModalTool;

public class DeleteCoordinateTool
extends AbstractModalTool {
    public static final String ID = "eu.udig.image.georeferencing.tools.deletecoordinate";
    public static final String CATEGORY_ID = "eu.udig.image.georeferencing.categorytools";
    private Set<DeletedCoordinateListener> listeners = new HashSet<DeletedCoordinateListener>();
    private static int targets = 7;

    public DeleteCoordinateTool() {
        super(targets);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        for (DeletedCoordinateListener listener : this.listeners) {
            listener.activated(active);
        }
    }

    public void mousePressed(MapMouseEvent e) {
        if (e.button != 8) {
            return;
        }
        Point point = e.getPoint();
        this.broadcastCoordinate(point, InputEvent.MOUSE_DOWN);
    }

    public void mouseMoved(MapMouseEvent e) {
        Point point = e.getPoint();
        this.broadcastCoordinate(point, InputEvent.MOUSE_DRAG);
    }

    public void addDeletedCoordinateListener(DeletedCoordinateListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    public void removeDeletedCoordinateListener(DeletedCoordinateListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    private void broadcastCoordinate(Point point, InputEvent event) {
        if (point == null) {
            return;
        }
        for (DeletedCoordinateListener listener : this.listeners) {
            listener.deletedCoordinate(point, event);
        }
    }
}

