/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.tools.CapturedCoordinateListener;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.AbstractModalTool;

public class AddCoordinateTool
extends AbstractModalTool {
    public static final String ID = "eu.udig.image.georeferencing.tools.addcoordinate";
    public static final String CATEGORY_ID = "eu.udig.image.georeferencing.categorytools";
    private Set<CapturedCoordinateListener> listeners = new HashSet<CapturedCoordinateListener>();

    public void setActive(boolean active) {
        super.setActive(active);
        for (CapturedCoordinateListener listener : this.listeners) {
            listener.activated(active);
        }
    }

    public void mousePressed(MapMouseEvent e) {
        if (e.button != 8) {
            return;
        }
        IMap map = ApplicationGIS.getActiveMap();
        Point point = e.getPoint();
        Coordinate newCoord = map.getViewportModel().pixelToWorld(point.x, point.y);
        this.broadcastCoordinate(newCoord);
    }

    public void addCapturedCoordinateListener(CapturedCoordinateListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    public void removeCapturedCoordinateListener(CapturedCoordinateListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    private void broadcastCoordinate(Coordinate newCoord) {
        if (newCoord == null) {
            return;
        }
        for (CapturedCoordinateListener listener : this.listeners) {
            listener.capturedCoordinate(newCoord);
        }
    }
}

