/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.coordinatepanel;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.ui.AbstractMarkPresenter;
import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.MarkMapPresenter;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.ui.graphics.ViewportGraphics;

final class MarkMapPresenterImp
extends AbstractMarkPresenter
implements MarkMapPresenter {
    private MarkModel mark = null;
    private MapGraphicContext context = null;
    private static final int EXTENT_SIZE = 10;

    public MarkMapPresenterImp(MarkModel markModel) {
        this.mark = markModel;
        this.mark.addObserver(this);
    }

    @Override
    public void update(Observable arg0, Object arg) {
        MarkModel.MarkModelChange change = (MarkModel.MarkModelChange)((Object)arg);
        switch (change) {
            case NEW: 
            case MODIFY: {
                break;
            }
            case DELETE: {
                this.delete();
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void draw() {
        if (this.hide) {
            return;
        }
        ViewportGraphics graphics = this.context.getGraphics();
        graphics.setColor(this.createColor(this.mark.hashCode()));
        Point point = null;
        if (!this.mark.getXCoord().equals(Double.NaN) || !this.mark.getYCoord().equals(Double.NaN)) {
            point = this.context.worldToPixel(new Coordinate(this.mark.getXCoord().doubleValue(), this.mark.getYCoord().doubleValue()));
        }
        if (point != null) {
            this.extent = new Rectangle((int)(point.getX() - 5.0), (int)(point.getY() - 5.0), 10, 10);
            if (this.feedback) {
                Color yellow = Color.YELLOW;
                graphics.setColor(yellow);
                graphics.fillOval(this.extent.x, this.extent.y, this.extent.width, this.extent.height);
                Color orange = Color.ORANGE;
                graphics.setColor(orange);
                graphics.drawOval(this.extent.x, this.extent.y, this.extent.width, this.extent.height);
                graphics.setColor(this.createColor(this.mark.hashCode()));
            } else {
                graphics.fillOval(this.extent.x, this.extent.y, this.extent.width, this.extent.height);
            }
            Rectangle2D stringBounds = graphics.getStringBounds(String.valueOf(this.mark.getID()));
            graphics.drawString(String.valueOf(this.mark.getID()), (int)point.getX(), (int)(point.getY() + stringBounds.getHeight()), 0, -1);
        }
    }

    @Override
    public void setContext(MapGraphicContext context) {
        this.context = context;
    }

    @Override
    public MarkModel getMarkModel() {
        return this.mark;
    }

    @Override
    public boolean eventHandler(InputEvent event, int x, int y) {
        switch (event) {
            case MOUSE_DOWN: 
            case MOUSE_DRAG: 
            case DELETE: {
                return this.extentContains(x, y);
            }
        }
        return false;
    }

    @Override
    public void showSelectedFeedback(boolean feedback) {
        this.feedback = feedback;
    }
}

