/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.coordinatepanel;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.MouseSelectionListener;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.CoordinateTableComposite;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.MarkMapPresenter;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.MarkMapPreview;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImageComposite;
import java.awt.Point;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;

public final class MapMarksGraphics
implements MapGraphic {
    private Map<String, MarkMapPresenter> markMapPresenterList = Collections.synchronizedMap(new Hashtable());
    private MarkMapPreview preview = null;
    private Set<MouseSelectionListener> listeners = new HashSet<MouseSelectionListener>();
    private MouseSelectionListener coordinatePanelSelectionListener = new MouseSelectionListener(){

        @Override
        public void inEvent(MarkModel mark) {
            MapMarksGraphics.this.showFeedback(mark);
        }

        @Override
        public void outEvent(MarkModel mark) {
            MapMarksGraphics.this.hideFeedback(mark);
        }
    };
    private MouseSelectionListener imageSelectionListener = new MouseSelectionListener(){

        @Override
        public void inEvent(MarkModel mark) {
            MapMarksGraphics.this.showFeedback(mark);
        }

        @Override
        public void outEvent(MarkModel mark) {
            MapMarksGraphics.this.hideFeedback(mark);
        }
    };

    public void associateListeners(CoordinateTableComposite coordComposite, ImageComposite imageComposite) {
        coordComposite.addMouseSelectionListener(this.coordinatePanelSelectionListener);
        imageComposite.addMouseSelectionListener(this.imageSelectionListener);
    }

    public void deleteAssociatedListeners(CoordinateTableComposite coordComposite, ImageComposite imageComposite) {
        coordComposite.deleteMouseSelectionListener(this.coordinatePanelSelectionListener);
        imageComposite.deleteMouseSelectionListener(this.imageSelectionListener);
    }

    public void draw(MapGraphicContext context) {
        Set<Map.Entry<String, MarkMapPresenter>> entrySet = this.markMapPresenterList.entrySet();
        for (Map.Entry<String, MarkMapPresenter> entry : entrySet) {
            MarkMapPresenter presenter = entry.getValue();
            presenter.setContext(context);
            presenter.draw();
        }
        if (this.preview != null) {
            this.preview.setContext(context);
            this.preview.draw();
        }
    }

    public void addMarkMapPresenter(MarkMapPresenter markPresenter) {
        this.markMapPresenterList.put(markPresenter.getMarkModel().getID(), markPresenter);
    }

    public void clear() {
        this.markMapPresenterList.clear();
    }

    public Map<String, MarkMapPresenter> getPresenters() {
        return this.markMapPresenterList;
    }

    public void eventhandler(InputEvent event, Point point) {
        switch (event) {
            case MOUSE_DOWN: {
                Set<Map.Entry<String, MarkMapPresenter>> entrySet = this.markMapPresenterList.entrySet();
                for (Map.Entry<String, MarkMapPresenter> entry : entrySet) {
                    MarkMapPresenter presenter = entry.getValue();
                    if (!presenter.eventHandler(event, point.x, point.y)) continue;
                    this.preview = new MarkMapPreview(presenter);
                }
                break;
            }
            case MOUSE_DRAG: {
                if (this.preview != null) {
                    this.preview.eventHandler(event, point.x, point.y);
                    break;
                }
                this.showFeedback(event, point.x, point.y);
                break;
            }
            case MOUSE_UP: {
                if (this.preview == null) break;
                IMap map = ApplicationGIS.getActiveMap();
                Coordinate newCoord = map.getViewportModel().pixelToWorld(point.x, point.y);
                this.preview.getMarkModel().updateCoordinatePosition(newCoord);
                this.preview.delete();
                this.preview = null;
                break;
            }
        }
    }

    public void showFeedback(InputEvent inputEvent, int x, int y) {
        Set<Map.Entry<String, MarkMapPresenter>> entrySet = this.markMapPresenterList.entrySet();
        for (Map.Entry<String, MarkMapPresenter> entry : entrySet) {
            MarkMapPresenter presenter = entry.getValue();
            if (presenter.eventHandler(inputEvent, x, y)) {
                presenter.showSelectedFeedback(true);
                this.broadcastMouseInEvent(presenter.getMarkModel());
                continue;
            }
            presenter.showSelectedFeedback(false);
            this.broadcastMouseOutEvent(presenter.getMarkModel());
        }
    }

    public void addMouseSelectionListener(MouseSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void deleteMouseSelectionListener(MouseSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void broadcastMouseInEvent(MarkModel mark) {
        for (MouseSelectionListener listener : this.listeners) {
            listener.inEvent(mark);
        }
    }

    private void broadcastMouseOutEvent(MarkModel mark) {
        for (MouseSelectionListener listener : this.listeners) {
            listener.outEvent(mark);
        }
    }

    private void showFeedback(MarkModel mark) {
        Set<Map.Entry<String, MarkMapPresenter>> entrySet = this.markMapPresenterList.entrySet();
        for (Map.Entry<String, MarkMapPresenter> entry : entrySet) {
            MarkMapPresenter presenter = entry.getValue();
            if (presenter.getMarkModel().getID().equals(mark.getID())) {
                presenter.showSelectedFeedback(true);
                continue;
            }
            presenter.showSelectedFeedback(false);
        }
    }

    private void hideFeedback(MarkModel mark) {
        Set<Map.Entry<String, MarkMapPresenter>> entrySet = this.markMapPresenterList.entrySet();
        for (Map.Entry<String, MarkMapPresenter> entry : entrySet) {
            MarkMapPresenter presenter = entry.getValue();
            if (!presenter.getMarkModel().getID().equals(mark.getID())) continue;
            presenter.showSelectedFeedback(false);
        }
    }
}

