/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui;

import eu.udig.image.georeferencing.internal.i18n.Messages;
import eu.udig.image.georeferencing.internal.preferences.Preferences;
import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.ui.GeoReferencingCommand;
import eu.udig.image.georeferencing.internal.ui.GeoReferencingComposite;
import eu.udig.image.georeferencing.internal.ui.GeoreferencingCommandEventChange;
import eu.udig.image.georeferencing.internal.ui.MouseSelectionListener;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.CoordinateTableComposite;
import eu.udig.image.georeferencing.internal.ui.coordinatepanel.MapMarksGraphics;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImageComposite;
import eu.udig.image.georeferencing.internal.ui.message.InfoMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.mapgraphic.internal.MapGraphicService;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.commands.DeleteLayerCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MainComposite
extends Composite
implements Observer,
GeoReferencingComposite {
    private static final Logger LOGGER = Logger.getLogger(MainComposite.class.getName());
    private Composite outputComposite = null;
    private Composite informationComposite = null;
    private Composite contentComposite = null;
    private SashForm sashForm = null;
    private ImageComposite imageComposite = null;
    private CoordinateTableComposite coordinateTableComposite = null;
    private CLabel messageImage = null;
    private CLabel messageText = null;
    private IToolContext udigContext = null;
    private ViewForm viewForm = null;
    private CLabel outputLabel = null;
    private Text filePathText = null;
    private Button browseButton = null;
    private GeoReferencingCommand cmd = null;
    private IToolContext toolContext = null;
    private MapMarksGraphics mapMarkGraphic = null;
    private ILayer mapGraphicLayer = null;
    private Thread uiThread = null;

    public MainComposite(GeoReferencingCommand cmd, Composite parent, int style) {
        super(parent, style);
        assert (cmd != null);
        this.cmd = cmd;
        this.cmd.addObserver(this);
        this.createContent();
        this.pack();
    }

    private void createContent() {
        this.uiThread = Thread.currentThread();
        this.viewForm = new ViewForm((Composite)this, 0);
        this.viewForm.setLayout((Layout)new FillLayout());
        Composite infoComposite = this.createCompositeLegend((Composite)this.viewForm);
        this.viewForm.setTopLeft((Control)infoComposite);
        this.contentComposite = new Composite((Composite)this.viewForm, 0);
        this.contentComposite.setLayout((Layout)new GridLayout());
        this.createContentComposite(this.contentComposite);
        this.viewForm.setContent((Control)this.contentComposite);
    }

    private void createContentComposite(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.verticalAlignment = 4;
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayout((Layout)new GridLayout());
        this.sashForm.setLayoutData((Object)gridData);
        this.createImageComposite((Composite)this.sashForm);
        this.createCoordinateTableComposite((Composite)this.sashForm);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.outputComposite = new Composite(parent, 2048);
        this.outputComposite.setLayout((Layout)gridLayout);
        this.outputComposite.setLayoutData((Object)gridData2);
        this.createOutputBrowser(this.outputComposite);
    }

    private void createOutputBrowser(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.verticalAlignment = 3;
        this.outputLabel = new CLabel(parent, 0);
        this.outputLabel.setText(Messages.MainComposite_outputText);
        this.outputLabel.setToolTipText(Messages.MainComposite_outputToolTip);
        this.outputLabel.setLayoutData((Object)gridData);
        this.filePathText = new Text(parent, 2048);
        this.filePathText.setLayoutData((Object)gridData2);
        this.filePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                MainComposite.this.cmd.setOutputFileName(MainComposite.this.filePathText.getText());
                MainComposite.this.cmd.evalPrecondition();
            }
        });
        this.browseButton = new Button(parent, 0);
        this.browseButton.setText(Messages.MainComposite_browseText);
        this.browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileDialog fd = new FileDialog(shell, 8192);
                fd.setFilterExtensions(new String[]{"*.tif"});
                fd.setText("Save file");
                fd.setFilterPath(Preferences.getOutputFilePath());
                String filename = fd.open();
                if (filename != null) {
                    MainComposite.this.filePathText.setText(filename);
                    MainComposite.this.cmd.setOutputFileName(filename);
                    MainComposite.this.cmd.evalPrecondition();
                    File file = new File(filename);
                    Preferences.setOutputFilePath(file.getParent());
                }
            }
        });
    }

    private Composite createCompositeLegend(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.minimumHeight = 300;
        gridData.minimumWidth = 500;
        gridData.verticalAlignment = 0x1000000;
        Composite compositeSelection = new Composite(parent, 2048);
        compositeSelection.setLayoutData((Object)gridData);
        compositeSelection.setLayout((Layout)layout);
        this.createCompositeInformation(compositeSelection);
        return compositeSelection;
    }

    private void createCompositeInformation(Composite parent) {
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.grabExcessVerticalSpace = true;
        gridData6.verticalAlignment = 4;
        this.informationComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        this.informationComposite.setLayoutData((Object)gridData6);
        this.informationComposite.setLayout((Layout)gridLayout);
        this.messageImage = new CLabel(this.informationComposite, 0);
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 1;
        gridData7.minimumWidth = 30;
        gridData7.widthHint = 30;
        this.messageImage.setLayoutData((Object)gridData7);
        this.messageText = new CLabel(this.informationComposite, 0);
        GridData gridData8 = new GridData();
        gridData8.horizontalAlignment = 4;
        gridData8.grabExcessHorizontalSpace = true;
        gridData8.grabExcessVerticalSpace = true;
        gridData8.verticalAlignment = 4;
        this.messageText.setLayoutData((Object)gridData8);
        this.messageText.setFont(JFaceResources.getDialogFont());
        InfoMessage message = this.cmd.getMessage();
        this.displayMessage(message);
    }

    private void createImageComposite(Composite parent) {
        this.imageComposite = new ImageComposite(this.cmd, parent, 526336);
        this.cmd.addObserver(this.imageComposite);
    }

    private void createCoordinateTableComposite(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        scrollComposite.setLayout((Layout)new FillLayout());
        this.coordinateTableComposite = new CoordinateTableComposite(this.cmd, (Composite)scrollComposite, 524288);
        this.coordinateTableComposite.setLayout((Layout)new FillLayout());
        this.cmd.addObserver(this.coordinateTableComposite);
        scrollComposite.setContent((Control)this.coordinateTableComposite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setMinHeight(300);
    }

    public void displayMessage(InfoMessage message) {
        assert (message != null);
        InfoMessage filteredMessage = message;
        this.informationComposite.setVisible(true);
        this.messageImage.setImage(filteredMessage.getImage());
        this.messageText.setToolTipText(filteredMessage.getText());
        this.messageText.setText(filteredMessage.getText());
    }

    public void executeOperation() {
        ViewportPane pane = this.udigContext.getViewportPane();
        Display display = this.getDisplay();
        try {
            try {
                this.setEnabled(false);
                pane.setCursor(display.getSystemCursor(1));
                this.cmd.execute();
            }
            catch (IOException e) {
                this.displayMessage(new InfoMessage(e.getMessage(), InfoMessage.Type.FAIL));
                pane.setCursor(null);
                this.setEnabled(true);
            }
        }
        finally {
            pane.setCursor(null);
            this.setEnabled(true);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        InfoMessage message = this.cmd.getMessage();
        if (!(arg instanceof GeoreferencingCommandEventChange)) {
            return;
        }
        GeoreferencingCommandEventChange cmdEvent = (GeoreferencingCommandEventChange)arg;
        switch (cmdEvent.getEvent()) {
            case MAP_CHANGE: {
                message.setType(InfoMessage.Type.WARNING);
                this.setEnabled(false);
                break;
            }
            case MAP_CHANGE_TO_ORIGINAL: {
                message.setType(InfoMessage.Type.INFORMATION);
                this.setEnabled(true);
            }
        }
        this.displayMessage(message);
    }

    @Override
    public void setContext(IToolContext context) {
        if (context != null) {
            IMap map = context.getMap();
            CoordinateReferenceSystem crs = this.getCurrentMapCrs(map);
            try {
                this.createTheMapGraphic(map);
            }
            catch (IOException e) {
                InfoMessage info = new InfoMessage(Messages.MainComposite_mapGraphicFailText, InfoMessage.Type.FAIL);
                this.setMessage(info);
                e.printStackTrace();
            }
            this.cmd.setCRS(crs);
            this.cmd.setMap(map);
            this.cmd.evalPrecondition();
        }
        if (this.toolContext == null) {
            this.toolContext = context;
            this.mapMarkGraphic.associateListeners(this.coordinateTableComposite, this.imageComposite);
        }
        this.imageComposite.setContext(context);
        this.coordinateTableComposite.setContext(context);
    }

    private CoordinateReferenceSystem getCurrentMapCrs(IMap map) {
        return map.getViewportModel().getCRS();
    }

    public void setMessage(InfoMessage info) {
        this.displayMessage(info);
    }

    public void close() {
        this.imageComposite.close(this);
        this.coordinateTableComposite.close(this);
        try {
            try {
                if (this.mapMarkGraphic != null) {
                    this.mapMarkGraphic.deleteAssociatedListeners(this.coordinateTableComposite, this.imageComposite);
                    this.getMapMarkGraphic().clear();
                    IMap map = this.cmd.getMap();
                    this.removeOldMapGraphicFromLayer(map);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.mapMarkGraphic = null;
            }
        }
        finally {
            this.mapMarkGraphic = null;
        }
    }

    public void setEnabled(boolean enabled) {
        this.imageComposite.setEnabled(enabled);
        this.coordinateTableComposite.setEnabled(enabled);
        this.informationComposite.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void createMarks(Map<String, MarkModel> marks) {
        this.imageComposite.createMarks(marks);
        this.refreshMapGraphicLayer();
        this.setCursor(null);
    }

    public void deleteAllPoints() {
        this.setCursor(Display.getCurrent().getSystemCursor(1));
        this.imageComposite.deleteAllPoints();
    }

    private void createTheMapGraphic(IMap map) throws IOException {
        if (this.getMapMarkGraphic() != null) {
            return;
        }
        this.removeOldMapGraphicFromLayer(map);
        List mapgraphics = CatalogPlugin.getDefault().getLocalCatalog().find(MapGraphicService.SERVICE_URL, null);
        List members = new ArrayList();
        members = ((IResolve)mapgraphics.get(0)).members(null);
        assert (members != null);
        IGeoResource resolved = null;
        for (IResolve resolve : members) {
            if (!resolve.canResolve(MapMarksGraphics.class)) continue;
            resolved = (IGeoResource)resolve.resolve(IGeoResource.class, null);
            break;
        }
        assert (resolved != null);
        ApplicationGIS.addLayersToMap((IMap)map, Collections.singletonList(resolved), (int)-1);
        List mapLayers = map.getMapLayers();
        for (ILayer layer : mapLayers) {
            MapMarksGraphics mapGraphic;
            IGeoResource geoResource = layer.findGeoResource(MapMarksGraphics.class);
            if (geoResource == null) continue;
            this.mapMarkGraphic = mapGraphic = (MapMarksGraphics)geoResource.resolve(MapMarksGraphics.class, null);
            this.mapGraphicLayer = layer;
            break;
        }
        assert (this.getMapMarkGraphic() != null);
    }

    private void removeOldMapGraphicFromLayer(IMap map) throws IOException {
        List mapLayers = map.getMapLayers();
        for (ILayer layer : mapLayers) {
            IGeoResource geoResource = layer.findGeoResource(MapMarksGraphics.class);
            if (geoResource == null) continue;
            map.sendCommandASync((MapCommand)new DeleteLayerCommand((Layer)layer));
            break;
        }
    }

    public MapMarksGraphics getMapMarkGraphic() {
        return this.mapMarkGraphic;
    }

    public ILayer getMapGraphicLayer() {
        return this.mapGraphicLayer;
    }

    public void refreshMapGraphicLayer() {
        this.mapGraphicLayer.refresh(null);
    }

    private void updatedMapLayersActions(MapCompositionEvent event) {
        MapCompositionEvent.EventType eventType = event.getType();
        switch (eventType) {
            case ADDED: 
            case MANY_ADDED: {
                Display.findDisplay((Thread)this.uiThread).asyncExec(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                break;
            }
        }
    }

    public void addMouseSelectionListenerToImgComposite(MouseSelectionListener listener) {
        this.imageComposite.addMouseSelectionListener(listener);
    }

    public void deleteMouseSelectionListenerToImgComposite(MouseSelectionListener listener) {
        this.imageComposite.deleteMouseSelectionListener(listener);
    }

    public void addMouseSelectionListenerToCoordinate(MouseSelectionListener listener) {
        this.coordinateTableComposite.addMouseSelectionListener(listener);
    }

    public void deleteMouseSelectionListenerToCoordinate(MouseSelectionListener listener) {
        this.coordinateTableComposite.deleteMouseSelectionListener(listener);
    }
}

