/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.image.georeferencing.internal.i18n.Messages;
import eu.udig.image.georeferencing.internal.process.GeoReferencingProcess;
import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.process.MarkModelFactory;
import eu.udig.image.georeferencing.internal.ui.GeoreferencingCommandEventChange;
import eu.udig.image.georeferencing.internal.ui.message.InfoMessage;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import org.eclipse.swt.graphics.ImageData;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class GeoReferencingCommand
extends Observable {
    private static final String DEFAULT_MESSAGE = Messages.GeoReferencingCommand_defaultMessage;
    private static final String INITIAL_MESSAGE = Messages.GeoReferencingCommand_initialMessage;
    private InfoMessage message = new InfoMessage(INITIAL_MESSAGE, InfoMessage.Type.INFORMATION);
    private String imagePath = null;
    private CoordinateReferenceSystem crsTarget = null;
    private Map<String, MarkModel> markList = new LinkedHashMap<String, MarkModel>();
    private boolean readyToExecute = false;
    private ImageData imageData = null;
    private String outputFileName;
    private IMap originalMap = null;
    private IMap currentMap;

    public void addMark(MarkModel newMark) {
        this.markList.put(newMark.getID(), newMark);
        this.setMessage(Messages.GeoReferencingCommand_addGrounControlPoint);
        this.setChanged();
        this.notifyObservers(new GeoreferencingCommandEventChange(newMark, GeoreferencingCommandEventChange.ChangeEvent.MARK_ADDED));
    }

    public void deleteMark(MarkModel mark) {
        mark.delete();
        MarkModel value = this.markList.remove(mark.getID());
        assert (value != null);
        this.setChanged();
        this.notifyObservers(new GeoreferencingCommandEventChange(mark, GeoreferencingCommandEventChange.ChangeEvent.MARK_DELETED));
    }

    public void deleteAllMarks() {
        Collection<MarkModel> collection = this.markList.values();
        for (MarkModel mark : collection) {
            mark.delete();
        }
        this.markList.clear();
        MarkModelFactory.resetIdSecuence();
        this.readyToExecute = false;
        this.setMessage(Messages.GeoReferencingCommand_insertMarks);
        this.setChanged();
        this.notifyObservers(new GeoreferencingCommandEventChange(GeoreferencingCommandEventChange.ChangeEvent.ALL_MARKS_DELETED));
    }

    public void setImagePath(String imagePath) {
        assert (imagePath != null);
        this.imagePath = imagePath;
        this.setChanged();
        this.notifyObservers(new GeoreferencingCommandEventChange(GeoreferencingCommandEventChange.ChangeEvent.IMAGE_LOADED));
    }

    public boolean canExectue() {
        return this.readyToExecute;
    }

    public void evalPrecondition() {
        this.readyToExecute = true;
        if (this.markList.size() < 6 || !this.validateCoordinateData()) {
            this.readyToExecute = false;
        } else if (this.crsTarget == null) {
            this.readyToExecute = false;
        } else if (this.imagePath == null || this.imagePath.equals("")) {
            this.readyToExecute = false;
        } else if (this.outputFileName == null || this.outputFileName.equals("")) {
            this.readyToExecute = false;
            if (this.markList.size() >= 6) {
                this.setMessage(Messages.GeoReferencingCommand_needOutputFile);
            }
        } else if (this.originalMap == null) {
            this.readyToExecute = false;
        }
        if (this.readyToExecute) {
            this.setMessage(Messages.GeoReferencingCommand_executeOperation);
        }
        this.setChanged();
        this.notifyObservers(new GeoreferencingCommandEventChange(GeoreferencingCommandEventChange.ChangeEvent.CAN_EXECUTE));
    }

    private boolean validateCoordinateData() {
        Collection<MarkModel> collection = this.markList.values();
        for (MarkModel mark : collection) {
            if (mark.getXCoord().equals(Double.NaN)) {
                return false;
            }
            if (!mark.getYCoord().equals(Double.NaN)) continue;
            return false;
        }
        return true;
    }

    public void setCRS(CoordinateReferenceSystem currentMapCrs) {
        this.crsTarget = currentMapCrs;
    }

    public void setMap(IMap map) {
        this.currentMap = map;
        if (this.originalMap != null && !this.originalMap.equals(this.currentMap)) {
            this.setMessage(Messages.GeoReferencingCommand_mapChange);
            this.setChanged();
            this.notifyObservers(new GeoreferencingCommandEventChange(GeoreferencingCommandEventChange.ChangeEvent.MAP_CHANGE));
        }
        if (this.originalMap != null && this.originalMap.equals(this.currentMap)) {
            this.setMessage(DEFAULT_MESSAGE);
            this.setChanged();
            this.notifyObservers(new GeoreferencingCommandEventChange(GeoreferencingCommandEventChange.ChangeEvent.MAP_CHANGE_TO_ORIGINAL));
        }
        if (this.originalMap == null) {
            this.setMessage(DEFAULT_MESSAGE);
            this.originalMap = map;
        }
    }

    public void execute() throws IOException {
        if (!this.readyToExecute) {
            throw new IllegalStateException(Messages.GeoReferencingCommand_cmdNotReady);
        }
        Point2D[] dstCoords = this.getImagePoints();
        Point2D[] srcCoords = this.getBasemapPoints();
        int[] order = this.getSortOrder(dstCoords);
        dstCoords = this.sortArray(dstCoords, order);
        srcCoords = this.sortArray(srcCoords, order);
        GeoReferencingProcess process = new GeoReferencingProcess(this.crsTarget, srcCoords, dstCoords, this.imagePath, this.outputFileName, this.originalMap);
        process.run();
        for (ILayer layer : this.originalMap.getMapLayers()) {
            layer.refresh(null);
        }
    }

    private Point2D[] getImagePoints() {
        Point2D[] points = new Point2D[this.markList.size()];
        int index = 0;
        Collection<MarkModel> collection = this.markList.values();
        for (MarkModel mark : collection) {
            Point fullPoint = new Point(mark.getXImage(), this.imageData.height - mark.getYImage());
            points[index] = fullPoint;
            ++index;
        }
        return points;
    }

    private Point2D[] getBasemapPoints() {
        Point2D[] points = new Point2D[this.markList.size()];
        int index = 0;
        Collection<MarkModel> collection = this.markList.values();
        for (MarkModel mark : collection) {
            Coordinate coord = new Coordinate(mark.getXCoord().doubleValue(), mark.getYCoord().doubleValue());
            points[index] = new Point2D.Double(coord.x, coord.y);
            ++index;
        }
        return points;
    }

    private Point2D[] sortArray(Point2D[] ar, int[] order) {
        Point2D[] ordered = new Point2D[ar.length];
        int i = 0;
        while (i < ar.length) {
            ordered[i] = ar[order[i]];
            ++i;
        }
        return ordered;
    }

    private int[] getSortOrder(Point2D[] ar) {
        Point2D[] sorted = this.sortPointsX(ar);
        sorted = this.sortPointsY(sorted);
        int[] order = new int[ar.length];
        int i = 0;
        while (i < sorted.length) {
            Point2D point = sorted[i];
            int y = 0;
            while (y < ar.length) {
                if (point.equals(ar[y])) {
                    order[i] = y;
                    break;
                }
                ++y;
            }
            ++i;
        }
        return order;
    }

    private Point2D[] sortPointsX(Point2D[] ar) {
        Point2D[] sorted = new Point2D[ar.length];
        int i = 0;
        while (i < ar.length) {
            Point2D point = ar[i];
            int y = 0;
            while (y < sorted.length) {
                Point2D point2 = sorted[y];
                if (point2 == null) {
                    sorted[y] = point;
                    break;
                }
                if (point2.getX() < point.getX()) {
                    int z = sorted.length - 1;
                    while (z > y) {
                        sorted[z] = sorted[z - 1];
                        --z;
                    }
                    sorted[y] = point;
                    break;
                }
                ++y;
            }
            ++i;
        }
        return sorted;
    }

    private Point2D[] sortPointsY(Point2D[] ar) {
        Point2D[] sorted = new Point2D[ar.length];
        int i = 0;
        while (i < ar.length) {
            Point2D point = ar[i];
            int y = 0;
            while (y < sorted.length) {
                Point2D point2 = sorted[y];
                if (point2 == null) {
                    sorted[y] = point;
                    break;
                }
                if (point2.getY() < point.getY()) {
                    int z = sorted.length - 1;
                    while (z > y) {
                        sorted[z] = sorted[z - 1];
                        --z;
                    }
                    sorted[y] = point;
                    break;
                }
                ++y;
            }
            ++i;
        }
        return sorted;
    }

    public void setImageData(ImageData imageData) {
        this.imageData = imageData;
    }

    private void setMessage(String msg) {
        this.message.setText(msg);
    }

    public InfoMessage getMessage() {
        return this.message;
    }

    public void setOutputFileName(String filename) {
        this.outputFileName = filename;
    }

    public void loadMarks(Map<String, MarkModel> loadMarks) {
        this.markList = loadMarks;
    }

    public Map<String, MarkModel> getMarks() {
        return this.markList;
    }

    public boolean canSave() {
        return !this.markList.keySet().isEmpty() && this.originalMap != null && this.originalMap.equals(this.currentMap);
    }

    public boolean canLoad() {
        return this.originalMap != null && this.originalMap.equals(this.currentMap) && this.imagePath != null && !this.imagePath.equals("");
    }

    public IMap getMap() {
        return this.originalMap;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crsTarget;
    }

    public boolean canEnableImageTools() {
        return this.canSave();
    }

    public boolean canEnableMapTools() {
        return this.canSave() && this.checkOneCoordinateExist();
    }

    private boolean checkOneCoordinateExist() {
        Collection<MarkModel> collection = this.markList.values();
        for (MarkModel mark : collection) {
            if (mark.getXCoord().equals(Double.NaN) || mark.getYCoord().equals(Double.NaN)) continue;
            return true;
        }
        return false;
    }
}

