/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.process;

import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.process.MarkModelImpl;

public final class MarkModelFactory {
    private static int ID_COUNT = 0;
    private static MarkModelFactory THIS = new MarkModelFactory();

    private MarkModelFactory() {
    }

    public static MarkModelFactory getInstance() {
        return THIS;
    }

    public MarkModel create() {
        return new MarkModelImpl(String.valueOf(MarkModelFactory.getNewMarkID()));
    }

    public MarkModel create(String id, Integer xImage, Integer yImage, Double xCoord, Double yCoord) {
        MarkModelImpl mark = new MarkModelImpl(id);
        mark.setXImage(xImage);
        mark.setYImage(yImage);
        mark.setXCoord(xCoord);
        mark.setYCoord(yCoord);
        this.updateID(id);
        return mark;
    }

    private synchronized void updateID(String id) {
        try {
            int actualId = Integer.parseInt(id);
            if (actualId > ID_COUNT) {
                ID_COUNT = actualId;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private static synchronized int getNewMarkID() {
        return ++ID_COUNT;
    }

    public static synchronized void resetIdSecuence() {
        ID_COUNT = 0;
    }
}

