/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.process;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.Operations;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.operation.transform.WarpTransform2D;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;

public class GeoReferencingProcess {
    private CoordinateReferenceSystem crsTarget = null;
    private Point2D[] dstCoords = null;
    private Point2D[] srcCoords = null;
    private BufferedImage image = null;
    private IMap map = null;
    private String outputFileName;

    public GeoReferencingProcess(CoordinateReferenceSystem crsTarget, Point2D[] srcCoords, Point2D[] dstCoords, String imgPath, String outputFileName, IMap map) {
        assert (crsTarget != null);
        assert (srcCoords != null);
        assert (dstCoords != null);
        assert (imgPath != null && !imgPath.equals(""));
        assert (outputFileName != null && !outputFileName.equals(""));
        assert (map != null);
        this.crsTarget = crsTarget;
        this.srcCoords = srcCoords;
        this.dstCoords = dstCoords;
        this.map = map;
        this.image = this.createImage(imgPath);
        this.outputFileName = outputFileName;
    }

    private BufferedImage createImage(String imgPath) {
        BufferedImage image = null;
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(new File(imgPath)));
            image = ImageIO.read(bis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public void run() throws IOException {
        WarpTransform2D warpTransform = new WarpTransform2D(this.srcCoords, this.dstCoords, 1);
        DefaultDerivedCRS derivedCRS = new DefaultDerivedCRS("imageCRS", this.crsTarget, (MathTransform)warpTransform, (CoordinateSystem)DefaultCartesianCS.GENERIC_2D);
        GridCoverageFactory factory = new GridCoverageFactory();
        ReferencedEnvelope ref = new ReferencedEnvelope(0.0, (double)this.image.getWidth(null), 0.0, (double)this.image.getHeight(null), (CoordinateReferenceSystem)derivedCRS);
        GridCoverage2D coverage = factory.create((CharSequence)"GridCoverage", (RenderedImage)this.image, (Envelope)ref);
        GridCoverage2D warpedCoverage = null;
        try {
            Operations ops = new Operations(null);
            Coverage resample = ops.resample((Coverage)coverage, this.crsTarget);
            warpedCoverage = (GridCoverage2D)resample;
            this.saveImage(warpedCoverage);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Failed generating the file " + this.outputFileName);
        }
    }

    private void saveImage(GridCoverage2D warpedCoverage) throws IOException {
        if (warpedCoverage != null) {
            this.writeTif(warpedCoverage, this.outputFileName);
        }
    }

    private void writeTif(GridCoverage2D warpedCoverage, String filename) throws IOException {
        if (!filename.contains(".tif")) {
            filename = String.valueOf(filename) + ".tif";
        }
        GeoTiffWriter writer = new GeoTiffWriter((Object)new File(filename));
        writer.write((GridCoverage)warpedCoverage.view(ViewType.GEOPHYSICS), null);
        File tempfile = new File(filename);
        IGeoResource tiffResource = null;
        try {
            writer = new GeoTiffWriter((Object)tempfile);
            writer.write((GridCoverage)warpedCoverage.view(ViewType.GEOPHYSICS), null);
            tiffResource = this.getTiffResource(tempfile.toURI().toURL());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        if (tiffResource != null) {
            ApplicationGIS.addLayersToMap((IMap)this.map, Collections.singletonList(tiffResource), (int)-1);
        }
    }

    private IGeoResource getTiffResource(URL url) {
        IServiceFactory factory = CatalogPlugin.getDefault().getServiceFactory();
        List services = factory.createService(url);
        if (services.isEmpty()) {
            return null;
        }
        for (IService service : services) {
            try {
                IResolve resolve = (IResolve)service.members(null).get(0);
                IGeoResource geoR = (IGeoResource)resolve.resolve(IGeoResource.class, (IProgressMonitor)new NullProgressMonitor());
                return geoR;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

