/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeRelease;
import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.logging.Loggers;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.Session;
import org.geotools.arcsde.session.UnavailableConnectionException;

class SessionPool
implements ISessionPool {
    private static final Logger LOGGER = Loggers.getLogger("org.geotools.arcsde.session");
    protected static final Level INFO_LOG_LEVEL = Level.WARNING;
    private SeConnectionFactory seConnectionFactory;
    protected ArcSDEConnectionConfig config;
    private GenericObjectPool pool;
    private final Queue<Session> openSessionsNonTransactional = new LinkedList<Session>();

    protected SessionPool(ArcSDEConnectionConfig config) throws IOException {
        if (config == null) {
            throw new NullPointerException("parameter config can't be null");
        }
        this.config = config;
        LOGGER.fine("populating ArcSDE connection pool");
        this.seConnectionFactory = this.createConnectionFactory();
        int minConnections = config.getMinConnections();
        int maxConnections = config.getMaxConnections();
        if (minConnections > maxConnections) {
            throw new IllegalArgumentException("pool.minConnections > pool.maxConnections");
        }
        GenericObjectPool.Config poolCfg = new GenericObjectPool.Config();
        poolCfg.maxActive = config.getMaxConnections();
        poolCfg.minIdle = 0;
        poolCfg.maxIdle = -1;
        poolCfg.maxWait = config.getConnTimeOut().longValue();
        poolCfg.whenExhaustedAction = poolCfg.maxWait > 0L ? (byte)1 : 0;
        poolCfg.testOnBorrow = true;
        poolCfg.testOnReturn = false;
        poolCfg.testWhileIdle = false;
        poolCfg.minEvictableIdleTimeMillis = 300000L;
        this.pool = new GenericObjectPool((PoolableObjectFactory)this.seConnectionFactory, poolCfg);
        LOGGER.fine("Created ArcSDE connection pool for " + config);
        ISession[] preload = new ISession[minConnections];
        try {
            int i;
            for (i = 0; i < minConnections; ++i) {
                preload[i] = (ISession)this.pool.borrowObject();
                if (i != 0) continue;
                SeRelease seRelease = preload[i].getRelease();
                String sdeDesc = seRelease.getDesc();
                int major = seRelease.getMajor();
                int minor = seRelease.getMinor();
                int bugFix = seRelease.getBugFix();
                String desc = "ArcSDE " + major + "." + minor + "." + bugFix + " " + sdeDesc;
                LOGGER.fine("Connected to " + desc);
            }
            for (i = 0; i < minConnections; ++i) {
                this.pool.returnObject(preload[i]);
            }
        }
        catch (Exception e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    protected SeConnectionFactory createConnectionFactory() {
        return new SeConnectionFactory(this.config);
    }

    @Override
    public int getPoolSize() {
        this.checkOpen();
        return this.pool.getMaxActive();
    }

    @Override
    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
                this.pool = null;
                LOGGER.fine("SDE connection pool closed. ");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Closing pool: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.pool == null;
    }

    private void checkOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("This session pool is closed");
        }
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public synchronized int getAvailableCount() {
        this.checkOpen();
        return this.pool.getMaxActive() - this.pool.getNumActive();
    }

    @Override
    public int getInUseCount() {
        this.checkOpen();
        return this.pool.getNumActive();
    }

    @Override
    public ISession getSession() throws IOException, UnavailableConnectionException {
        return this.getSession(true);
    }

    public synchronized void returnObject(Session session) throws Exception {
        this.openSessionsNonTransactional.remove(session);
        this.pool.returnObject(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISession getSession(boolean transactional) throws IOException, UnavailableConnectionException {
        this.checkOpen();
        try {
            Session connection = null;
            if (transactional) {
                LOGGER.finest("Borrowing session from pool for transactional access");
                connection = (Session)this.pool.borrowObject();
            } else {
                Queue<Session> queue = this.openSessionsNonTransactional;
                synchronized (queue) {
                    try {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Grabbing session from pool on " + Thread.currentThread().getName());
                        }
                        connection = (Session)this.pool.borrowObject();
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Got session from the pool on " + Thread.currentThread().getName());
                        }
                    }
                    catch (NoSuchElementException e) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("No available sessions in the pool, falling back to queued session");
                        }
                        connection = this.openSessionsNonTransactional.remove();
                    }
                    this.openSessionsNonTransactional.add(connection);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Got session from the in use queue on " + Thread.currentThread().getName());
                    }
                }
            }
            connection.markActive();
            return connection;
        }
        catch (NoSuchElementException e) {
            LOGGER.log(Level.WARNING, "Out of connections: " + e.getMessage() + ". Config: " + this.config);
            throw new UnavailableConnectionException(this.config.getMaxConnections(), this.config);
        }
        catch (SeException se) {
            ArcSdeException sdee = new ArcSdeException(se);
            LOGGER.log(Level.WARNING, "ArcSDE error getting connection for " + this.config, sdee);
            throw sdee;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unknown problem getting connection: " + e.getMessage(), e);
            throw (IOException)new IOException("Unknown problem fetching connection from connection pool").initCause(e);
        }
    }

    @Override
    public ArcSDEConnectionConfig getConfig() {
        return this.config;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.getClass().getSimpleName());
        ret.append("[config=").append(this.getConfig());
        if (this.pool == null) {
            ret.append("[Session pool is disposed]");
        } else {
            ret.append("[ACTIVE: ");
            ret.append(this.pool.getNumActive() + "/" + this.pool.getMaxActive());
            ret.append(" INACTIVE: ");
            ret.append(this.pool.getNumIdle() + "/" + this.pool.getMaxIdle() + "]");
        }
        ret.append("]");
        return ret.toString();
    }

    private class SeConnectionFactory
    extends BasePoolableObjectFactory {
        private ArcSDEConnectionConfig config;

        public SeConnectionFactory(ArcSDEConnectionConfig config) {
            this.config = config;
        }

        @Override
        public synchronized Object makeObject() throws IOException {
            Session seConn = new Session(SessionPool.this, this.config);
            return seConn;
        }

        @Override
        public void passivateObject(Object obj) {
            LOGGER.finest("    passivating connection " + obj);
            Session conn = (Session)obj;
            conn.markInactive();
        }

        @Override
        public boolean validateObject(Object obj) {
            boolean valid;
            ISession session = (ISession)obj;
            boolean bl = valid = !session.isClosed();
            if (valid) {
                try {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("    Validating SDE Connection " + session);
                    }
                    session.testServer();
                }
                catch (IOException e) {
                    LOGGER.info("Can't validate SeConnection, discarding it: " + session + ". Reason: " + e.getMessage());
                    valid = false;
                }
            }
            return valid;
        }

        @Override
        public void destroyObject(Object obj) {
            Session conn = (Session)obj;
            conn.destroy();
        }
    }
}

