/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.palette;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import net.refractions.udig.ui.palette.Friendly;
import net.refractions.udig.ui.palette.Scheme;
import net.refractions.udig.ui.palette.SchemeType;
import org.geotools.util.SimpleInternationalString;

public class Palette {
    final SimpleInternationalString name;
    public final List<Scheme> contents;
    public final SchemeType type;
    static final int GOOD = 1;
    static final int DOUBTFUL = 0;
    static final int BAD = -1;

    public Palette(String name, Scheme[] list) {
        this.name = new SimpleInternationalString(name);
        this.contents = Arrays.asList(list);
        this.type = SchemeType.QUALITATIVE;
    }

    public Palette(String pal) throws IOException {
        this(Palette.load(pal));
    }

    static final Properties load(String pal) throws IOException {
        URL find = Palette.class.getResource(pal);
        Properties load = new Properties();
        load.load(find.openStream());
        return load;
    }

    public Palette(Properties properties) {
        String KEY = properties.getProperty("palette.key");
        this.name = new SimpleInternationalString(properties.getProperty("palette.display"));
        this.type = Enum.valueOf(SchemeType.class, properties.getProperty("palette.type").trim());
        int min = Integer.parseInt(properties.getProperty("palette.min"));
        int max = Integer.parseInt(properties.getProperty("palette.max"));
        this.contents = new ArrayList<Scheme>();
        int i = min;
        while (i <= max) {
            String defn = properties.getProperty(String.valueOf(KEY) + i);
            ArrayList<Color> colours = new ArrayList<Color>();
            defn = defn.replace("},", "|");
            defn = defn.replace('}', ' ');
            defn = defn.replace('{', ' ');
            defn = Palette.noWhitespace(defn);
            String[] stringArray = defn.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                if (c.length() != 0) {
                    String[] rgb = c.trim().split(",");
                    int r = Integer.parseInt(rgb[0].trim());
                    int g = Integer.parseInt(rgb[1].trim());
                    int b = Integer.parseInt(rgb[2].trim());
                    colours.add(new Color(r, g, b));
                }
                ++n2;
            }
            String goodDefn = Palette.noWhitespace(properties.getProperty(String.valueOf(KEY) + i + ".good"));
            EnumSet<Friendly> good = Friendly.parse(goodDefn);
            String doubtfulDefn = Palette.noWhitespace(properties.getProperty(String.valueOf(KEY) + i + ".doubtful"));
            EnumSet<Friendly> doubtful = Friendly.parse(doubtfulDefn);
            Scheme scheme = new Scheme(colours, good, doubtful);
            this.contents.add(scheme);
            ++i;
        }
    }

    static final String noWhitespace(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!Character.isWhitespace(c)) {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }
}

