/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.ui.palette.ColourScheme;

public class ColourPalette {
    private HashMap<String, ColourScheme> allColourSchemes = new HashMap();
    private String paletteType;

    public ColourPalette() {
        this.paletteType = null;
    }

    public ColourPalette(String type) {
        this.paletteType = type;
    }

    public void addColourScheme(String schemeName, ColourScheme scheme) {
        if (!this.allColourSchemes.containsKey(schemeName)) {
            this.allColourSchemes.put(schemeName, scheme);
        }
    }

    public Map<String, ColourScheme> getAllColourSchemes() {
        return Collections.unmodifiableMap(this.allColourSchemes);
    }

    public void setAllColourSchemes(HashMap<String, ColourScheme> allColourSchemes) {
        this.allColourSchemes = allColourSchemes;
    }

    public List<String> getAllSchemeNames() {
        Set<String> set = this.allColourSchemes.keySet();
        ArrayList<String> returnable = new ArrayList<String>();
        returnable.addAll(set);
        return returnable;
    }

    public String getPaletteType() {
        return this.paletteType;
    }

    public void setPaletteType(String paletteType) {
        this.paletteType = paletteType;
    }

    public ColourScheme getColourSchemeByName(String name) {
        return this.allColourSchemes.get(name);
    }
}

