/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.operations.FilterParser;
import net.refractions.udig.ui.operations.OpFilter;
import net.refractions.udig.ui.operations.OpFilterPropertyValueCondition;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class PropertyParser
implements FilterParser {
    @Override
    public OpFilter parse(IConfigurationElement element) {
        String desiredPropertyId = element.getAttribute("propertyId");
        if (desiredPropertyId == null || desiredPropertyId.trim().length() == 0) {
            desiredPropertyId = element.getAttribute("name");
        }
        String expectedValue = element.getAttribute("expectedValue");
        if (desiredPropertyId == null || desiredPropertyId.length() == 0) {
            UiPlugin.log("EnablesFor element is not valid. PropertyId must be supplied.", null);
            return OpFilter.TRUE;
        }
        IConfigurationElement[] configuration = Platform.getExtensionRegistry().getConfigurationElementsFor("net.refractions.udig.ui.objectProperty");
        IConfigurationElement propertyElement = null;
        String targetClass = null;
        IConfigurationElement[] iConfigurationElementArray = configuration;
        int n = configuration.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (propertyElement != null) break;
            IConfigurationElement[] iConfigurationElementArray2 = children = configurationElement.getChildren("property");
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                String currentPropertyID = child.getAttribute("id");
                String currentPropertyID2 = String.valueOf(child.getNamespaceIdentifier()) + "." + currentPropertyID;
                if (currentPropertyID.equals(desiredPropertyId) || currentPropertyID2.equals(desiredPropertyId)) {
                    propertyElement = child;
                    targetClass = configurationElement.getAttribute("targetClass");
                    if (targetClass != null && targetClass.trim().length() != 0) break;
                    targetClass = configurationElement.getAttribute("class");
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (propertyElement == null) {
            UiPlugin.log("PropertyParser: Parsing PropertyValue, desired Propert: " + desiredPropertyId + " not found.  Referenced in plugin: " + element.getNamespaceIdentifier(), null);
            return OpFilter.TRUE;
        }
        if (targetClass == null) {
            UiPlugin.log("PropertyParser: Parsing PropertyValue, no target class defined in property" + desiredPropertyId, null);
            return OpFilter.TRUE;
        }
        OpFilterPropertyValueCondition enablesFor = new OpFilterPropertyValueCondition(propertyElement, targetClass, expectedValue);
        return enablesFor;
    }

    @Override
    public String getElementName() {
        return "property";
    }
}

