/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import java.util.ArrayList;
import java.util.Iterator;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.internal.ui.operations.OperationMenuFactory;
import net.refractions.udig.ui.internal.Messages;
import net.refractions.udig.ui.operations.OpAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class OperationDialog
extends TitleAreaDialog
implements ITreeContentProvider {
    private TreeViewer viewer;
    private ISelection selection;

    public boolean isEnabled(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof OperationCategory) {
            return !((OperationCategory)((Object)element)).isEmpty();
        }
        if (element instanceof OpAction) {
            return ((OpAction)((Object)element)).isEnabled();
        }
        return true;
    }

    public OperationDialog(Shell parentShell, ISelection selection) {
        super(parentShell);
        this.selection = selection;
    }

    protected int getShellStyle() {
        return 66768;
    }

    public void dispose() {
        this.selection = null;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Operations");
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle("Operations");
        this.setMessage("What would you like to do:");
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Tree tree = new Tree(composite, 514);
        this.viewer = new TreeViewer(tree);
        GridData gridData = new GridData(1808);
        gridData.heightHint = -1;
        gridData.widthHint = -1;
        gridData.verticalSpan = 4;
        tree.setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)new OperationLabelProvider());
        this.viewer.setInput((Object)this);
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                if (s.isEmpty()) {
                    return;
                }
                Button button = OperationDialog.this.getButton(0);
                Object selection = s.getFirstElement();
                if (selection instanceof OperationDialog) {
                    OperationDialog.this.setMessage("What would you like to do:");
                    button.setEnabled(false);
                } else if (selection instanceof OperationCategory) {
                    OperationCategory category = (OperationCategory)((Object)selection);
                    if (category.getDescription() != null) {
                        OperationDialog.this.setMessage(category.getDescription());
                    } else {
                        OperationDialog.this.setMessage("Please select an operation:");
                    }
                    button.setEnabled(false);
                } else if (selection instanceof OpAction) {
                    OpAction action = (OpAction)((Object)selection);
                    OperationDialog.this.setMessage(action.getDescription());
                    button.setEnabled(action.isEnabled());
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OperationDialog.this.buttonPressed(0);
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, Messages.OperationDialog_Operate, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Iterator iter = selection.iterator();
            new ArrayList();
            while (iter.hasNext()) {
                Object selected = iter.next();
                if (!(selected instanceof OpAction)) continue;
                OpAction action = (OpAction)((Object)selected);
                action.run();
            }
            Button button = this.getButton(0);
        }
        super.buttonPressed(buttonId);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof OperationCategory) {
            OperationCategory operationCategory = (OperationCategory)((Object)inputElement);
            return operationCategory.getActions().toArray();
        }
        if (inputElement instanceof OperationDialog) {
            OperationMenuFactory factory = UiPlugin.getDefault().getOperationMenuFactory();
            return factory.getCategories().values().toArray();
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof OpAction) {
            OpAction action = (OpAction)((Object)element);
            return action.category;
        }
        if (element instanceof OperationCategory) {
            return this;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof OperationDialog) {
            return true;
        }
        if (element instanceof OperationCategory) {
            return !((OperationCategory)((Object)element)).isEmpty();
        }
        return false;
    }

    private class OperationLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private OperationLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof OperationDialog) {
                return ((OperationDialog)((Object)element)).getTitleImageLabel().getText();
            }
            if (element instanceof OperationCategory) {
                return ((OperationCategory)((Object)element)).getMenuText();
            }
            if (element instanceof OpAction) {
                return ((OpAction)((Object)element)).getText();
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (OperationDialog.this.isEnabled(element)) {
                return null;
            }
            return Display.getCurrent().getSystemColor(15);
        }
    }
}

