/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.operations.And;
import net.refractions.udig.ui.operations.FilterParser;
import net.refractions.udig.ui.operations.Not;
import net.refractions.udig.ui.operations.OpFilter;
import net.refractions.udig.ui.operations.Or;
import org.eclipse.core.runtime.IConfigurationElement;

public class OpFilterParser {
    FilterParser[] filterParsers;

    public OpFilterParser(FilterParser[] filterParser) {
        assert (filterParser != null);
        int i = 0;
        if (filterParser != null) {
            i = filterParser.length;
        }
        this.filterParsers = new FilterParser[i];
        System.arraycopy(filterParser, 0, this.filterParsers, 0, i);
    }

    public OpFilter parseFilter(IConfigurationElement element) {
        if (element == null) {
            UiPlugin.log("OpFilterParser: Parsing OpFilter, Configuration element is null so returning OpFilter null", null);
            return OpFilter.TRUE;
        }
        String elementName = element.getName();
        if (elementName.equals("or")) {
            return this.orFilter(element);
        }
        if (elementName.equals("not")) {
            return this.notFilter(element);
        }
        if (elementName.equals("and")) {
            return this.andFilter(element);
        }
        FilterParser[] filterParserArray = this.filterParsers;
        int n = this.filterParsers.length;
        int n2 = 0;
        while (n2 < n) {
            FilterParser parser = filterParserArray[n2];
            if (elementName.equals(parser.getElementName())) {
                return parser.parse(element);
            }
            ++n2;
        }
        UiPlugin.log("OpFilterParser: Parsing OpFilter: no parser found for parsing " + element.getNamespaceIdentifier(), null);
        return OpFilter.TRUE;
    }

    private OpFilter andFilter(IConfigurationElement element) {
        And andFilter = new And();
        IConfigurationElement[] children = element.getChildren();
        if (children.length == 0) {
            UiPlugin.log("OpFilterParser: Parsing OpFilter: No children of an AND OpFilter " + element.getNamespaceIdentifier(), null);
            return OpFilter.TRUE;
        }
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element2 = iConfigurationElementArray[n2];
            andFilter.getFilters().add(this.parseFilter(element2));
            ++n2;
        }
        return andFilter;
    }

    private OpFilter notFilter(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren();
        if (!this.validateChildren(children)) {
            return OpFilter.TRUE;
        }
        return new Not(this.parseFilter(children[0]));
    }

    private OpFilter orFilter(IConfigurationElement element) {
        Or orFilter = new Or();
        IConfigurationElement[] children = element.getChildren();
        if (children.length == 0) {
            UiPlugin.log("OpFilterParser: Parsing OpFilter: No children of an OR OpFilter " + element.getNamespaceIdentifier(), null);
            return OpFilter.TRUE;
        }
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element2 = iConfigurationElementArray[n2];
            orFilter.getFilters().add(this.parseFilter(element2));
            ++n2;
        }
        return orFilter;
    }

    private boolean validateChildren(IConfigurationElement[] children) {
        if (children.length < 1) {
            return false;
        }
        if (children.length > 1) {
            UiPlugin.log("OpFilterParser: Error, more than one enablement element " + children[0].getDeclaringExtension().getExtensionPointUniqueIdentifier(), new Exception());
            return false;
        }
        return true;
    }
}

