/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import java.lang.reflect.Array;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.refractions.udig.core.AdapterUtil;
import net.refractions.udig.internal.ui.URLImageDescriptor;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.ui.internal.Messages;
import net.refractions.udig.ui.operations.EnablementUtil;
import net.refractions.udig.ui.operations.IOp;
import net.refractions.udig.ui.operations.OpFilter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class OpAction
extends Action
implements ISelectionListener {
    IConfigurationElement configElem;
    volatile IStructuredSelection selection;
    private IOp operation;
    private RunJob runJob;
    private String targetClass;
    OperationCategory category;
    String menuPath;
    private OpFilter filter;
    private EnablementUtil.EnablesForData enablesForData;
    private volatile NullProgressMonitor monitor = new NullProgressMonitor();
    private boolean loadingError;
    private static final Executor executor = Executors.newFixedThreadPool(1);

    public OpAction(IConfigurationElement element) {
        String tooltip;
        this.configElem = element;
        this.setId(element.getAttribute("id"));
        this.setText(element.getAttribute("name"));
        String icon = element.getAttribute("icon");
        if (icon != null) {
            this.setImageDescriptor(this.createImageDescriptor(icon, element));
        }
        if ((tooltip = element.getAttribute("tooltip")) != null) {
            this.setToolTipText(tooltip);
        }
        this.targetClass = element.getAttribute("targetClass");
        this.menuPath = element.getAttribute("menuPath");
        this.runJob = new RunJob(this.getText());
        this.enablesForData = EnablementUtil.parseEnablesFor(element.getAttribute("enablesFor"), this.configElem);
        this.filter = EnablementUtil.parseEnablement(String.valueOf(element.getNamespaceIdentifier()) + "." + element.getName(), element.getChildren("enablement"));
    }

    private ImageDescriptor createImageDescriptor(String icon, IConfigurationElement element) {
        URL url = Platform.getBundle((String)element.getNamespaceIdentifier()).getEntry(icon);
        return new URLImageDescriptor(url);
    }

    public void run() {
        this.runJob.display = Display.getCurrent();
        this.runJob.schedule();
    }

    public void runWithEvent(Event event) {
        this.runJob.display = event.display;
        this.runJob.schedule();
    }

    IOp getOperation() {
        if (this.operation == null) {
            try {
                this.operation = (IOp)this.configElem.createExecutableExtension("class");
            }
            catch (CoreException e) {
                UiPlugin.log("Error loading operation implementation", e);
                final Display display = Display.getDefault();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        OpAction.this.setEnabled(false);
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.OpAction_errorTitle, (String)Messages.OpAction_errorMessage);
                    }
                };
                this.loadingError = true;
                display.asyncExec(runnable);
            }
        }
        return this.operation;
    }

    public boolean isValid(Object obj) {
        return !this.loadingError && AdapterUtil.instance.canAdaptTo(this.targetClass, obj) && this.filter.accept(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            OpAction opAction = this;
            synchronized (opAction) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                this.updateEnablement(structured, false);
            }
        }
    }

    public void updateEnablement(IStructuredSelection structured, boolean executeSynchronous) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        NullProgressMonitor lastMonitor = this.monitor;
        this.monitor = new NullProgressMonitor();
        lastMonitor.setCanceled(true);
        SetEnablement enablement = new SetEnablement(structured, (IProgressMonitor)this.monitor, executeSynchronous);
        if (!executeSynchronous) {
            this.setEnabled(false);
            executor.execute(enablement);
        } else {
            enablement.run();
        }
    }

    public void setCategory(OperationCategory category) {
        this.category = category;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public String toString() {
        return String.valueOf(this.getMenuPath()) + "/" + this.getText();
    }

    class RunJob
    extends Job {
        Display display;

        public RunJob(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            return family == OpAction.class;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Object target;
                block10: {
                    if (((OpAction)OpAction.this).enablesForData.minHits == 1 && ((OpAction)OpAction.this).enablesForData.exactMatch) {
                        try {
                            target = AdapterUtil.instance.adapt(OpAction.this.targetClass, OpAction.this.selection.getFirstElement(), monitor);
                            if (target == null) {
                                UiPlugin.log("Factory adapting " + OpAction.this.selection.getFirstElement().getClass().getName() + " to a " + OpAction.this.targetClass + " is returning null even though it is advertising that it can " + "do the adaptation", null);
                                return Status.OK_STATUS;
                            }
                            break block10;
                        }
                        catch (Throwable e) {
                            UiPlugin.log(null, e);
                            return Status.OK_STATUS;
                        }
                    }
                    LinkedList<Object> targets = new LinkedList<Object>();
                    for (Object entry : OpAction.this.selection) {
                        try {
                            Object operationTarget = AdapterUtil.instance.adapt(OpAction.this.targetClass, entry, monitor);
                            if (operationTarget == null) {
                                UiPlugin.log("Factory adapting " + entry.getClass().getName() + " to a " + OpAction.this.targetClass + " is returning null even though it is advertising that it can " + "do the adaptation", null);
                                return Status.OK_STATUS;
                            }
                            targets.add(operationTarget);
                        }
                        catch (Throwable e) {
                            UiPlugin.log(null, e);
                            return Status.OK_STATUS;
                        }
                    }
                    Class<?> targetClass = targets.get(0).getClass();
                    Object[] tmp = (Object[])Array.newInstance(targetClass, targets.size());
                    target = ((OpAction)OpAction.this).enablesForData.minHits == 1 && ((OpAction)OpAction.this).enablesForData.exactMatch ? (targets.size() > 0 ? targets.get(0) : null) : targets.toArray(tmp);
                }
                IOp op = OpAction.this.getOperation();
                op.op(this.display, target, monitor);
            }
            catch (Throwable e) {
                UiPlugin.log(null, e);
            }
            return Status.OK_STATUS;
        }
    }

    private class SetEnablement
    implements Runnable {
        private IStructuredSelection structured;
        private IProgressMonitor monitor;
        private boolean execSync;

        public SetEnablement(IStructuredSelection structured, IProgressMonitor monitor, boolean executeSynchronous) {
            this.structured = structured;
            this.monitor = monitor;
            this.execSync = executeSynchronous;
        }

        @Override
        public void run() {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            boolean enabled = false;
            int hits = 0;
            Iterator iter = this.structured.iterator();
            while (iter.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                Object obj = iter.next();
                if (OpAction.this.isValid(obj)) {
                    ++hits;
                    continue;
                }
                hits = -1;
                break;
            }
            if (this.monitor.isCanceled()) {
                return;
            }
            if (hits >= ((OpAction)OpAction.this).enablesForData.minHits) {
                if (((OpAction)OpAction.this).enablesForData.exactMatch && hits == ((OpAction)OpAction.this).enablesForData.minHits) {
                    enabled = true;
                } else if (!((OpAction)OpAction.this).enablesForData.exactMatch && hits >= ((OpAction)OpAction.this).enablesForData.minHits) {
                    enabled = true;
                }
            }
            final boolean finalEnabled = enabled;
            final boolean oldEnabledState = OpAction.this.isEnabled();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((SetEnablement)SetEnablement.this).OpAction.this.selection = SetEnablement.this.structured;
                    OpAction.this.setEnabled(finalEnabled);
                    if (((SetEnablement)SetEnablement.this).OpAction.this.category != null && oldEnabledState != finalEnabled) {
                        ((SetEnablement)SetEnablement.this).OpAction.this.category.enablementChanged();
                    }
                }
            };
            if (this.execSync) {
                if (Display.getCurrent() != null) {
                    runnable.run();
                } else {
                    Display.getDefault().syncExec(runnable);
                }
            } else {
                Display.getDefault().asyncExec(runnable);
            }
        }
    }
}

