/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.operations.AdaptsToParserImpl;
import net.refractions.udig.ui.operations.FilterParser;
import net.refractions.udig.ui.operations.OpFilter;
import net.refractions.udig.ui.operations.OpFilterParser;
import net.refractions.udig.ui.operations.PropertyParser;
import org.eclipse.core.runtime.IConfigurationElement;

public class EnablementUtil {
    public static OpFilter parseEnablement(String extensionID, IConfigurationElement[] enablement) {
        if (!EnablementUtil.validateChildren(extensionID, enablement) || enablement[0] == null) {
            if (enablement.length > 0 && enablement[0] == null) {
                UiPlugin.log("EnablementUtil: null enablement", null);
            }
            return OpFilter.TRUE;
        }
        IConfigurationElement[] children = enablement[0].getChildren();
        if (!EnablementUtil.validateChildren(extensionID, children)) {
            UiPlugin.log("EnablementUtil: Expected child of " + extensionID + " but didn't find one...", null);
            return OpFilter.TRUE;
        }
        OpFilterParser parser = new OpFilterParser(new FilterParser[]{new AdaptsToParserImpl(), new PropertyParser()});
        return parser.parseFilter(children[0]);
    }

    private static boolean validateChildren(String extensionID, IConfigurationElement[] children) {
        if (children.length < 1) {
            return false;
        }
        if (children.length > 1) {
            UiPlugin.log("EnablementUtil: Error, more than one enablement element " + extensionID, null);
            return false;
        }
        return true;
    }

    public static EnablesForData parseEnablesFor(String enablesFor, IConfigurationElement configElem) {
        if (enablesFor == null) {
            enablesFor = "1";
        }
        enablesFor = enablesFor.trim();
        EnablesForData data = new EnablesForData();
        if (enablesFor.equals("+")) {
            data.minHits = 1;
            data.exactMatch = false;
        } else if (enablesFor.equals("multiple")) {
            data.minHits = 2;
            data.exactMatch = false;
        } else if (enablesFor.equals("2+")) {
            data.minHits = 2;
            data.exactMatch = false;
        } else {
            try {
                data.minHits = Integer.parseInt(enablesFor);
                data.exactMatch = true;
            }
            catch (Exception e) {
                UiPlugin.log("Error parsing extension: " + configElem.getNamespace() + "/" + configElem.getName(), e);
                data.minHits = 0;
                data.exactMatch = false;
            }
        }
        return data;
    }

    public static class EnablesForData {
        int minHits = 0;
        boolean exactMatch = false;
    }
}

