/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.graphics;

import net.refractions.udig.ui.graphics.TableSettings;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TableUtils {
    public static final int MODE_LAZY = 1;
    public static final int MODE_AUTO = 2;
    public static final int MODE_JUMP = 3;

    public static void resizeColumns(Table table, TableSettings settings, int mode) {
        int oldMode;
        int mode2 = mode;
        table.setRedraw(false);
        int tableWidth = table.getSize().x;
        int columnCount = table.getColumnCount();
        int columnSum = 0;
        if (mode2 <= 0) {
            mode2 = 3;
        }
        if ((oldMode = settings.getCurrentMode()) == 0) {
            settings.setCurrentMode(mode2);
        }
        if (mode2 == 3) {
            mode2 = oldMode != mode2 ? oldMode : 2;
        }
        int i = 0;
        while (i < columnCount - 1) {
            int width;
            int minWidth = settings.getColumnMin(i);
            int maxWidth = (int)(settings.getColumnMax(i) * (double)tableWidth);
            TableColumn column = table.getColumn(i);
            if (mode2 == 2) {
                column.pack();
            }
            if ((width = column.getWidth()) < minWidth) {
                if (columnCount * minWidth <= tableWidth) {
                    column.setWidth(minWidth);
                }
            } else if (width > maxWidth) {
                column.setWidth(maxWidth);
            }
            columnSum += width;
            ++i;
        }
        TableColumn column = table.getColumn(columnCount - 1);
        column.setWidth(tableWidth - columnSum - 2 * table.getBorderWidth());
        table.setRedraw(true);
    }

    public static void resizeColumns(Tree treeTable, TableSettings settings, int mode) {
        int oldMode;
        int mode2 = mode;
        treeTable.setRedraw(false);
        int tableWidth = treeTable.getSize().x;
        int columnCount = treeTable.getColumnCount();
        int columnSum = 0;
        if (mode2 <= 0) {
            mode2 = 3;
        }
        if ((oldMode = settings.getCurrentMode()) == 0) {
            settings.setCurrentMode(mode2);
        }
        if (mode2 == 3) {
            mode2 = oldMode != mode2 ? oldMode : 2;
        }
        int i = 0;
        while (i < columnCount - 1) {
            int minWidth = settings.getColumnMin(i);
            int maxWidth = (int)(settings.getColumnMax(i) * (double)tableWidth);
            TreeColumn column = treeTable.getColumn(i);
            if (mode2 == 2) {
                column.pack();
            }
            if (column.getWidth() < minWidth) {
                if (columnCount * minWidth <= tableWidth) {
                    column.setWidth(minWidth);
                }
            } else if (column.getWidth() > maxWidth) {
                column.setWidth(maxWidth);
            }
            columnSum += column.getWidth();
            ++i;
        }
        TreeColumn column = treeTable.getColumn(columnCount - 1);
        column.setWidth(tableWidth - columnSum - 2 * treeTable.getBorderWidth() - 1);
        treeTable.setRedraw(true);
    }
}

