/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.graphics;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.swt.graphics.FontData;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.NameImpl;
import org.geotools.filter.Filters;
import org.geotools.sld.v1_1.SLDConfiguration;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.style.GraphicalSymbol;

public class SLDs
extends SLD {
    private static StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    public static final double ALIGN_LEFT = 1.0;
    public static final double ALIGN_CENTER = 0.5;
    public static final double ALIGN_RIGHT = 0.0;
    public static final double ALIGN_BOTTOM = 1.0;
    public static final double ALIGN_MIDDLE = 0.5;
    public static final double ALIGN_TOP = 0.0;
    public static final String GENERIC_FEATURE_TYPENAME = "Feature";

    public static int size(org.opengis.style.Graphic graphic) {
        if (graphic == null) {
            return -1;
        }
        return Filters.asInt((Expression)graphic.getSize());
    }

    public static Color polyFill(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return null;
        }
        Expression color = fill.getColor();
        return SLDs.color(color);
    }

    public static Color color(Expression expr) {
        if (expr == null) {
            return null;
        }
        try {
            return (Color)expr.evaluate(null, Color.class);
        }
        catch (Throwable throwable) {
            class ColorVisitor
            implements ExpressionVisitor {
                Color found;

                ColorVisitor() {
                }

                public Object visit(Literal expr, Object data) {
                    if (this.found != null) {
                        return null;
                    }
                    try {
                        Color color = (Color)expr.evaluate((Object)expr, Color.class);
                        if (color != null) {
                            this.found = color;
                        }
                    }
                    catch (Throwable throwable) {}
                    return data;
                }

                public Object visit(NilExpression arg0, Object data) {
                    return data;
                }

                public Object visit(Add arg0, Object data) {
                    return data;
                }

                public Object visit(Divide arg0, Object data) {
                    return null;
                }

                public Object visit(Function function, Object data) {
                    for (Expression param : function.getParameters()) {
                        param.accept((ExpressionVisitor)this, data);
                    }
                    return data;
                }

                public Object visit(Multiply arg0, Object data) {
                    return data;
                }

                public Object visit(PropertyName arg0, Object data) {
                    return data;
                }

                public Object visit(Subtract arg0, Object data) {
                    return data;
                }
            }
            ColorVisitor search = new ColorVisitor();
            expr.accept((ExpressionVisitor)search, null);
            return search.found;
        }
    }

    public static FontData[] textFont(TextSymbolizer symbolizer) {
        Font font = SLDs.font(symbolizer);
        if (font == null) {
            return null;
        }
        FontData[] tempFD = new FontData[1];
        Expression fontFamilyExpression = (Expression)font.getFamily().get(0);
        Expression sizeExpression = font.getSize();
        if (sizeExpression == null || fontFamilyExpression == null) {
            return null;
        }
        Double size = (Double)sizeExpression.evaluate(null, Double.class);
        try {
            String fontFamily = (String)fontFamilyExpression.evaluate(null, String.class);
            tempFD[0] = new FontData(fontFamily, size.intValue(), 1);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        if (tempFD[0] != null) {
            return tempFD;
        }
        return null;
    }

    public static String[] colors(Rule rule) {
        HashSet<String> colorSet = new HashSet<String>();
        Color color = null;
        for (Symbolizer sym : rule.symbolizers()) {
            PolygonSymbolizer symb;
            if (sym instanceof PolygonSymbolizer) {
                symb = (PolygonSymbolizer)sym;
                color = SLDs.polyFill(symb);
            } else if (sym instanceof LineSymbolizer) {
                symb = (LineSymbolizer)sym;
                color = SLDs.color((LineSymbolizer)symb);
            } else if (sym instanceof PointSymbolizer) {
                symb = (PointSymbolizer)sym;
                color = SLDs.pointFillWithAlpha((PointSymbolizer)symb);
            }
            if (color == null) continue;
            colorSet.add(SLD.colorToHex((Color)color));
        }
        if (colorSet.size() > 0) {
            return colorSet.toArray(new String[0]);
        }
        return new String[0];
    }

    public static Color pointFillWithAlpha(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Mark mark;
            Fill fill;
            if (gs == null || !(gs instanceof Mark) || (fill = (mark = (Mark)gs).getFill()) == null) continue;
            Color colour = SLDs.color(fill.getColor());
            if (colour == null) {
                return null;
            }
            Expression opacity = fill.getOpacity();
            if (opacity == null) {
                opacity = ff.literal(1.0);
            }
            float alpha = (float)Filters.asDouble((Expression)opacity);
            if ((colour = new Color((float)colour.getRed() / 255.0f, (float)colour.getGreen() / 255.0f, (float)colour.getBlue() / 255.0f, alpha)) == null) continue;
            return colour;
        }
        return null;
    }

    public static Color pointStrokeColorWithAlpha(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Mark mark;
            Stroke stroke;
            if (gs == null || !(gs instanceof Mark) || (stroke = (mark = (Mark)gs).getStroke()) == null) continue;
            Color colour = SLDs.color((Stroke)stroke);
            if (colour == null) {
                return null;
            }
            Expression opacity = stroke.getOpacity();
            if (opacity == null) {
                opacity = ff.literal(1.0);
            }
            float alpha = (float)Filters.asDouble((Expression)opacity);
            if ((colour = new Color((float)colour.getRed() / 255.0f, (float)colour.getGreen() / 255.0f, (float)colour.getBlue() / 255.0f, alpha)) == null) continue;
            return colour;
        }
        return null;
    }

    public static Font font(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Font font = symbolizer.getFont();
        return font;
    }

    public static Style getDefaultStyle(StyledLayerDescriptor sld) {
        Style[] styles = SLDs.styles((StyledLayerDescriptor)sld);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            List ftStyles = style.featureTypeStyles();
            SLDs.genericizeftStyles(ftStyles);
            if (style.isDefault()) {
                return style;
            }
            ++i;
        }
        return styles[0];
    }

    private static void genericizeftStyles(List<FeatureTypeStyle> ftStyles) {
        for (FeatureTypeStyle featureTypeStyle : ftStyles) {
            featureTypeStyle.featureTypeNames().clear();
            featureTypeStyle.featureTypeNames().add(new NameImpl(GENERIC_FEATURE_TYPENAME));
        }
    }

    public static boolean isSemanticTypeMatch(FeatureTypeStyle fts, String regex) {
        String[] identifiers = fts.getSemanticTypeIdentifiers();
        int i = 0;
        while (i < identifiers.length) {
            if (identifiers[i].matches(regex)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static double minScale(FeatureTypeStyle fts) {
        if (fts == null || fts.rules().isEmpty()) {
            return 0.0;
        }
        Rule r = (Rule)fts.rules().get(0);
        return r.getMinScaleDenominator();
    }

    public static double maxScale(FeatureTypeStyle fts) {
        if (fts == null || fts.rules().isEmpty()) {
            return Double.NaN;
        }
        Rule r = (Rule)fts.rules().get(0);
        return r.getMaxScaleDenominator();
    }

    public static FeatureTypeStyle getFeatureTypeStyle(Style s) {
        List fts = s.featureTypeStyles();
        if (!fts.isEmpty()) {
            return (FeatureTypeStyle)fts.get(0);
        }
        return null;
    }

    public static Rule getRasterSymbolizerRule(Style s) {
        for (FeatureTypeStyle featureTypeStyle : s.featureTypeStyles()) {
            for (Rule rule : featureTypeStyle.rules()) {
                Symbolizer[] symbolizerArray = rule.getSymbolizers();
                int n = symbolizerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Symbolizer symbolizer = symbolizerArray[n2];
                    if (symbolizer instanceof RasterSymbolizer) {
                        return rule;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public static StyledLayerDescriptor parseSLD(File file) throws IOException {
        Parser parser;
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        SLDConfiguration config = new SLDConfiguration();
        Reader reader = null;
        try {
            parser = new Parser((Configuration)config);
            reader = new FileReader(file);
            Object object = parser.parse(reader);
            if (object instanceof StyledLayerDescriptor) {
                StyledLayerDescriptor sld;
                StyledLayerDescriptor styledLayerDescriptor = sld = (StyledLayerDescriptor)object;
                return styledLayerDescriptor;
            }
            if (object instanceof NamedStyle) {
                StyledLayerDescriptor sld;
                NamedStyle style = (NamedStyle)object;
                StyledLayerDescriptor styledLayerDescriptor = sld = SLDs.createDefaultSLD((Style)style);
                return styledLayerDescriptor;
            }
        }
        catch (Exception ignore) {
            UiPlugin.trace(SLDs.class, "SLD 1.1 configuration failed to parse " + file, ignore);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        parser = new SLDParser(styleFactory);
        try {
            parser.setInput(file);
            StyledLayerDescriptor sld = parser.parseSLD();
            return sld;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static Style parseStyle(URL url) throws IOException {
        SLDConfiguration config = new SLDConfiguration();
        InputStream input = null;
        try {
            Parser parser = new Parser((Configuration)config);
            input = url.openStream();
            Object object = parser.parse(input);
            if (object instanceof StyledLayerDescriptor) {
                StyledLayerDescriptor sld = (StyledLayerDescriptor)object;
                Style[] array = SLDs.styles((StyledLayerDescriptor)sld);
                if (array != null && array.length > 0) {
                    Style style = array[0];
                    return style;
                }
            } else if (object instanceof NamedStyle) {
                NamedStyle style;
                NamedStyle namedStyle = style = (NamedStyle)object;
                return namedStyle;
            }
        }
        catch (Exception ignore) {
            UiPlugin.trace(SLDs.class, "SLD 1.1 configuration failed to parse " + url, ignore);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        StyleFactory factory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        SLDParser styleReader = new SLDParser(factory, url);
        Style style = styleReader.readXML()[0];
        return style;
    }

    public static Style praseStyle(File file) throws IOException {
        Parser parser;
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        SLDConfiguration config = new SLDConfiguration();
        Reader reader = null;
        try {
            parser = new Parser((Configuration)config);
            reader = new FileReader(file);
            Object object = parser.parse(reader);
            if (object instanceof StyledLayerDescriptor) {
                StyledLayerDescriptor sld = (StyledLayerDescriptor)object;
                Style[] array = SLDs.styles((StyledLayerDescriptor)sld);
                if (array != null && array.length > 0) {
                    Style style = array[0];
                    return style;
                }
            } else if (object instanceof NamedStyle) {
                NamedStyle style;
                NamedStyle namedStyle = style = (NamedStyle)object;
                return namedStyle;
            }
        }
        catch (Exception ignore) {
            UiPlugin.trace(SLDs.class, "SLD 1.1 configuration failed to parse " + file, ignore);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        parser = new SLDParser(styleFactory);
        try {
            parser.setInput(file);
            Style[] array = parser.readXML();
            if (array != null && array.length > 0) {
                return array[0];
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return null;
    }

    public static StyledLayerDescriptor createDefaultSLD(Style style) {
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[1]);
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        return sld;
    }
}

