/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.graphics;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class NonAdvancedSWTGraphics
implements ViewportGraphics {
    public static final int TRANSPARENT = 0x222222;
    private AffineTransform transform = new AffineTransform();
    private GC gc = null;
    private double[] current = new double[6];
    private double[] last = new double[6];
    private double[] move_to = new double[6];
    private Color fore = null;
    private Color back = null;
    private Display display;
    private org.eclipse.swt.graphics.Font font;

    public NonAdvancedSWTGraphics(org.eclipse.swt.graphics.Image image, Display display) {
        this(new GC((Drawable)image), display, new Dimension(image.getImageData().width, image.getImageData().height));
    }

    public NonAdvancedSWTGraphics(GC gc, Display display, Dimension displaySize) {
        this.setGraphics(gc, display);
    }

    void setGraphics(GC gc, Display display) {
        this.gc = gc;
        this.display = display;
        if (this.back != null) {
            this.back.dispose();
        }
        this.back = new Color((Device)display, 255, 255, 255);
        gc.setBackground(this.back);
        gc.setAdvanced(false);
        gc.setAntialias(1);
    }

    @Override
    public void dispose() {
        if (this.fore != null) {
            this.fore.dispose();
        }
        if (this.back != null) {
            this.back.dispose();
        }
        this.gc.dispose();
    }

    @Override
    public <T> T getGraphics(Class<T> adaptee) {
        AWTSWTImageUtils.checkAccess();
        if (adaptee.isAssignableFrom(GC.class)) {
            return adaptee.cast(this.gc);
        }
        return null;
    }

    @Override
    public void draw(Shape s) {
        PathIterator p = s.getPathIterator(this.transform, 1.0);
        if (p.isDone()) {
            return;
        }
        Path path = AWTSWTImageUtils.createPath(p, (Device)this.display);
        this.gc.drawPath(path);
        float[] points = path.getPathData().points;
        if (points.length == 2) {
            this.gc.drawPoint((int)points[0], (int)points[1]);
        }
        path.dispose();
    }

    @Override
    public void fill(Shape s) {
        this.gc.setBackground(this.fore);
        PathIterator p = s.getPathIterator(this.transform);
        Path path = AWTSWTImageUtils.createPath(p, (Device)this.display);
        this.gc.fillPath(path);
        path.dispose();
        this.gc.setBackground(this.back);
    }

    public void setAffineTransform(AffineTransform t) {
        this.transform = t;
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        int x2 = x + (int)this.transform.getTranslateX();
        int y2 = y + (int)this.transform.getTranslateY();
        this.gc.setBackground(this.fore);
        this.gc.fillRectangle(new org.eclipse.swt.graphics.Rectangle(x2, y2, width, height));
        this.gc.setBackground(this.back);
    }

    @Override
    public void setColor(java.awt.Color c) {
        Color color = new Color((Device)this.display, c.getRed(), c.getGreen(), c.getBlue());
        this.gc.setForeground(color);
        if (this.fore != null) {
            this.fore.dispose();
        }
        this.fore = color;
    }

    @Override
    public void setBackground(java.awt.Color c) {
        Color color = new Color((Device)this.display, c.getRed(), c.getGreen(), c.getBlue());
        this.gc.setBackground(color);
        if (this.back != null) {
            this.back.dispose();
        }
        this.back = color;
    }

    @Override
    public void setStroke(int style, int width) {
        switch (style) {
            case 2: {
                this.gc.setLineStyle(2);
                break;
            }
            case 4: {
                this.gc.setLineStyle(4);
                break;
            }
            case 5: {
                this.gc.setLineStyle(5);
                break;
            }
            case 3: {
                this.gc.setLineStyle(3);
                break;
            }
            case 1: {
                this.gc.setLineStyle(1);
                break;
            }
            case 6: {
                this.gc.setLineCap(2);
                this.gc.setLineJoin(2);
                this.gc.setLineStyle(1);
            }
        }
        this.gc.setLineWidth(width);
    }

    @Override
    public void setClip(Rectangle r) {
        this.gc.setClipping(r.x, r.y, r.width, r.height);
    }

    @Override
    public void translate(java.awt.Point offset) {
        this.transform.translate(offset.x, offset.y);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Color c = this.gc.getForeground();
        this.gc.setForeground(this.gc.getBackground());
        this.gc.fillRectangle(x, y, width, height);
        this.gc.setForeground(c);
    }

    @Override
    public void drawImage(RenderedImage rimage, int x, int y) {
        this.drawImage(rimage, 0, 0, rimage.getWidth(), rimage.getHeight(), x, y, x + rimage.getWidth(), y + rimage.getHeight());
    }

    public static org.eclipse.swt.graphics.Image createDefaultImage(Display display, int width, int height) {
        ImageData swtdata = null;
        int depth = 24;
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        swtdata = new ImageData(width, height, depth, palette);
        swtdata.transparentPixel = -1;
        swtdata.alpha = -1;
        swtdata.alphaData = new byte[swtdata.data.length];
        int i = 0;
        while (i < swtdata.alphaData.length) {
            swtdata.alphaData[i] = (byte)i;
            ++i;
        }
        return new org.eclipse.swt.graphics.Image((Device)display, swtdata);
    }

    public static ImageDescriptor createImageDescriptor(final RenderedImage image, final boolean transparent) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                return NonAdvancedSWTGraphics.createImageData(image, transparent);
            }
        };
    }

    public static BufferedImage createBufferedImage(int w, int h) {
        return new BufferedImage(w, h, 7);
    }

    public static org.eclipse.swt.graphics.Image createSWTImage(RenderedImage image, boolean transparent) {
        ImageData data = NonAdvancedSWTGraphics.createImageData(image, transparent);
        return new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), data);
    }

    public static ImageData createImageDataFromBytes(RenderedImage image) {
        ImageData swtdata = null;
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = 24;
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        swtdata = new ImageData(width, height, depth, palette);
        Raster raster = image.getData();
        raster.getDataElements(0, 0, width, height, swtdata.data);
        return swtdata;
    }

    public static ImageData createImageData(RenderedImage image, boolean transparent) {
        ImageData swtdata = null;
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = 24;
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        swtdata = new ImageData(width, height, depth, palette);
        int blueT = -1;
        int greenT = -1;
        int redT = -1;
        if (transparent) {
            swtdata.transparentPixel = 0x222222;
            blueT = 34;
            greenT = 34;
            redT = 34;
        }
        Raster raster = image.getData();
        int numbands = raster.getNumBands();
        int[] awtdata = raster.getPixels(0, 0, width, height, new int[width * height * numbands]);
        int step = swtdata.depth / 8;
        byte[] data = swtdata.data;
        int baseindex = 0;
        int y = 0;
        while (y < height) {
            int idx = (0 + y) * swtdata.bytesPerLine + 0 * step;
            int x = 0;
            while (x < width) {
                baseindex = (x + y * width) * numbands;
                if (numbands == 4 && awtdata[baseindex + 3] == 0) {
                    data[idx++] = blueT;
                    data[idx++] = greenT;
                    data[idx++] = redT;
                } else {
                    data[idx++] = (byte)awtdata[baseindex];
                    data[idx++] = (byte)awtdata[baseindex + 1];
                    data[idx++] = (byte)awtdata[baseindex + 2];
                }
                ++x;
            }
            ++y;
        }
        return swtdata;
    }

    @Override
    public void drawString(String string, int x, int y, int alignx, int aligny) {
        int x2;
        Point text = this.gc.stringExtent(string);
        int w = text.x;
        int h = text.y;
        int n = alignx == 0 ? x - w / 2 : (x2 = alignx > 0 ? x - w : x);
        int y2 = aligny == 0 ? y + h / 2 : (aligny > 0 ? y + h : y);
        this.gc.drawString(string, x2, y2, true);
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    @Override
    public void drawImage(Image image, int x, int y) {
        RenderedImage rimage = (RenderedImage)((Object)image);
        this.drawImage(rimage, x, y);
    }

    @Override
    public void drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        RenderedImage rimage = (RenderedImage)((Object)image);
        this.drawImage(rimage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
    }

    public void drawImage(RenderedImage rimage, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        assert (rimage != null);
        org.eclipse.swt.graphics.Image swtImage = null;
        try {
            swtImage = NonAdvancedSWTGraphics.createSWTImage(rimage, true);
            int translatedX = (int)((double)dx1 + this.transform.getTranslateX());
            int translatedY = (int)((double)dy1 + this.transform.getTranslateY());
            int translatedWidth = (int)(this.transform.getScaleX() * (double)(dx2 - dx1));
            int translatedHeight = (int)(this.transform.getScaleY() * (double)(dy2 - dy1));
            if (swtImage != null) {
                if (sx1 < 0) {
                    sx1 = 0;
                }
                if (sy1 < 0) {
                    sy1 = 0;
                }
                this.gc.drawImage(swtImage, sx1, sy1, sx2 - sx1, sy2 - sy1, translatedX, translatedY, translatedWidth, translatedHeight);
                swtImage.dispose();
            }
        }
        finally {
            if (swtImage != null) {
                swtImage.dispose();
            }
        }
    }

    @Override
    public int getFontHeight() {
        return this.gc.getFontMetrics().getHeight();
    }

    @Override
    public int stringWidth(String str) {
        return -1;
    }

    @Override
    public int getFontAscent() {
        return this.gc.getFontMetrics().getAscent();
    }

    @Override
    public Rectangle2D getStringBounds(String str) {
        Point extent = this.gc.textExtent(str);
        return new Rectangle(0, 0, extent.x, extent.y);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawImage(org.eclipse.swt.graphics.Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        int translatedX = (int)((double)dx1 + this.transform.getTranslateX());
        int translatedY = (int)((double)dy1 + this.transform.getTranslateY());
        int translatedWidth = (int)(this.transform.getScaleX() * (double)(dx2 - dx1));
        int translatedHeight = (int)(this.transform.getScaleY() * (double)(dy2 - dy1));
        this.gc.drawImage(image, sx1, sy1, sx2 - sx1, sy2 - sy1, translatedX, translatedY, translatedWidth, translatedHeight);
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public void drawPath(Path path) {
        this.gc.drawPath(path);
    }

    @Override
    public void fillPath(Path path) {
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.gc.drawRectangle(new org.eclipse.swt.graphics.Rectangle(x, y, width, height));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.gc.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval(x, y, width, height);
    }

    @Override
    public void drawImage(org.eclipse.swt.graphics.Image swtImage, int x, int y) {
        this.gc.drawImage(swtImage, x, y);
    }

    @Override
    public Shape getClip() {
        org.eclipse.swt.graphics.Rectangle clipping = this.gc.getClipping();
        return new Rectangle(clipping.x, clipping.y, clipping.width, clipping.height);
    }

    @Override
    public void setClipBounds(Rectangle newBounds) {
        this.gc.setClipping(new org.eclipse.swt.graphics.Rectangle(newBounds.x, newBounds.y, newBounds.width, newBounds.height));
    }

    @Override
    public java.awt.Color getBackgroundColor() {
        return AWTSWTImageUtils.swtColor2awtColor(this.gc, this.gc.getBackground());
    }

    @Override
    public java.awt.Color getColor() {
        return AWTSWTImageUtils.swtColor2awtColor(this.gc, this.gc.getForeground());
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gc.drawRoundRectangle(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gc.setBackground(this.fore);
        this.gc.fillRoundRectangle(x, y, width, height, arcWidth, arcHeight);
        this.gc.setBackground(this.back);
    }

    @Override
    public void setLineDash(int[] dash) {
        this.gc.setLineDash(dash);
    }

    @Override
    public void setLineWidth(int width) {
        this.gc.setLineWidth(width);
    }

    @Override
    public void setFont(Font f) {
        int size = f.getSize() * this.getDPI() / 72;
        int style = AWTSWTImageUtils.toFontStyle(f);
        org.eclipse.swt.graphics.Font swtFont = new org.eclipse.swt.graphics.Font(this.gc.getDevice(), f.getFamily(), size, style);
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = swtFont;
        this.gc.setFont(this.font);
    }

    @Override
    public int getDPI() {
        return this.gc.getDevice().getDPI().y;
    }

    @Override
    public void fillGradientRectangle(int x, int y, int width, int height, java.awt.Color startColor, java.awt.Color endColor, boolean isVertical) {
        Color color1 = new Color((Device)this.display, startColor.getRed(), startColor.getGreen(), startColor.getBlue());
        Color color2 = new Color((Device)this.display, endColor.getRed(), endColor.getGreen(), endColor.getBlue());
        this.gc.setForeground(color1);
        this.gc.setBackground(color2);
        this.gc.fillGradientRectangle(x, y, width, height, isVertical);
        color1.dispose();
        color2.dispose();
    }
}

