/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;

public class AWTGraphics
implements ViewportGraphics {
    public Graphics2D g;
    int dpi;

    public AWTGraphics(Graphics2D g) {
        this.g = g;
        g.setBackground(Color.WHITE);
        this.dpi = 72;
    }

    public AWTGraphics(Graphics2D g, int dpi) {
        this.g = g;
        this.dpi = dpi;
        g.setBackground(Color.WHITE);
        if (dpi != 72) {
            Font font = g.getFont();
            String name = font.getName();
            int style = font.getStyle();
            int size = font.getSize() * dpi / 72;
            g.setFont(new Font(name, style, size));
        }
    }

    @Override
    public void draw(Shape s) {
        this.g.draw(s);
    }

    @Override
    public void fill(Shape s) {
        this.g.fill(s);
    }

    @Override
    public void setColor(Color c) {
        this.g.setColor(c);
    }

    @Override
    public void setBackground(Color c) {
        this.g.setBackground(c);
    }

    @Override
    public void setFont(Font f) {
        String name = f.getFamily();
        int style = f.getStyle();
        int size = f.getSize() * this.dpi / 72;
        Font font = new Font(name, style, size);
        this.g.setFont(font);
    }

    @Override
    public void setClip(Rectangle r) {
        this.g.setClip(r);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x, y, width, height);
    }

    @Override
    public void translate(Point offset) {
        this.g.setTransform(AffineTransform.getTranslateInstance(offset.x, offset.y));
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.g.clearRect(x, y, width, height);
    }

    @Override
    public void drawImage(RenderedImage image, int x, int y) {
        this.g.drawRenderedImage(image, AffineTransform.getTranslateInstance(x, y));
    }

    @Override
    public void drawString(String string, int x, int y, int alignx, int aligny) {
        int x2;
        Rectangle2D text = this.g.getFontMetrics().getStringBounds(string, this.g);
        int w = (int)text.getWidth();
        int h = (int)text.getHeight();
        int n = alignx == 0 ? x - w / 2 : (x2 = alignx > 0 ? x - w : x);
        int y2 = aligny == 0 ? y + h / 2 : (aligny > 0 ? y + h : y);
        this.g.drawString(string, x2, y2);
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.g.setTransform(transform);
    }

    @Override
    public void drawImage(Image image, int x, int y) {
        this.g.drawImage(image, x, y, null);
    }

    @Override
    public void drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        this.g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    @Override
    public int getFontHeight() {
        return this.g.getFontMetrics().getHeight();
    }

    @Override
    public int stringWidth(String str) {
        return this.g.getFontMetrics().stringWidth(str);
    }

    @Override
    public int getFontAscent() {
        return this.g.getFontMetrics().getAscent();
    }

    @Override
    public Rectangle2D getStringBounds(String str) {
        return this.g.getFontMetrics().getStringBounds(str, this.g);
    }

    public static BufferedImage toAwtImage(ImageData swtImageData) {
        return AWTSWTImageUtils.convertToAWT(swtImageData);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawImage(org.eclipse.swt.graphics.Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        BufferedImage awtImage = AWTSWTImageUtils.convertToAWT(image.getImageData());
        this.drawImage(awtImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
    }

    @Override
    public AffineTransform getTransform() {
        return this.g.getTransform();
    }

    @Override
    public void dispose() {
        this.g.dispose();
    }

    @Override
    public void drawPath(Path path) {
        PathData pathData = path.getPathData();
        float[] points = pathData.points;
        GeneralPath p = new GeneralPath();
        p.moveTo(points[0], points[1]);
        int i = 2;
        while (i < points.length) {
            p.lineTo(points[i], points[i + 1]);
            i += 2;
        }
        this.draw(p);
    }

    @Override
    public void fillPath(Path path) {
        PathData pathData = path.getPathData();
        float[] points = pathData.points;
        GeneralPath p = new GeneralPath();
        p.moveTo(points[0], points[1]);
        int i = 2;
        while (i < points.length) {
            p.lineTo(points[i], points[i + 1]);
            i += 2;
        }
        this.fill(p);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.g.drawRect(x, y, width, height);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.g.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.g.fillOval(x, y, width, height);
    }

    @Override
    public void drawImage(org.eclipse.swt.graphics.Image swtImage, int x, int y) {
        BufferedImage awtImage = AWTSWTImageUtils.convertToAWT(swtImage.getImageData());
        this.drawImage(awtImage, x, y);
    }

    @Override
    public Shape getClip() {
        return this.g.getClip();
    }

    @Override
    public void setClipBounds(Rectangle newBounds) {
        this.g.setClip(newBounds);
    }

    @Override
    public Color getBackgroundColor() {
        return this.g.getBackground();
    }

    @Override
    public Color getColor() {
        return this.g.getColor();
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void setLineDash(int[] dash) {
        Stroke stroke = this.g.getStroke();
        if (!(stroke instanceof BasicStroke)) {
            stroke = new BasicStroke();
        }
        BasicStroke basicStroke = (BasicStroke)stroke;
        this.g.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), this.toFloatArray(dash), 0.0f));
    }

    private float[] toFloatArray(int[] dash) {
        float[] result = new float[dash.length];
        int i = 0;
        while (i < result.length) {
            result[i] = dash[i];
            ++i;
        }
        return result;
    }

    @Override
    public void setLineWidth(int width) {
        Stroke stroke = this.g.getStroke();
        if (!(stroke instanceof BasicStroke)) {
            stroke = new BasicStroke();
        }
        BasicStroke basicStroke = (BasicStroke)stroke;
        this.g.setStroke(new BasicStroke(width, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
    }

    @Override
    public void setStroke(int style, int width) {
        switch (style) {
            case 2: {
                this.g.setStroke(new BasicStroke(width, 2, 0, 10.0f, new float[]{(float)width * 2.0f, (float)width * 2.0f}, 0.0f));
                break;
            }
            case 4: {
                this.g.setStroke(new BasicStroke(width, 2, 0, 10.0f, new float[]{(float)width * 2.0f, (float)width * 2.0f, (float)width * 1.0f, (float)width * 2.0f}, 0.0f));
                break;
            }
            case 5: {
                this.g.setStroke(new BasicStroke(width, 2, 0, 10.0f, new float[]{(float)width * 2.0f, (float)width * 2.0f, (float)width * 1.0f, (float)width * 2.0f, (float)width * 1.0f, (float)width * 2.0f}, 0.0f));
                break;
            }
            case 3: {
                this.g.setStroke(new BasicStroke(width, 2, 0, 10.0f, new float[]{(float)width * 1.0f, (float)width * 2.0f}, 0.0f));
                break;
            }
            case 1: {
                this.g.setStroke(new BasicStroke(width));
                break;
            }
            case 6: {
                this.g.setStroke(new BasicStroke(width, 1, 1));
            }
        }
    }

    @Override
    public int getDPI() {
        return this.dpi;
    }

    public void setDPI(int dpi) {
        if (this.dpi == dpi) {
            return;
        }
        Font font = this.g.getFont();
        String name = font.getName();
        int style = font.getStyle();
        int size = font.getSize() * this.getDPI() / dpi;
        this.g.setFont(new Font(name, style, size));
        this.dpi = dpi;
    }

    @Override
    public void fillGradientRectangle(int x, int y, int width, int height, Color startColor, Color endColor, boolean isVertical) {
        GradientPaint gradPaint = null;
        gradPaint = isVertical ? new GradientPaint(x, y, startColor, x, y + height, endColor) : new GradientPaint(x, y, startColor, x + width, y, endColor);
        this.g.setPaint(gradPaint);
        this.g.fillRect(x, y, width, height);
    }

    @Override
    public <T> T getGraphics(Class<T> adaptee) {
        if (adaptee.isAssignableFrom(Graphics2D.class)) {
            return adaptee.cast(this.g);
        }
        return null;
    }
}

