/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import net.refractions.udig.ui.filter.FilterInput;
import net.refractions.udig.ui.filter.FilterViewerFactory;
import net.refractions.udig.ui.filter.IFilterViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.filter.Filter;

public class IncludeFilterViewer
extends IFilterViewer {
    protected Composite control;
    protected Button enableButton;
    protected Button disableButton;

    public IncludeFilterViewer(Composite parent) {
        this(parent, 4);
    }

    public IncludeFilterViewer(Composite parent, int style) {
        this.control = new Composite(parent, style);
        this.enableButton = new Button(this.control, 16);
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeFilterViewer.this.internalUpdate((Filter)Filter.INCLUDE);
                IncludeFilterViewer.this.feedback();
            }
        });
        this.enableButton.setBounds(20, 31, 90, 16);
        this.enableButton.setText("Enable");
        this.disableButton = new Button(this.control, 16);
        this.disableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeFilterViewer.this.internalUpdate((Filter)Filter.EXCLUDE);
                IncludeFilterViewer.this.feedback();
            }
        });
        this.disableButton.setBounds(20, 53, 90, 16);
        this.disableButton.setText("Disable");
    }

    public Control getControl() {
        return this.control;
    }

    public String getValidationMessage() {
        if (this.enableButton.getSelection() && this.disableButton.getSelection()) {
            return "Unable to represent " + ECQL.toCQL((Filter)this.filter);
        }
        if (!this.enableButton.getSelection() && !this.disableButton.getSelection()) {
            return "Unable to represent " + ECQL.toCQL((Filter)this.filter);
        }
        return null;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
        this.refresh();
    }

    @Override
    public void refresh() {
        if (this.filter == Filter.INCLUDE) {
            this.enableButton.setSelection(true);
            this.disableButton.setSelection(false);
        } else if (this.filter == Filter.EXCLUDE) {
            this.enableButton.setSelection(false);
            this.disableButton.setSelection(true);
        } else {
            this.enableButton.setSelection(false);
            this.disableButton.setSelection(false);
            this.feedbackReplace(this.filter);
        }
    }

    public static class Factory
    extends FilterViewerFactory {
        @Override
        public int appropriate(FilterInput input, Filter filter) {
            if (filter == Filter.EXCLUDE || filter == Filter.INCLUDE) {
                return 50;
            }
            return 1;
        }

        @Override
        public IFilterViewer createViewer(Composite parent, int style) {
            return new IncludeFilterViewer(parent, style);
        }
    }
}

