/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import net.refractions.udig.ui.filter.FilterInput;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public abstract class IFilterViewer
extends Viewer {
    protected FilterInput input;
    protected Filter filter;

    public void setInput(Object filterInput) {
        if (this.input == filterInput) {
            return;
        }
        if (filterInput instanceof SimpleFeatureType) {
            this.input = new FilterInput((SimpleFeatureType)filterInput);
        } else if (filterInput instanceof FilterInput) {
            this.input = (FilterInput)filterInput;
        }
    }

    public FilterInput getInput() {
        return this.input;
    }

    public static boolean same(Filter before, Filter after) {
        String beforeCql = before != null ? ECQL.toCQL((Filter)before) : "(empty)";
        String afterCql = after != null ? ECQL.toCQL((Filter)after) : "(empty)";
        return Utilities.equals((Object)beforeCql, (Object)afterCql);
    }

    public abstract void refresh();

    public Filter getFilter() {
        return this.filter;
    }

    public ISelection getSelection() {
        if (this.filter != null) {
            return new StructuredSelection((Object)this.filter);
        }
        return StructuredSelection.EMPTY;
    }

    public abstract void setFilter(Filter var1);

    protected void internalUpdate(Filter newFilter) {
        String after;
        if (this.filter == newFilter) {
            return;
        }
        String before = this.filter != null ? ECQL.toCQL((Filter)this.filter) : "(empty)";
        String string = after = newFilter != null ? ECQL.toCQL((Filter)newFilter) : "(empty)";
        if (!Utilities.equals((Object)before, (Object)after)) {
            this.filter = newFilter;
            StructuredSelection selection = newFilter != null ? new StructuredSelection((Object)newFilter) : StructuredSelection.EMPTY;
            SelectionChangedEvent selectionEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection);
            this.fireSelectionChanged(selectionEvent);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        StructuredSelection sel;
        Object element;
        if (selection != null && selection instanceof StructuredSelection && (element = (sel = (StructuredSelection)selection).getFirstElement()) instanceof Filter) {
            this.setFilter((Filter)element);
            return;
        }
        this.setFilter((Filter)Filter.EXCLUDE);
    }

    protected void feedback() {
        if (this.input != null && this.input.getFeedback() != null) {
            this.input.getFeedback().hide();
        }
    }

    protected void feedbackReplace(Filter filter) {
        this.feedback("Unable to display dynamic filter: \n" + ECQL.toCQL((Filter)filter) + "\nEdit to replace filter.");
    }

    protected void feedback(String warning) {
        Control control;
        if (this.input != null && this.input.getFeedback() != null) {
            ControlDecoration feedback = this.input.getFeedback();
            feedback.setDescriptionText(warning);
            FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
            FieldDecoration errorDecoration = decorations.getFieldDecoration("DEC_WARNING");
            feedback.setImage(errorDecoration.getImage());
            feedback.show();
        }
        if ((control = this.getControl()) != null && !control.isDisposed()) {
            control.setToolTipText(warning);
        }
    }

    protected void feedback(String warning, boolean isRequired) {
        if (isRequired) {
            Control control;
            if (this.input != null && this.input.getFeedback() != null) {
                ControlDecoration feedback = this.input.getFeedback();
                feedback.setDescriptionText(warning);
                FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
                if (isRequired) {
                    FieldDecoration requiredDecoration = decorations.getFieldDecoration("DEC_REQUIRED");
                    feedback.setImage(requiredDecoration.getImage());
                } else {
                    FieldDecoration warningDecoration = decorations.getFieldDecoration("DEC_WARNING");
                    feedback.setImage(warningDecoration.getImage());
                }
                feedback.show();
            }
            if ((control = this.getControl()) != null && !control.isDisposed()) {
                control.setToolTipText(warning);
            }
        } else {
            this.feedback(warning);
        }
    }

    protected void feedback(String error, Throwable exception) {
        Control control;
        if (this.input != null && this.input.getFeedback() != null) {
            ControlDecoration feedback = this.input.getFeedback();
            feedback.setDescriptionText(error);
            FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
            FieldDecoration warningDecoration = decorations.getFieldDecoration("DEC_WARNING");
            feedback.setImage(warningDecoration.getImage());
            feedback.show();
        }
        if ((control = this.getControl()) != null && !control.isDisposed()) {
            control.setToolTipText(String.valueOf(error) + ":" + exception);
        }
    }
}

