/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.geotools.data.Parameter;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.text.generated.parsers.CQLParser;
import org.opengis.filter.capability.FunctionName;

class FunctionContentProposalProvider
implements IContentProposalProvider {
    protected static Set<String> proposals = new TreeSet<String>();
    protected static FunctionFinder functionFinder = new FunctionFinder(null);
    private Set<String> extras;
    private Set<String> grammer;

    static {
        for (FunctionName function : functionFinder.getAllFunctionDescriptions()) {
            proposals.add(function.getName());
        }
    }

    public FunctionContentProposalProvider() {
        this.grammer = this.generateGrammer(true);
    }

    public FunctionContentProposalProvider(boolean includeFilterTokens) {
        this.grammer = this.generateGrammer(includeFilterTokens);
    }

    private Set<String> generateGrammer(boolean includeFilter) {
        HashSet<String> generate = new HashSet<String>();
        String[] stringArray = CQLParser.tokenImage;
        int n = CQLParser.tokenImage.length;
        int n2 = 0;
        while (n2 < n) {
            String token;
            String tokenImage = stringArray[n2];
            if (tokenImage.startsWith("\"") && !(token = tokenImage.substring(1, tokenImage.length() - 1)).isEmpty()) {
                if (Character.isLetter(token.charAt(0))) {
                    if (includeFilter) {
                        generate.add(token.toUpperCase());
                    }
                } else {
                    generate.add(token);
                }
            }
            ++n2;
        }
        return generate;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        IContentProposal contentProposal;
        String word = contents.substring(0, position);
        int start = word.lastIndexOf(" ", position);
        if (start != -1) {
            word = contents.substring(start, position);
        }
        word = word.trim();
        int prefixLength = word.length();
        if (word.length() == 0) {
            return new IContentProposal[0];
        }
        ArrayList<IContentProposal> list = new ArrayList<IContentProposal>();
        if (this.extras != null) {
            for (String extra : this.extras) {
                if (extra.length() <= word.length() || !extra.substring(0, word.length()).equals(word)) continue;
                list.add(this.makeContentProposal(extra, prefixLength));
            }
        }
        for (String proposal : proposals) {
            if (proposal.length() <= word.length() || !proposal.substring(0, word.length()).equals(word)) continue;
            contentProposal = this.makeContentProposal(proposal, prefixLength);
            list.add(contentProposal);
        }
        for (String token : this.grammer) {
            if (token.length() <= word.length() || !token.substring(0, word.length()).equals(word)) continue;
            contentProposal = this.makeContentProposal(token, prefixLength);
            list.add(contentProposal);
        }
        return list.toArray(new IContentProposal[list.size()]);
    }

    private IContentProposal makeContentProposal(final String proposal, final int prefixLength) {
        return new IContentProposal(){

            public String getContent() {
                if (prefixLength < proposal.length()) {
                    return proposal.substring(prefixLength);
                }
                return proposal;
            }

            public String getDescription() {
                FunctionName description = functionFinder.findFunctionDescription(proposal);
                if (description != null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(description.getName());
                    String seperator = null;
                    if (description.getArguments() != null && !description.getArguments().isEmpty()) {
                        for (org.opengis.parameter.Parameter param : description.getArguments()) {
                            if (seperator == null) {
                                builder.append("(");
                                seperator = ",";
                            } else {
                                builder.append(seperator);
                            }
                            builder.append(param.getName());
                        }
                        builder.append(")\nWhere:\n");
                        for (org.opengis.parameter.Parameter param : description.getArguments()) {
                            builder.append("  ");
                            this.describeParameter(builder, param);
                            builder.append("\n");
                        }
                    }
                    if (description.getReturn() != null) {
                        org.opengis.parameter.Parameter param;
                        builder.append("Result:\n");
                        param = description.getReturn();
                        builder.append(" ");
                        this.describeParameter(builder, param);
                        builder.append("\n");
                    }
                    return builder.toString();
                }
                return null;
            }

            private void describeParameter(StringBuilder builder, org.opengis.parameter.Parameter<?> param) {
                builder.append(param.getName());
                builder.append(" ");
                if (param.getType() != Object.class) {
                    builder.append(param.getType().getSimpleName());
                    builder.append(" ");
                }
                builder.append(": ");
                if (param.isRequired().booleanValue()) {
                    builder.append("Required ");
                }
                if (param.getMinOccurs() != 1 || param.getMaxOccurs() != 1) {
                    if (param.getMinOccurs() == 0 && param.getMaxOccurs() == 1) {
                        builder.append("Optional ");
                    } else {
                        builder.append("(");
                        builder.append(param.getMinOccurs());
                        builder.append("-");
                        if (param.getMaxOccurs() < 0 || param.getMaxOccurs() == Integer.MAX_VALUE) {
                            builder.append("unbound");
                        } else {
                            builder.append(param.getMaxOccurs());
                        }
                        builder.append(") ");
                    }
                }
                if (param.getDescription() != null) {
                    builder.append((CharSequence)param.getDescription());
                    builder.append(" ");
                }
                if (param instanceof Parameter) {
                    Parameter parameter = (Parameter)param;
                    if (parameter.metadata.containsKey("options")) {
                        builder.append(" Options: ");
                        builder.append(parameter.metadata.get("options"));
                        builder.append(" ");
                    }
                    if (parameter.metadata.containsKey("length")) {
                        builder.append(" Length: ");
                        builder.append(parameter.metadata.get("length"));
                        builder.append(" ");
                    }
                    if (parameter.metadata.containsKey("min")) {
                        builder.append(" Min: ");
                        builder.append(parameter.metadata.get("min"));
                        builder.append(" ");
                    }
                    if (parameter.metadata.containsKey("max")) {
                        builder.append(" Max: ");
                        builder.append(parameter.metadata.get("max"));
                        builder.append(" ");
                    }
                }
            }

            public String getLabel() {
                return proposal;
            }

            public int getCursorPosition() {
                return proposal.length() - prefixLength;
            }
        };
    }

    public void setExtra(Set<String> names) {
        this.extras = names;
    }
}

