/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;

public class FilterInput {
    protected boolean required = false;
    protected SimpleFeatureType schema;
    protected ControlDecoration feedback;
    protected List<String> propertyList;
    protected List<String> numericPropertyList;
    protected List<String> stringPropertyList;
    protected String viewerId;

    public FilterInput() {
        this(null);
    }

    public FilterInput(SimpleFeatureType schema) {
        this(schema, false);
    }

    public FilterInput(SimpleFeatureType schema, boolean required) {
        this.schema = schema;
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setSchema(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public List<String> getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(List<String> propertyList) {
        this.propertyList = propertyList;
    }

    public List<String> toPropertyList() {
        if (this.propertyList != null) {
            return this.propertyList;
        }
        if (this.schema != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (AttributeDescriptor descriptor : this.schema.getAttributeDescriptors()) {
                names.add(descriptor.getLocalName());
            }
            this.propertyList = names;
            return this.propertyList;
        }
        return Collections.emptyList();
    }

    public List<String> getStringPropertyList() {
        return this.stringPropertyList;
    }

    public void setStringPropertyList(List<String> stringPropertyList) {
        this.stringPropertyList = stringPropertyList;
    }

    public List<String> toStringPropertyList() {
        if (this.stringPropertyList != null) {
            return this.stringPropertyList;
        }
        if (this.schema != null) {
            this.stringPropertyList = this.toPropertyList(String.class);
            return this.stringPropertyList;
        }
        return Collections.emptyList();
    }

    public List<String> getNumericPropertyList() {
        return this.numericPropertyList;
    }

    public void setNumericPropertyList(List<String> numericPropertyList) {
        this.numericPropertyList = numericPropertyList;
    }

    public List<String> toNumericPropertyList() {
        if (this.numericPropertyList != null) {
            return this.numericPropertyList;
        }
        if (this.schema != null) {
            this.numericPropertyList = this.toPropertyList(Number.class);
            return this.numericPropertyList;
        }
        return Collections.emptyList();
    }

    public List<String> toPropertyList(Class<?> binding) {
        if (this.schema != null && binding != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (AttributeDescriptor descriptor : this.schema.getAttributeDescriptors()) {
                AttributeType type = descriptor.getType();
                if (!binding.isAssignableFrom(type.getBinding())) continue;
                names.add(descriptor.getLocalName());
            }
            return names;
        }
        return Collections.emptyList();
    }

    public ControlDecoration getFeedback() {
        return this.feedback;
    }

    public void setFeedback(ControlDecoration feedback) {
        this.feedback = feedback;
    }

    public String getViewerId() {
        return this.viewerId;
    }

    public void setViewerId(String viewerId) {
        this.viewerId = viewerId;
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.getClass().getSimpleName());
        build.append(" ");
        if (this.required) {
            build.append("required ");
        }
        if (this.viewerId != null) {
            build.append(" viewerId:");
            build.append(this.viewerId);
            build.append(" ");
        }
        if (this.feedback != null) {
            build.append(" feedback:");
            build.append(this.feedback.getControl().getClass().getSimpleName());
            build.append(" ");
        }
        if (this.schema != null) {
            build.append(" schema:");
            build.append(this.schema.getTypeName());
            build.append(" ");
        }
        return build.toString();
    }
}

