/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.filter.ExpressionInput;
import net.refractions.udig.ui.filter.IExpressionViewer;
import net.refractions.udig.ui.filter.ViewerFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.opengis.filter.expression.Expression;

public abstract class ExpressionViewerFactory
extends ViewerFactory<IExpressionViewer> {
    public static final String CQL_EXPRESSION_VIEWER = "net.refractions.udig.ui.filter.cqlExpressionViewer";
    public static final String FILTER_VIEWER_EXTENSION = "net.refractions.udig.ui.filterViewer";
    private static List<ExpressionViewerFactory> factoryList;

    @Override
    public Class<?> getBinding() {
        return Expression.class;
    }

    @Override
    public int score(Object input, Object value) {
        ExpressionInput expressionInput = ExpressionViewerFactory.safeCast(input, ExpressionInput.class);
        Expression expression = ExpressionViewerFactory.safeCast(value, Expression.class);
        return this.score(expressionInput, expression);
    }

    public abstract int score(ExpressionInput var1, Expression var2);

    @Override
    public abstract IExpressionViewer createViewer(Composite var1, int var2);

    public static List<ExpressionViewerFactory> factoryList(ExpressionInput input, Expression expression) {
        ArrayList<ExpressionViewerFactory> list = new ArrayList<ExpressionViewerFactory>();
        for (ExpressionViewerFactory factory : ExpressionViewerFactory.factoryList()) {
            int score = factory.score(input, expression);
            if (ViewerFactory.Appropriate.valueOf(score) == ViewerFactory.Appropriate.NOT_APPROPRIATE) continue;
            list.add(factory);
        }
        Collections.sort(list, new ViewerFactory.ViewerFactoryComparator(input, expression));
        return list;
    }

    public static synchronized List<ExpressionViewerFactory> factoryList() {
        if (factoryList == null) {
            IConfigurationElement[] configurationElements;
            ArrayList<ExpressionViewerFactory> list = new ArrayList<ExpressionViewerFactory>();
            IExtensionRegistry registery = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registery.getExtensionPoint(FILTER_VIEWER_EXTENSION);
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configuration = iConfigurationElementArray[n2];
                if ("expressionViewer".equals(configuration.getName())) {
                    try {
                        ExpressionViewerFactory factory = (ExpressionViewerFactory)configuration.createExecutableExtension("class");
                        factory.init(configuration);
                        list.add(factory);
                    }
                    catch (CoreException e) {
                        String pluginId = configuration.getContributor().getName();
                        Status status = new Status(2, pluginId, e.getMessage(), (Throwable)e);
                        UiPlugin.log((IStatus)status);
                    }
                }
                ++n2;
            }
            factoryList = Collections.unmodifiableList(list);
        }
        return factoryList;
    }
}

