/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.Arrays;
import java.util.List;
import net.refractions.udig.ui.filter.FilterInput;
import org.opengis.feature.simple.SimpleFeatureType;

public class ExpressionInput
extends FilterInput {
    private Class<?> binding;
    private Comparable<?> min;
    private Comparable<?> max;
    private List<Object> options;
    private Object defaultLiteral;
    private boolean percent;

    public ExpressionInput() {
        this(null);
    }

    public ExpressionInput(SimpleFeatureType schema) {
        this(schema, false);
    }

    public ExpressionInput(SimpleFeatureType schema, boolean required) {
        this(schema, required, Object.class);
    }

    public ExpressionInput(SimpleFeatureType schema, boolean required, Class<?> binding) {
        super(schema, required);
        this.binding = binding;
    }

    public Class<?> getBinding() {
        return this.binding;
    }

    public void setBinding(Class<?> binding) {
        this.binding = binding;
    }

    public Object getDefault() {
        return this.defaultLiteral;
    }

    public void setDefault(Object defaultLiteral) {
        this.defaultLiteral = defaultLiteral;
    }

    public Comparable<?> getMin() {
        return this.min;
    }

    public void setMin(Comparable<?> min) {
        this.min = min;
    }

    public Comparable<?> getMax() {
        return this.max;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public void setPercent(boolean percent) {
        this.percent = percent;
        if (percent) {
            this.setMin(Double.valueOf(0.0));
            this.setMax(Double.valueOf(1.0));
        }
    }

    public void setMax(Comparable<?> max) {
        this.max = max;
    }

    public void setOptions(Object ... options) {
        this.setOptionList(Arrays.asList(options));
    }

    public void setOptionList(List<Object> options) {
        this.options = options;
    }

    public List<Object> getOptions() {
        return this.options;
    }

    @Override
    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.getClass().getSimpleName());
        build.append(" ");
        if (this.required) {
            build.append("required ");
        }
        if (this.viewerId != null) {
            build.append(" viewerId:");
            build.append(this.viewerId);
            build.append(" ");
        }
        if (this.feedback != null) {
            build.append(" feedback:");
            build.append(this.feedback.getControl().getClass().getSimpleName());
            build.append(" ");
        }
        if (this.schema != null) {
            build.append(" schema:");
            build.append(this.schema.getTypeName());
            build.append(" ");
        }
        if (this.binding != null) {
            build.append(" binding:");
            build.append(this.binding.getSimpleName());
            build.append(" ");
        }
        if (this.defaultLiteral != null) {
            build.append(" default:");
            build.append(this.defaultLiteral);
            build.append(" ");
        }
        if (this.min != null || this.max != null) {
            build.append("limit: ");
            build.append(this.min);
            build.append(" .. ");
            build.append(this.max);
            build.append(" ");
        }
        if (this.options != null) {
            build.append(" options:");
            build.append(this.options);
            build.append(" ");
        }
        return build.toString();
    }
}

