/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.SortedSet;
import java.util.TreeSet;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.ui.filter.CQLFilterViewer;
import net.refractions.udig.ui.filter.FilterInput;
import net.refractions.udig.ui.filter.FilterViewerFactory;
import net.refractions.udig.ui.filter.IFilterViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.Filter;

public class DefaultFilterViewer
extends CQLFilterViewer {
    protected Composite control;
    private Label lblAttribute;
    protected Combo attribute;
    private Label lblOperation;
    protected Combo operation;
    private Label lblValue;
    protected Combo value;
    protected Button insert;
    private SelectionAdapter insertButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StringBuilder sb = new StringBuilder();
            if (DefaultFilterViewer.this.attribute.getSelectionIndex() != -1) {
                sb.append(DefaultFilterViewer.this.attribute.getText());
                DefaultFilterViewer.this.attribute.deselectAll();
            }
            if (DefaultFilterViewer.this.operation.getSelectionIndex() != -1) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(DefaultFilterViewer.this.operation.getText());
                DefaultFilterViewer.this.operation.deselectAll();
            }
            if (DefaultFilterViewer.this.value.getSelectionIndex() != -1) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(DefaultFilterViewer.this.value.getText());
                DefaultFilterViewer.this.value.deselectAll();
            }
            if (sb.length() > 0) {
                DefaultFilterViewer.this.changed();
                DefaultFilterViewer.this.text.insert(sb.toString());
                DefaultFilterViewer.this.text.setFocus();
            }
        }
    };
    private static final String EQUALS = "=";
    private static final String GTHAN = ">";
    private static final String LTHAN = "<";
    private static final String LIKE = "LIKE";
    private static final String[] OPERATORS = new String[]{"=", ">", "<", "LIKE"};

    public DefaultFilterViewer(Composite parent, int style) {
        super(new Composite(parent, 16){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                Control[] controlArray = this.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.setEnabled(enabled);
                    ++n2;
                }
            }
        }, style);
        this.control = this.text.getParent();
        boolean isMultiline = (2 & style) != 0;
        this.lblAttribute = null;
        if (isMultiline) {
            this.lblAttribute = new Label(this.control, 0);
            this.lblAttribute.setText("Attribute:");
        }
        this.attribute = new Combo(this.control, 12);
        this.attribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String attributeName = DefaultFilterViewer.this.attribute.getText();
                if (attributeName != null && DefaultFilterViewer.this.getInput() != null && DefaultFilterViewer.this.getInput().getSchema() != null) {
                    SimpleFeatureType schema = DefaultFilterViewer.this.getInput().getSchema();
                    AttributeDescriptor descriptor = schema.getDescriptor(attributeName);
                    SortedSet<String> suggestedValues = DefaultFilterViewer.this.generateSuggestedValues(descriptor);
                    DefaultFilterViewer.this.value.removeAll();
                    if (suggestedValues.isEmpty()) {
                        DefaultFilterViewer.this.value.setEnabled(false);
                    } else {
                        DefaultFilterViewer.this.value.setEnabled(true);
                        for (String item : suggestedValues) {
                            DefaultFilterViewer.this.value.add(item);
                        }
                    }
                } else {
                    DefaultFilterViewer.this.value.removeAll();
                    DefaultFilterViewer.this.value.setEnabled(false);
                }
            }
        });
        this.lblOperation = null;
        if (isMultiline) {
            this.lblOperation = new Label(this.control, 0);
            this.lblOperation.setText("Operation:");
        }
        this.operation = new Combo(this.control, 12);
        this.operation.setItems(OPERATORS);
        this.lblValue = null;
        if (isMultiline) {
            this.lblValue = new Label(this.control, 0);
            this.lblValue.setText("Value:");
        }
        this.value = new Combo(this.control, 12);
        this.value.setEnabled(false);
        this.insert = new Button(this.control, 0);
        this.insert.setText("Insert");
        this.insert.addSelectionListener((SelectionListener)this.insertButtonListener);
        this.setLayout(isMultiline);
    }

    private void setLayout(boolean isMultiline) {
        if (isMultiline) {
            MigLayout layout = new MigLayout("insets 0", "[][][][][][][grow]", "[grow][]");
            this.control.setLayout((Layout)layout);
            this.text.setLayoutData((Object)"span,grow,width 200:100%:100%,height 60:100%:100%");
            this.setPreferredTextSize(40, 5);
            this.lblAttribute.setLayoutData((Object)"cell 0 1,alignx trailing,gapx related");
            this.attribute.setLayoutData((Object)"cell 1 1,wmin 60,alignx left,gapx rel");
            this.lblOperation.setLayoutData((Object)"cell 2 1,alignx trailing,gapx related");
            this.operation.setLayoutData((Object)"cell 3 1,wmin 60,alignx left,gapx rel");
            this.lblValue.setLayoutData((Object)"cell 4 1,alignx trailing,gapx related");
            this.value.setLayoutData((Object)"cell 5 1,wmin 60,alignx left,gapx related");
            this.insert.setLayoutData((Object)"cell 6 1,alignx left,gapx unrel");
        } else {
            this.control.setLayout((Layout)new MigLayout("insets 0, flowx", "", ""));
            this.text.setLayoutData((Object)"grow,width 200:70%:100%, gap unrelated");
            this.attribute.setLayoutData((Object)"width 90:20%:100%, gap related");
            this.operation.setLayoutData((Object)"width 60:10%:100%, gap related");
            this.value.setLayoutData((Object)"width 60:10%:100%, gap related");
            this.insert.setLayoutData((Object)"gap related");
        }
    }

    protected SortedSet<String> generateSuggestedValues(AttributeDescriptor descriptor) {
        AttributeType type;
        TreeSet<String> options = new TreeSet<String>();
        Object defaultValue = descriptor.getDefaultValue();
        if (defaultValue != null) {
            options.add(String.valueOf(defaultValue));
        }
        if (Number.class.isAssignableFrom((type = descriptor.getType()).getBinding())) {
            options.add("0");
            options.add("1");
            options.add("2");
            options.add("3");
            options.add("4");
            options.add("5");
        }
        return options;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.input != null) {
            TreeSet<String> names = new TreeSet<String>(this.input.toPropertyList());
            this.attribute.setItems(names.toArray(new String[names.size()]));
        }
    }

    public static class Factory
    extends FilterViewerFactory {
        @Override
        public int appropriate(FilterInput input, Filter filter) {
            return 26;
        }

        @Override
        public IFilterViewer createViewer(Composite parent, int style) {
            return new DefaultFilterViewer(parent, style);
        }
    }
}

