/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.List;
import java.util.TreeSet;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.ui.filter.CQLExpressionViewer;
import net.refractions.udig.ui.filter.ExpressionInput;
import net.refractions.udig.ui.filter.ExpressionViewerFactory;
import net.refractions.udig.ui.filter.IExpressionViewer;
import net.refractions.udig.ui.filter.ViewerFactory;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;

public class DefaultExpressionViewer
extends CQLExpressionViewer {
    protected Filter filter = Filter.EXCLUDE;
    protected Composite control;
    private Label lblAttribute;
    protected Combo attribute;
    private Label lblOperation;
    protected Combo operation;
    private Label lblValue;
    protected Combo value;
    private static final String ADD = "+";
    private static final String SUB = "-";
    private static final String MUL = "*";
    private static final String DIV = "/";
    private static final String[] OPERATORS = new String[]{"+", "-", "*", "/"};
    private SelectionAdapter comboListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Combo combo;
            if (e.widget instanceof Combo && (combo = (Combo)e.widget).getSelectionIndex() != -1) {
                DefaultExpressionViewer.this.text.insert(combo.getText());
                DefaultExpressionViewer.this.text.setFocus();
                combo.deselectAll();
                DefaultExpressionViewer.this.changed();
            }
        }
    };

    public DefaultExpressionViewer(Composite parent, int style) {
        super(new Composite(parent, 16){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                Control[] controlArray = this.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.setEnabled(enabled);
                    ++n2;
                }
            }
        }, style);
        this.control = this.text.getParent();
        boolean isMultiline = (2 & style) != 0;
        this.lblAttribute = null;
        if (isMultiline) {
            this.lblAttribute = new Label(this.control, 0);
            this.lblAttribute.setText(Messages.DefaultExpressionViewer_attribute);
        }
        this.attribute = new Combo(this.control, 12);
        this.attribute.addSelectionListener((SelectionListener)this.comboListener);
        this.lblOperation = null;
        if (isMultiline) {
            this.lblOperation = new Label(this.control, 0);
            this.lblOperation.setText(Messages.DefaultExpressionViewer_operation);
        }
        this.operation = new Combo(this.control, 12);
        this.operation.setItems(OPERATORS);
        this.operation.addSelectionListener((SelectionListener)this.comboListener);
        this.lblValue = null;
        if (isMultiline) {
            this.lblValue = new Label(this.control, 0);
            this.lblValue.setText(Messages.DefaultExpressionViewer_value);
        }
        this.value = new Combo(this.control, 12);
        this.value.addSelectionListener((SelectionListener)this.comboListener);
        this.value.setEnabled(false);
        this.setLayout(isMultiline);
    }

    private void setLayout(boolean isMultiline) {
        if (isMultiline) {
            MigLayout layout = new MigLayout("insets 0", "[][][][][][][grow]", "[grow][]");
            this.control.setLayout((Layout)layout);
            this.text.setLayoutData((Object)"cell 0 0,span,grow,width 200:100%:100%,height 60:100%:100%");
            this.setPreferredTextSize(40, 5);
            this.lblAttribute.setLayoutData((Object)"cell 0 1,alignx trailing,gapx related");
            this.attribute.setLayoutData((Object)"cell 1 1,wmin 60,alignx left,gapx rel");
            this.lblOperation.setLayoutData((Object)"cell 2 1,alignx trailing,gapx related");
            this.operation.setLayoutData((Object)"cell 3 1,wmin 60,alignx left,gapx rel");
            this.lblValue.setLayoutData((Object)"cell 4 1,alignx trailing,gapx related");
            this.value.setLayoutData((Object)"cell 5 1,wmin 60,alignx left,gapx related");
        } else {
            this.control.setLayout((Layout)new MigLayout("insets 0, flowx", "", ""));
            this.text.setLayoutData((Object)"grow,width 200:70%:100%, gap unrelated");
            this.attribute.setLayoutData((Object)"width 90:20%:100%, gap related");
            this.operation.setLayoutData((Object)"width 60:10%:100%, gap related");
            this.value.setLayoutData((Object)"width 60:10%:100%, gap related");
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.input != null) {
            TreeSet<String> names = new TreeSet<String>(this.input.toPropertyList());
            this.attribute.setItems(names.toArray(new String[names.size()]));
            List<Object> options = this.input.getOptions();
            if (options != null && options.size() > 0) {
                this.value.setItems(new String[0]);
                for (Object option : options) {
                    if (option == null) continue;
                    this.value.add(option.toString());
                }
                this.value.setEnabled(true);
            } else {
                this.value.setEnabled(false);
            }
        }
    }

    public static class Factory
    extends ExpressionViewerFactory {
        @Override
        public int score(ExpressionInput input, Expression expression) {
            return ViewerFactory.Appropriate.COMPLETE.getScore(1);
        }

        @Override
        public IExpressionViewer createViewer(Composite parent, int style) {
            return new DefaultExpressionViewer(parent, style);
        }
    }
}

