/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.TreeSet;
import net.refractions.udig.ui.filter.FilterInput;
import net.refractions.udig.ui.filter.FilterViewerFactory;
import net.refractions.udig.ui.filter.FunctionContentProposalProvider;
import net.refractions.udig.ui.filter.IFilterViewer;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.filter.Filter;

public class CQLFilterViewer
extends IFilterViewer {
    protected Text text;
    private FunctionContentProposalProvider proposalProvider;

    protected void setPreferredTextSize(int numberOfColumns, int numberOfRows) {
        GC gc = new GC((Drawable)this.text);
        FontMetrics fm = gc.getFontMetrics();
        int width = 30 * fm.getAverageCharWidth();
        int height = fm.getHeight();
        gc.dispose();
        this.text.setSize(this.text.computeSize(width, height));
    }

    public CQLFilterViewer(Composite parent, int style) {
        int textStyle;
        if ((style & 4) != 0) {
            textStyle = 2052;
            this.text = new Text(parent, textStyle);
            if ((style & 8) != 0) {
                textStyle |= 8;
            }
        } else if ((style & 2) != 0) {
            textStyle = 2626;
            if ((style & 8) != 0) {
                textStyle |= 8;
            }
            this.text = new Text(parent, textStyle);
            this.setPreferredTextSize(60, 3);
        } else {
            this.text = new Text(parent, 2052);
            this.setPreferredTextSize(30, 1);
        }
        this.proposalProvider = new FunctionContentProposalProvider();
        TextContentAdapter contentAdapter = new TextContentAdapter();
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this.proposalProvider, null, null);
        adapter.setProposalAcceptanceStyle(1);
        adapter.setPopupSize(new Point(400, 300));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQLFilterViewer.this.changed();
            }
        });
    }

    public Control getControl() {
        return this.text;
    }

    protected void changed() {
        Filter parsedFilter = this.validate();
        if (parsedFilter != null) {
            this.internalUpdate(parsedFilter);
        }
    }

    protected Filter toFilter(String txt) throws CQLException {
        if (txt == null) {
            return null;
        }
        if ("INCLDUE".equals(txt.trim())) {
            return Filter.INCLUDE;
        }
        if ("EXCLUDE".equals(txt.trim())) {
            return Filter.EXCLUDE;
        }
        return ECQL.toFilter((String)txt);
    }

    protected String toCQL(Filter filter) {
        if (filter == null) {
            return null;
        }
        if (filter == Filter.INCLUDE) {
            return "INCLUDE";
        }
        if (filter == Filter.EXCLUDE) {
            return "EXCLUDE";
        }
        return ECQL.toCQL((Filter)filter);
    }

    protected Filter validate() {
        Filter parsedFilter;
        try {
            parsedFilter = this.toFilter(this.text.getText());
        }
        catch (CQLException e) {
            this.feedback(e.getLocalizedMessage(), e);
            return null;
        }
        if (parsedFilter == null && this.input != null && this.input.isRequired()) {
            this.feedback("Required", true);
            return null;
        }
        this.feedback();
        return parsedFilter;
    }

    @Override
    public void refresh() {
        if (this.input != null) {
            TreeSet<String> names = new TreeSet<String>(this.input.toPropertyList());
            this.proposalProvider.setExtra(names);
        }
        this.refreshFilter();
    }

    @Override
    public void setFilter(Filter filter) {
        if (this.filter == filter) {
            return;
        }
        this.filter = filter;
        this.refreshFilter();
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    private void refreshFilter() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CQLFilterViewer.this.text == null || CQLFilterViewer.this.text.isDisposed()) {
                        return;
                    }
                    if (CQLFilterViewer.this.filter == null) {
                        CQLFilterViewer.this.text.setText("");
                        CQLFilterViewer.this.feedback("Empty");
                    } else {
                        String cql = CQLFilterViewer.this.toCQL(CQLFilterViewer.this.filter);
                        CQLFilterViewer.this.text.setText(cql);
                        CQLFilterViewer.this.feedback();
                    }
                }
            });
        }
    }

    public static class Factory
    extends FilterViewerFactory {
        @Override
        public int appropriate(FilterInput input, Filter filter) {
            return 25;
        }

        @Override
        public IFilterViewer createViewer(Composite parent, int style) {
            return new CQLFilterViewer(parent, style);
        }
    }
}

