/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.aoi;

import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.AOIProxy;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.aoi.PageRecord;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class AOIView
extends ViewPart {
    private AOIListener serviceWatcher = new AOIListener(){

        @Override
        public void handleEvent(AOIListener.Event event) {
            final AOIListener.Event aoiEvent = event;
            PlatformGIS.asyncInDisplayThread(new Runnable(){

                @Override
                public void run() {
                    AOIProxy currentStrategy = aoiEvent.source instanceof AOIProxy ? (AOIProxy)aoiEvent.source : PlatformGIS.getAOIService().getProxy();
                    AOIView.this.setSelected(currentStrategy);
                }
            }, true);
        }
    };
    private ComboViewer comboViewer;
    private ISelectionChangedListener comboListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selectedStrategy = (IStructuredSelection)event.getSelection();
            AOIProxy selected = (AOIProxy)selectedStrategy.getFirstElement();
            AOIView.this.publishAOIStrategy(selected);
        }
    };
    private PageBook pagebook;
    private Map<AOIProxy, PageRecord> pages = new HashMap<AOIProxy, PageRecord>();
    private Composite placeholder;

    private void publishAOIStrategy(AOIProxy selected) {
        IAOIService aOIService = PlatformGIS.getAOIService();
        aOIService.setProxy(selected);
    }

    public void setSelected(AOIProxy selected) {
        Control selectedControl;
        if (selected == null) {
            selected = PlatformGIS.getAOIService().getDefault();
        }
        boolean disposed = this.comboViewer.getControl().isDisposed();
        if (this.comboViewer == null || disposed) {
            this.listenService(false);
            return;
        }
        AOIProxy current = this.getSelected();
        if (current != selected) {
            try {
                this.listenCombo(false);
                this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)selected), true);
            }
            finally {
                this.listenCombo(true);
            }
        }
        Control currentControl = null;
        Control[] controlArray = this.pagebook.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control page = controlArray[n2];
            if (page.isVisible()) {
                currentControl = page;
                break;
            }
            ++n2;
        }
        PageRecord record = this.pages.get(selected);
        if (record == null) {
            IPageBookViewPage page = selected.createPage();
            if (page == null) {
                MessagePage messagePage = new MessagePage();
                record = new PageRecord((IViewPart)this, (IPage)messagePage);
                messagePage.init((IPageSite)record.getSite());
                messagePage.createControl((Composite)this.pagebook);
                messagePage.setMessage(selected.getName());
            } else {
                record = new PageRecord((IViewPart)this, (IPage)page);
                try {
                    page.init((IPageSite)record.getSite());
                }
                catch (PartInitException e) {
                    UiPlugin.log(((Object)((Object)this)).getClass(), "initPage", e);
                }
                page.createControl((Composite)this.pagebook);
            }
            this.pages.put(selected, record);
        }
        if ((selectedControl = record.getControl()) == null) {
            if (this.placeholder == null) {
                Composite content = new Composite((Composite)this.pagebook, 0);
                content.setLayout((Layout)new FillLayout());
                Label label = new Label(content, 16576);
                label.setText("Current Area of Interest used for filtering content.");
                this.placeholder = content;
            }
            selectedControl = this.placeholder;
        }
        if (currentControl != selectedControl && selectedControl != null) {
            this.pagebook.showPage(selectedControl);
        }
    }

    public AOIProxy getSelected() {
        if (this.comboViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
            return (AOIProxy)selection.getFirstElement();
        }
        return null;
    }

    protected void listenCombo(boolean listen) {
        if (this.comboViewer == null || this.comboViewer.getControl().isDisposed()) {
            return;
        }
        if (listen) {
            this.comboViewer.addSelectionChangedListener(this.comboListener);
        } else {
            this.comboViewer.removeSelectionChangedListener(this.comboListener);
        }
    }

    protected void listenService(boolean listen) {
        IAOIService aOIService = PlatformGIS.getAOIService();
        if (listen) {
            aOIService.addListener(this.serviceWatcher);
        } else {
            aOIService.removeListener(this.serviceWatcher);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IAOIService service = PlatformGIS.getAOIService();
        String id = service.getProxy().getId();
        memento.putString("AOI", id);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 16384);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText("Area of Interest: ");
        IAOIService aOIService = PlatformGIS.getAOIService();
        this.listenService(true);
        this.comboViewer = new ComboViewer(parent, 8);
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IAOIStrategy) {
                    IAOIStrategy comboStrategy = (IAOIStrategy)element;
                    return comboStrategy.getName();
                }
                return super.getText(element);
            }
        });
        this.comboViewer.setInput(aOIService.getProxyList());
        AOIProxy proxy = aOIService.getProxy();
        if (proxy == null) {
            proxy = aOIService.getDefault();
        }
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)proxy));
        this.listenCombo(true);
        this.pagebook = new PageBook(parent, 0);
        GridData layoutData = new GridData(16384, 128, true, true);
        layoutData.widthHint = 400;
        layoutData.horizontalSpan = 2;
        layoutData.heightHint = 400;
        this.pagebook.setLayoutData((Object)layoutData);
    }

    public void setFocus() {
        this.comboViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.pages != null && !this.pages.isEmpty()) {
            for (PageRecord record : this.pages.values()) {
                record.dispose();
            }
            this.pages.clear();
            this.pages = null;
        }
        if (this.comboViewer != null) {
            this.comboViewer.removeSelectionChangedListener(this.comboListener);
        }
        if (this.serviceWatcher != null) {
            IAOIService aOIService = PlatformGIS.getAOIService();
            if (aOIService != null) {
                aOIService.removeListener(this.serviceWatcher);
            }
            this.serviceWatcher = null;
        }
    }
}

