/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class ZoomingDialog
extends Dialog {
    public static final int FAST = 1;
    public static final int MEDIUM = 4;
    public static final int SLOW = 8;
    private static final int BASE_NUMBER_STEPS = 15;
    private final Dialog delegate;
    private final Point size;
    private final Point location;
    private Rectangle end;
    private int zoomSpeed = 1;
    private boolean shouldBlock;

    public ZoomingDialog(Shell parentShell, Dialog delegate, Rectangle start) {
        super((IShellProvider)new ZoomShellProvider(parentShell));
        this.delegate = delegate;
        this.location = new Point(start.x, start.y);
        this.size = new Point(start.width, start.height);
        this.setShellStyle(1851400);
    }

    public ZoomingDialog(Shell parentShell, Dialog dialog, int x, int y, int width, int height) {
        this(parentShell, dialog, new Rectangle(x, y, width, height));
    }

    public void setZoomSpeed(int speed) {
        this.zoomSpeed = speed;
    }

    public void setBlockOnOpen(boolean shouldBlock) {
        this.shouldBlock = shouldBlock;
    }

    public boolean close() {
        boolean result = this.delegate.close();
        return result;
    }

    private void closeInternal() {
        super.getShell().setVisible(true);
        this.delegate.getShell().setVisible(false);
        this.zoom(false);
        super.close();
    }

    public void create() {
        super.create();
        if (this.delegate.getShell() == null) {
            this.delegate.create();
        }
    }

    public int getReturnCode() {
        return this.delegate.getReturnCode();
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.location;
    }

    protected Point getInitialSize() {
        return this.size;
    }

    public int open() {
        if (this.delegate.getShell() == null) {
            this.delegate.create();
        }
        this.end = this.delegate.getShell().getBounds();
        super.setBlockOnOpen(false);
        super.open();
        this.zoom(true);
        this.delegate.setBlockOnOpen(false);
        int open = this.delegate.open();
        this.addClosingListeners();
        if (this.shouldBlock) {
            this.runEventLoop(this.getShell());
        }
        return open;
    }

    private void runEventLoop(Shell loopShell) {
        Display display = this.getShell() == null ? Display.getCurrent() : loopShell.getDisplay();
        while (loopShell != null && !loopShell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                UiPlugin.log("Exception in UI thread while waiting", e);
            }
        }
        display.update();
    }

    private void addClosingListeners() {
        this.delegate.getShell().addListener(29, new Listener(){

            public void handleEvent(Event event) {
                ZoomingDialog.this.closeInternal();
            }
        });
        this.delegate.getShell().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ZoomingDialog.this.closeInternal();
            }
        });
    }

    private void zoom(boolean grow) {
        Point location = this.location;
        Point size = this.size;
        int totalSteps = 15 * this.zoomSpeed;
        int xstep = (this.end.x - location.x) / totalSteps;
        int ystep = (this.end.y - location.y) / totalSteps;
        int xsize = (this.end.width - size.x) / totalSteps;
        int ysize = (this.end.height - size.y) / totalSteps;
        if (grow) {
            int steps = 0;
            while (steps < totalSteps) {
                int nextX = location.x + steps * xstep;
                int nextY = location.y + steps * ystep;
                int nextWidth = size.x + steps * xsize;
                int nextHeight = size.y + steps * ysize;
                super.getShell().setBounds(new Rectangle(nextX, nextY, nextWidth, nextHeight));
                ++steps;
            }
        } else {
            int steps = totalSteps;
            while (steps > -1) {
                int nextX = location.x + steps * xstep;
                int nextY = location.y + steps * ystep;
                int nextWidth = size.x + steps * xsize;
                int nextHeight = size.y + steps * ysize;
                super.getShell().setBounds(new Rectangle(nextX, nextY, nextWidth, nextHeight));
                --steps;
            }
        }
        super.getShell().setVisible(false);
    }

    public String toString() {
        return this.delegate.toString();
    }

    protected Control createButtonBar(Composite parent) {
        return new Composite(parent, 0);
    }

    public static int openMessageDialog(Rectangle start, Shell parentShell, String dialogTitle, Image dialogImage, String dialogMessage, int dialogImageType, String[] buttonLabels, int defaultIndex) {
        MessageDialog dialog = new MessageDialog(parentShell, dialogTitle, dialogImage, dialogMessage, dialogImageType, buttonLabels, defaultIndex);
        ZoomingDialog zd = new ZoomingDialog(parentShell, (Dialog)dialog, start);
        zd.open();
        return zd.getReturnCode();
    }

    public static void openErrorMessage(Rectangle start, Shell parentShell, String dialogTitle, String dialogMessage) {
        ZoomingDialog.openMessageDialog(start, parentShell, dialogTitle, null, dialogMessage, 1, new String[]{IDialogConstants.OK_LABEL}, 1);
    }

    public static void openWarningMessage(Rectangle start, Shell parentShell, String dialogTitle, String dialogMessage) {
        ZoomingDialog.openMessageDialog(start, parentShell, dialogTitle, null, dialogMessage, 4, new String[]{IDialogConstants.OK_LABEL}, 1);
    }

    public static void openInformationMessage(Rectangle start, Shell parentShell, String dialogTitle, String dialogMessage) {
        ZoomingDialog.openMessageDialog(start, parentShell, dialogTitle, null, dialogMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 1);
    }

    public static boolean openQuestionMessage(Rectangle start, Shell parentShell, String dialogTitle, String dialogMessage) {
        int result = ZoomingDialog.openMessageDialog(start, parentShell, dialogTitle, null, dialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        return result == 2;
    }

    public static Rectangle calculateBounds(Control control) {
        Point ul = control.toDisplay(0, 0);
        Point size2 = control.getSize();
        Rectangle start = new Rectangle(ul.x, ul.y, size2.x, size2.y);
        return start;
    }

    public static Rectangle calculateBounds(TreeItem item, int columnIndex) {
        Rectangle bounds;
        Point ulTree = item.getParent().toDisplay(0, 0);
        if (columnIndex > -1) {
            bounds = item.getBounds(columnIndex);
            bounds.x += ulTree.x;
            bounds.y += ulTree.y;
        } else {
            Rectangle bounds2 = item.getBounds(0);
            bounds = new Rectangle(ulTree.x, ulTree.y, 0, 0);
            bounds.width = item.getParent().getSize().x;
            bounds.height = bounds2.height;
        }
        return bounds;
    }

    private static class ZoomShellProvider
    implements IShellProvider {
        private Shell template;

        public ZoomShellProvider(Shell shell) {
            this.template = shell;
        }

        public Shell getShell() {
            Shell shell = this.template == null ? new Shell() : new Shell(this.template.getDisplay());
            return shell;
        }
    }
}

