/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.core.commands.Category;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public class StartupOperations
implements IStartup {
    public void earlyStartup() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.processOperations(workbench);
    }

    protected void processOperations(IWorkbench workbench) {
        IHandlerService cfr_ignored_0 = (IHandlerService)workbench.getService(IHandlerService.class);
        ICommandService commands = (ICommandService)workbench.getService(ICommandService.class);
        IMenuService menuService = (IMenuService)workbench.getService(IMenuService.class);
        workbench.getActiveWorkbenchWindow();
        List list = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.ui.operation");
        List<IConfigurationElement> categoryElements = this.listCategories(list);
        if (categoryElements == null || categoryElements.isEmpty()) {
            return;
        }
        for (IConfigurationElement element : categoryElements) {
            String ID = element.getAttribute("id");
            String NAME = element.getName();
            String DESCRIPTION = element.getName();
            List<IConfigurationElement> operationElements = this.listOperationsForCategory(list, ID);
            try {
                Category category = commands.getCategory(ID);
                if (!category.isDefined()) {
                    category.define(NAME, DESCRIPTION);
                }
                AbstractContributionFactory categoryAdditions = this.operationsMenu(menuService, operationElements, "menu:nav?after=layer.ext", ID);
                menuService.addContributionFactory(categoryAdditions);
            }
            catch (Exception e) {
                UiPlugin.log("Operation category " + ID + ":" + e, e);
            }
        }
        for (IConfigurationElement element : list) {
            String NAME = element.getName();
            String ID = element.getAttribute("id");
            try {
                if (!NAME.equals("category")) continue;
            }
            catch (Exception e) {
                UiPlugin.log("Operation " + ID + ":" + e, e);
            }
        }
    }

    List<IConfigurationElement> listCategories(List<IConfigurationElement> list) {
        ArrayList<IConfigurationElement> results = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement element : list) {
            String NAME = element.getName();
            element.getAttribute("id");
            if (!NAME.equals("category")) continue;
            results.add(element);
        }
        return results;
    }

    List<IConfigurationElement> listOperationsForCategory(List<IConfigurationElement> list, String categoryId) {
        ArrayList<IConfigurationElement> results = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement element : list) {
            String CATEGORY;
            String NAME = element.getName();
            element.getAttribute("id");
            if (NAME.equals("category") || (CATEGORY = element.getAttribute("categoryId")) == null || !CATEGORY.equals(categoryId)) continue;
            results.add(element);
        }
        return results;
    }

    protected AbstractContributionFactory operationsMenu(IMenuService menuService, List<IConfigurationElement> list, String locationURI, String categoryId) {
        return new AbstractContributionFactory(locationURI, null){

            public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
            }
        };
    }
}

