/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.OffThreadProgressMonitor;
import net.refractions.udig.ui.PostShutdownTask;
import net.refractions.udig.ui.PreShutdownTask;
import net.refractions.udig.ui.ProgressMonitorTaskNamer;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;

public class ShutdownTaskList
implements IWorkbenchListener {
    private static final ShutdownTaskList INSTANCE = new ShutdownTaskList();
    private Collection<PostTask> postShutdownTasks = new LinkedList<PostTask>();
    private Collection<PreTask> preShutdownTasks = new LinkedList<PreTask>();

    public void postShutdown(final IWorkbench workbench) {
        try {
            final ProgressMonitorDialog dialog = this.getDialog(workbench);
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor2) throws InvocationTargetException, InterruptedException {
                    OffThreadProgressMonitor monitor = new OffThreadProgressMonitor(monitor2, dialog.getShell().getDisplay());
                    int totalsteps = 0;
                    for (PostTask task : ShutdownTaskList.this.postShutdownTasks) {
                        try {
                            task.steps = task.task.getProgressMonitorSteps();
                            totalsteps += task.steps;
                        }
                        catch (Throwable e) {
                            UiPlugin.log("error calling getProgressMonitorSteps() on " + task.task, e);
                        }
                    }
                    monitor.beginTask(Messages.ShutdownTaskList_shutDown, totalsteps);
                    for (PostTask task : ShutdownTaskList.this.postShutdownTasks) {
                        ProgressMonitorTaskNamer subMonitor = new ProgressMonitorTaskNamer(monitor, task.steps);
                        try {
                            try {
                                task.task.postShutdown((IProgressMonitor)subMonitor, workbench);
                            }
                            catch (Throwable t) {
                                task.task.handlePostShutdownException(t);
                                subMonitor.done();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            subMonitor.done();
                            throw throwable;
                        }
                        subMonitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public boolean preShutdown(final IWorkbench workbench, final boolean forced) {
        ProgressMonitorDialog dialog = this.getDialog(workbench);
        final boolean[] allowShutdown = new boolean[]{true};
        workbench.getActiveWorkbenchWindow().getShell().setVisible(false);
        final Display display = Display.getCurrent();
        try {
            dialog.run(true, forced, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor2) throws InvocationTargetException, InterruptedException {
                    OffThreadProgressMonitor monitor = new OffThreadProgressMonitor(monitor2, display);
                    int totalsteps = 0;
                    for (PreTask task : ShutdownTaskList.this.preShutdownTasks) {
                        try {
                            task.steps = task.task.getProgressMonitorSteps();
                            totalsteps += task.steps;
                        }
                        catch (Throwable e) {
                            UiPlugin.log("error calling getProgressMonitorSteps() on " + task.task, e);
                        }
                    }
                    monitor.beginTask(Messages.ShutdownTaskList_shutDown, totalsteps);
                    for (PreTask task : ShutdownTaskList.this.preShutdownTasks) {
                        boolean result;
                        block10: {
                            ProgressMonitorTaskNamer subMonitor = new ProgressMonitorTaskNamer(monitor, task.steps);
                            try {
                                try {
                                    result = task.task.preShutdown((IProgressMonitor)subMonitor, workbench, forced);
                                }
                                catch (Throwable t) {
                                    result = task.task.handlePreShutdownException(t, forced);
                                    subMonitor.done();
                                    break block10;
                                }
                            }
                            catch (Throwable throwable) {
                                subMonitor.done();
                                throw throwable;
                            }
                            subMonitor.done();
                        }
                        if (forced) continue;
                        if (monitor.isCanceled() || !result) {
                            allowShutdown[0] = false;
                        }
                        if (!monitor.isCanceled()) continue;
                        return;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        if (!allowShutdown[0]) {
            workbench.getActiveWorkbenchWindow().getShell().setVisible(true);
        }
        return allowShutdown[0];
    }

    private ProgressMonitorDialog getDialog(IWorkbench workbench) {
        Shell shell = new Shell(Display.getCurrent());
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        dialog.open();
        return dialog;
    }

    public static ShutdownTaskList instance() {
        return INSTANCE;
    }

    public synchronized void addPostShutdownTask(PostShutdownTask task) {
        this.postShutdownTasks.add(new PostTask(task));
    }

    public synchronized void addPreShutdownTask(PreShutdownTask task) {
        this.preShutdownTasks.add(new PreTask(task));
    }

    public synchronized void removePreShutdownTask(PreShutdownTask shutdownTask) {
        this.preShutdownTasks.remove(new PreTask(shutdownTask));
    }

    public synchronized void removePostShutdownTask(PostShutdownTask shutdownTask) {
        this.postShutdownTasks.remove(new PostTask(shutdownTask));
    }

    public static class PostTask {
        int steps;
        final PostShutdownTask task;

        public PostTask(PostShutdownTask task) {
            this.task = task;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostTask other = (PostTask)obj;
            return !(this.task == null ? other.task != null : !this.task.equals(other.task));
        }
    }

    public static class PreTask {
        int steps;
        final PreShutdownTask task;

        public PreTask(PreShutdownTask task) {
            this.task = task;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PreTask other = (PreTask)obj;
            return !(this.task == null ? other.task != null : !this.task.equals(other.task));
        }
    }
}

