/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.FeatureTypeEditor;
import net.refractions.udig.ui.LegalAttributeTypes;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.DataStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureTypeEditorDialog
extends Dialog {
    final FeatureTypeEditor editor = new FeatureTypeEditor();
    private SimpleFeatureType defaultFeatureType = this.editor.createDefaultFeatureType();
    private DataStore dataStore;
    private SimpleFeatureType result;
    private ValidateFeatureType validateFeatureType;

    public FeatureTypeEditorDialog(Shell parentShell, ValidateFeatureType strategy) {
        super(parentShell);
        this.validateFeatureType = strategy;
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.FeatureTypeEditorDialog_ShellTitle);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(8, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor.createFeatureTypeNameText(composite, new GridData(4, 4, true, false, 8, 1));
        Composite buttons = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        buttons.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, false, true, 1, 1);
        gridData.widthHint = 32;
        buttons.setLayoutData((Object)gridData);
        this.createButton(buttons, this.editor.getCreateAttributeAction());
        this.createButton(buttons, this.editor.getDeleteAction());
        this.editor.createTable(composite, new GridData(4, 4, true, true, 7, 1), this.defaultFeatureType, true);
        this.editor.createContextMenu();
        return composite;
    }

    private void createButton(Composite composite, final IAction action) {
        Button button = new Button(composite, 0x800008);
        GridData data = new GridData(4, 4, true, false);
        button.setLayoutData((Object)data);
        button.setToolTipText(action.getToolTipText());
        ImageRegistry images = UiPlugin.getDefault().getImageRegistry();
        Image image = images.get(action.getId());
        if (image == null || image.isDisposed()) {
            images.put(action.getId(), action.getImageDescriptor());
            image = images.get(action.getId());
        }
        button.setImage(image);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                action.runWithEvent(event);
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    public boolean close() {
        this.result = this.editor.getFeatureType();
        this.editor.getControl().setFocus();
        return super.close();
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
        if (dataStore instanceof ShapefileDataStore) {
            ArrayList<LegalAttributeTypes> list = new ArrayList<LegalAttributeTypes>(this.editor.getLegalTypes());
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                LegalAttributeTypes type = (LegalAttributeTypes)iter.next();
                if (type.getType() != Geometry.class) continue;
                iter.remove();
            }
            this.editor.setLegalTypes(list);
        }
    }

    protected void okPressed() {
        String errorMessage = this.validateFeatureType.validate(this.editor.getFeatureType());
        if (errorMessage != null) {
            this.editor.setErrorMessage(errorMessage);
        } else {
            this.editor.builderChanged();
            super.okPressed();
        }
    }

    public FeatureTypeEditor getEditor() {
        return this.editor;
    }

    public int open() {
        this.result = null;
        return super.open();
    }

    public SimpleFeatureType getFeatureType(boolean checkForDuplicateFeatureType) {
        if (this.result != null) {
            try {
                if (!checkForDuplicateFeatureType || this.isFeatureTypeOK()) {
                    return this.result;
                }
            }
            catch (SchemaException e) {
                UiPlugin.log("Error creating feature type", e);
            }
        }
        return null;
    }

    private boolean isFeatureTypeOK() throws SchemaException {
        if (this.dataStore == null) {
            return true;
        }
        try {
            this.dataStore.getSchema(this.defaultFeatureType.getName());
            SimpleFeatureTypeBuilder ftB = new SimpleFeatureTypeBuilder();
            ftB.setName(Messages.NewFeatureTypeOp_duplicateTypeName);
            ftB.init(this.defaultFeatureType);
            this.defaultFeatureType = ftB.buildFeatureType();
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public SimpleFeatureTypeBuilder getDefaultBuilder() {
        SimpleFeatureTypeBuilder ftB = new SimpleFeatureTypeBuilder();
        ftB.setName(this.defaultFeatureType.getName());
        ftB.init(this.defaultFeatureType);
        return ftB;
    }

    public void setDefaultFeatureType(SimpleFeatureType defaultFeatureType) {
        this.defaultFeatureType = defaultFeatureType;
    }

    public static interface ValidateFeatureType {
        public String validate(SimpleFeatureType var1);
    }
}

