/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.FeatureTableContentProvider;
import net.refractions.udig.ui.FeatureTableControl;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.WaitCondition;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.FilterAttributeExtractor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;

class FeatureTableSelectionProvider
implements ISelectionProvider {
    private FeatureTableControl owner;
    private Set<String> selectionFids = new HashSet<String>();
    private Set<ISelectionChangedListener> selectionChangedListeners = new CopyOnWriteArraySet<ISelectionChangedListener>();
    volatile IProgressMonitor progressMonitor;
    private IProvider<IProgressMonitor> progressMonitorProvider;

    public FeatureTableSelectionProvider(FeatureTableControl control, IProvider<IProgressMonitor> progressMonitorProvider) {
        this.owner = control;
        this.progressMonitorProvider = progressMonitorProvider;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        this.checkWidget();
        if (this.selectionFids.isEmpty()) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)this.getId());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSelection(ISelection newSelection, boolean reveal) {
        this.checkWidget();
        if (this.progressMonitor != null) {
            this.progressMonitor.setCanceled(true);
            UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", FeatureTableSelectionProvider.class, "#setSelection(): cancelled monitor", null);
        }
        try {
            PlatformGIS.wait(500L, -1L, new WaitCondition(){

                @Override
                public boolean isTrue() {
                    return FeatureTableSelectionProvider.this.progressMonitor == null;
                }
            }, this);
        }
        catch (InterruptedException e) {
            UiPlugin.log("Interrupted", e);
            return;
        }
        FeatureTableSelectionProvider featureTableSelectionProvider = this;
        synchronized (featureTableSelectionProvider) {
            this.progressMonitor = (IProgressMonitor)this.progressMonitorProvider.get(new Object[0]);
            this.progressMonitor.setCanceled(false);
            PlatformGIS.run(new SelectionLoader(newSelection, reveal));
        }
    }

    protected void notifyListeners() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this.owner, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            try {
                listener.selectionChanged(event);
            }
            catch (Throwable e) {
                UiPlugin.log("", e);
            }
        }
    }

    public Collection<String> getSelectionFids() {
        this.checkWidget();
        return this.selectionFids;
    }

    public Id getId() {
        this.checkWidget();
        FilterFactory2 fac = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        Set ids = FeatureUtils.stringToId((FilterFactory)fac, this.selectionFids);
        return fac.id(ids);
    }

    private void checkWidget() {
        if (Display.getCurrent() == null) {
            SWT.error((int)22);
        }
    }

    private static class Abort
    extends Exception {
        private static final long serialVersionUID = 1L;

        private Abort() {
        }
    }

    private class SelectionLoader
    implements ISafeRunnable {
        private final ISelection newSelection;
        private final boolean reveal;

        public SelectionLoader(ISelection newSelection, boolean reveal) {
            this.newSelection = newSelection;
            this.reveal = reveal;
        }

        public void handleException(Throwable exception) {
            UiPlugin.log("Error setting selection on table view", exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            block14: {
                this.startProgress();
                try {
                    if (this.newSelection.isEmpty()) {
                        if (FeatureTableSelectionProvider.this.owner.getViewer().getControl().isDisposed()) {
                            this.done();
                            return;
                        }
                        FeatureTableSelectionProvider.this.owner.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SelectionLoader.this.updateMonitor(3);
                                FeatureTableSelectionProvider.this.owner.getViewer().getTable().setSelection(new TableItem[0]);
                                FeatureTableSelectionProvider.this.selectionFids.clear();
                                SelectionLoader.this.updateMonitor(3);
                                FeatureTableSelectionProvider.this.owner.getViewer().getTable().clearAll();
                                FeatureTableSelectionProvider.this.notifyListeners();
                            }
                        });
                        break block14;
                    }
                    if (!(this.newSelection instanceof IStructuredSelection)) break block14;
                    IStructuredSelection structured = (IStructuredSelection)this.newSelection;
                    final HashSet<String> fids = new HashSet<String>();
                    this.obtainFidsFromSelection(structured, fids);
                    if (FeatureTableSelectionProvider.this.selectionFids.equals(fids)) {
                        return;
                    }
                    try {
                        FeatureTableContentProvider provider = (FeatureTableContentProvider)FeatureTableSelectionProvider.this.owner.getViewer().getContentProvider();
                        final List<SimpleFeature> features = provider.features;
                        int i = 0;
                        List<SimpleFeature> list = provider.features;
                        synchronized (list) {
                            for (SimpleFeature feature : features) {
                                if (fids.contains(feature.getID())) break;
                                ++i;
                            }
                        }
                        this.updateMonitor(1);
                        final int index = i;
                        FeatureTableSelectionProvider.this.owner.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SelectionLoader.this.updateMonitor(1);
                                FeatureTableSelectionProvider.this.owner.getViewer().getTable().setSelection(new TableItem[0]);
                                FeatureTableSelectionProvider.this.selectionFids = fids;
                                Table table = FeatureTableSelectionProvider.this.owner.getViewer().getTable();
                                table.clearAll();
                                if (SelectionLoader.this.reveal && index < features.size()) {
                                    table.setTopIndex(index);
                                }
                                FeatureTableSelectionProvider.this.notifyListeners();
                            }
                        });
                    }
                    catch (Abort abort) {}
                }
                finally {
                    this.done();
                }
            }
        }

        private void updateMonitor(final int ticks) {
            if (Display.getCurrent() != null) {
                FeatureTableSelectionProvider.this.progressMonitor.worked(ticks);
            } else {
                FeatureTableSelectionProvider.this.owner.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((SelectionLoader)SelectionLoader.this).FeatureTableSelectionProvider.this.progressMonitor.worked(ticks);
                    }
                });
            }
        }

        private void done() {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FeatureTableSelectionProvider featureTableSelectionProvider = FeatureTableSelectionProvider.this;
                    synchronized (featureTableSelectionProvider) {
                        ((SelectionLoader)SelectionLoader.this).FeatureTableSelectionProvider.this.progressMonitor.done();
                        ((SelectionLoader)SelectionLoader.this).FeatureTableSelectionProvider.this.progressMonitor = null;
                        FeatureTableSelectionProvider.this.notifyAll();
                    }
                }
            };
            if (Display.getCurrent() != null) {
                runnable.run();
            } else {
                FeatureTableSelectionProvider.this.owner.getControl().getDisplay().asyncExec(runnable);
            }
        }

        private void startProgress() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((SelectionLoader)SelectionLoader.this).FeatureTableSelectionProvider.this.progressMonitor.beginTask(Messages.FeatureTableSelectionProvider_loading_new_selection, 10);
                    ((SelectionLoader)SelectionLoader.this).FeatureTableSelectionProvider.this.progressMonitor.worked(1);
                }
            };
            if (Display.getCurrent() != null) {
                runnable.run();
            } else {
                FeatureTableSelectionProvider.this.owner.getControl().getDisplay().asyncExec(runnable);
            }
        }

        private void obtainFidsFromSelection(IStructuredSelection structured, Set<String> fids) throws IOException, Abort {
            int usedTicks = 0;
            Iterator iter = structured.iterator();
            while (iter.hasNext()) {
                if (FeatureTableSelectionProvider.this.progressMonitor.isCanceled()) {
                    throw new Abort();
                }
                Object element = iter.next();
                if (element instanceof String) {
                    fids.add((String)element);
                } else if (element instanceof SimpleFeature) {
                    fids.add(((SimpleFeature)element).getID());
                } else if (element instanceof Id) {
                    String[] fids2 = ((Id)element).getIDs().toArray(new String[0]);
                    fids.addAll(Arrays.asList(fids2));
                } else if (element instanceof IAdaptable) {
                    this.obtainFidsFromAdaptable(fids, (IAdaptable)element);
                } else if (element instanceof Filter) {
                    UiPlugin.log("Tried to set selection on table but the selection contained a non-Fid Filter that could not adapt to a FeatureSource so the selection could not be applied.  Ignoring filter", null);
                } else {
                    UiPlugin.log("Tried to set selection on table but the selection contained a " + element.getClass().getSimpleName() + " but this type cannot be converted to Fids", null);
                }
                if (usedTicks >= 7) continue;
                this.updateMonitor(1);
            }
            if (usedTicks < 7) {
                this.updateMonitor(7 - usedTicks);
            }
        }

        private void obtainFidsFromAdaptable(final Set<String> fids, IAdaptable adaptable) throws IOException, Abort {
            block14: {
                FeatureSource source;
                Filter filter;
                block13: {
                    filter = null;
                    if (adaptable.getAdapter(Filter.class) != null) {
                        filter = (Filter)adaptable.getAdapter(Filter.class);
                    } else if (adaptable.getAdapter(Query.class) != null) {
                        filter = ((Query)adaptable.getAdapter(Query.class)).getFilter();
                    }
                    if (filter == null) {
                        return;
                    }
                    source = null;
                    if (adaptable.getAdapter(FeatureSource.class) != null) {
                        source = (FeatureSource)adaptable.getAdapter(FeatureSource.class);
                    }
                    if (source != null) break block13;
                    UiPlugin.log("last resource run filter on features in table view...  Might now work since table view does not have any Geometries", new Exception());
                    if (FeatureTableSelectionProvider.this.owner.getViewer() == null || FeatureTableSelectionProvider.this.owner.getViewer().getInput() == null) break block14;
                    for (SimpleFeature feature : ((FeatureTableContentProvider)((FeatureTableSelectionProvider)FeatureTableSelectionProvider.this).owner.getViewer().getContentProvider()).features) {
                        if (FeatureTableSelectionProvider.this.progressMonitor.isCanceled()) {
                            throw new Abort();
                        }
                        if (!filter.evaluate((Object)feature)) continue;
                        fids.add(feature.getID());
                    }
                    break block14;
                }
                DefaultQuery defaultQuery = new DefaultQuery(((SimpleFeatureType)source.getSchema()).getName().getLocalPart(), filter, new String[0]);
                Set required = (Set)filter.accept((FilterVisitor)new FilterAttributeExtractor(), null);
                defaultQuery.setPropertyNames(required.toArray(new String[0]));
                FeatureCollection features = source.getFeatures((Query)defaultQuery);
                long start = System.currentTimeMillis();
                FeatureIterator featureIterator = features.features();
                try {
                    while (featureIterator.hasNext()) {
                        if (FeatureTableSelectionProvider.this.progressMonitor.isCanceled()) {
                            throw new Abort();
                        }
                        if (System.currentTimeMillis() - start > 500L) {
                            start = System.currentTimeMillis();
                            FeatureTableSelectionProvider.this.owner.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ((SelectionLoader)SelectionLoader.this).FeatureTableSelectionProvider.this.progressMonitor.subTask(String.valueOf(fids.size()) + " selected");
                                }
                            });
                        }
                        fids.add(((SimpleFeature)featureIterator.next()).getID());
                    }
                }
                finally {
                    featureIterator.close();
                }
            }
        }
    }
}

