/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.core.StaticProvider;
import net.refractions.udig.ui.FeatureTableControl;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

class FeatureTableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private final FeatureTableControl owningFeatureTableControl;
    private IProvider<RGB> selectionColor = new StaticProvider((Object)new RGB(255, 255, 0));
    private RGB currentRGB = new RGB(255, 255, 0);
    private Color currentColor;

    FeatureTableLabelProvider(FeatureTableControl control) {
        this.owningFeatureTableControl = control;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof FeatureCollection) {
            FeatureCollection fc = (FeatureCollection)element;
            if (columnIndex == 0) {
                return ((SimpleFeatureType)fc.getSchema()).getName().getLocalPart();
            }
            return "";
        }
        if (element instanceof SimpleFeature) {
            SimpleFeature f = (SimpleFeature)element;
            if (columnIndex == 0) {
                return f.getID();
            }
            if (this.owningFeatureTableControl.features == null) {
                return "";
            }
            String attName = this.owningFeatureTableControl.getViewer().getTable().getColumn(columnIndex).getText();
            AttributeDescriptor at = f.getFeatureType().getDescriptor(attName);
            if (Geometry.class.isAssignableFrom(at.getType().getBinding())) {
                Object att = f.getAttribute(attName);
                if (att == null) {
                    return "";
                }
                String s = att.getClass().getName();
                return s.substring(s.lastIndexOf(46) + 1);
            }
            Object attribute = f.getAttribute(attName);
            return attribute == null ? "" : attribute.toString();
        }
        if (element instanceof Throwable) {
            if (columnIndex == 0) {
                return ((Throwable)element).getLocalizedMessage();
            }
            return null;
        }
        if (element instanceof String) {
            return (String)element;
        }
        return Messages.FeatureTableControl_loadingMessage;
    }

    public Color getBackground(Object element) {
        Display currentDisplay = Display.getCurrent();
        if (element == FeatureTableControl.LOADING) {
            return this.getSelectionColor(currentDisplay);
        }
        if (element instanceof Throwable) {
            return currentDisplay.getSystemColor(3);
        }
        if (element instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)element;
            if (this.owningFeatureTableControl.getSelectionProvider().getSelectionFids().contains(feature.getID())) {
                return this.getSelectionColor(currentDisplay);
            }
        }
        return null;
    }

    private Color getSelectionColor(Display display) {
        if (this.currentColor != null && this.currentRGB.equals(this.selectionColor.get(new Object[0]))) {
            return this.currentColor;
        }
        if (this.currentColor != null) {
            this.currentColor.dispose();
        }
        this.currentRGB = (RGB)this.selectionColor.get(new Object[0]);
        this.currentColor = new Color((Device)display, this.currentRGB);
        return this.currentColor;
    }

    public void dispose() {
        super.dispose();
        if (this.currentColor != null) {
            this.currentColor.dispose();
        }
    }

    public Color getForeground(Object element) {
        Display currentDisplay = Display.getCurrent();
        if (element instanceof Throwable) {
            return currentDisplay.getSystemColor(1);
        }
        if (element instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)element;
            if (this.owningFeatureTableControl.getSelectionProvider().getSelectionFids().contains(feature.getID())) {
                if (this.darkBackground()) {
                    return currentDisplay.getSystemColor(1);
                }
                return currentDisplay.getSystemColor(2);
            }
        }
        return null;
    }

    private boolean darkBackground() {
        RGB selectColor2 = (RGB)this.selectionColor.get(new Object[0]);
        int brightness = (selectColor2.red * 299 + selectColor2.green * 587 + selectColor2.blue * 114) / 1000;
        return brightness < 150;
    }

    public void setSelectionColor(IProvider<RGB> selectionColor) {
        this.selectionColor = selectionColor == null ? new StaticProvider((Object)new RGB(255, 255, 0)) : selectionColor;
    }
}

