/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.AttributeColumnSortListener;
import net.refractions.udig.ui.AttributeValidator;
import net.refractions.udig.ui.BasicTypeCellEditor;
import net.refractions.udig.ui.BooleanCellEditor;
import net.refractions.udig.ui.DisplayErrorCellListener;
import net.refractions.udig.ui.FIDComparator;
import net.refractions.udig.ui.FeatureTableContentProvider;
import net.refractions.udig.ui.FeatureTableLabelProvider;
import net.refractions.udig.ui.FeatureTableSelectionProvider;
import net.refractions.udig.ui.IFeatureTableLoadingListener;
import net.refractions.udig.ui.LoadingEvent;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.SelectionComparator;
import net.refractions.udig.ui.WarningCellEditor;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class FeatureTableControl
implements ISelectionProvider {
    public static final String FEATURE_ID_COLUMN_PROPERTY = "FeatureIDProperty";
    public static final Object ERROR_COLUMN_PROPERTY = "ErrorProperty";
    public static final Object LOADING = new Object();
    private int pageSize = 10;
    private TableViewer tableViewer;
    private PageBook book;
    private Text message;
    FeatureCollection<SimpleFeatureType, SimpleFeature> features;
    private final IProvider<IProgressMonitor> progressMonitorProvider;
    private FeatureTableSelectionProvider selectionProvider;
    private Color messageBackground;
    private Color messageForeground;
    private Set<IFeatureTableLoadingListener> loadingListeners = new CopyOnWriteArraySet<IFeatureTableLoadingListener>();
    private Comparator<SimpleFeature> currentComparator;
    private MenuManager contextMenu;
    private IProvider<RGB> selectionColor;
    private boolean shown;
    public static final String CACHING_WARNING = "FEATURE_TABLE_CACHING_IN_MEMORY_WARNING";
    public static final String[] ALL = new String[0];
    private static final boolean SHOW_PATH = false;

    public FeatureTableControl() {
        this(ProgressManager.instance());
    }

    public FeatureTableControl(Composite parent, FeatureCollection<SimpleFeatureType, SimpleFeature> features) {
        this(ProgressManager.instance(), parent, features);
    }

    public FeatureTableControl(IProvider<IProgressMonitor> monitorProvider) {
        this.progressMonitorProvider = monitorProvider;
        this.selectionProvider = new FeatureTableSelectionProvider(this, ProgressManager.instance());
    }

    public FeatureTableControl(IProvider<IProgressMonitor> monitorProvider, Composite parent, FeatureCollection<SimpleFeatureType, SimpleFeature> features) {
        this(monitorProvider);
        this.features = features;
        this.createTableControl(parent);
    }

    public void setPageSize(int resPerPage) {
        this.pageSize = resPerPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Control getControl() {
        return this.book;
    }

    public void dispose() {
        this.disposeTableViewer();
    }

    public void createTableControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.message = new Text((Composite)this.book, 64);
        this.messageBackground = this.message.getBackground();
        this.messageForeground = this.message.getForeground();
        this.createTableViewer((Composite)this.book);
    }

    public boolean showWarning(Display display) {
        IPreferenceStore preferenceStore = UiPlugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getBoolean(CACHING_WARNING) && !this.shown) {
            this.shown = true;
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)display.getActiveShell(), (String)Messages.FeatureTableControl_warningTitle, (String)Messages.FeatureTableControl_warningMessage, (String)Messages.FeatureTableControl_warningToggle, (boolean)false, null, null);
            preferenceStore.setValue(CACHING_WARNING, dialog.getToggleState());
            return dialog.getReturnCode() == 0;
        }
        return true;
    }

    public void update() {
        this.checkWidget();
        if (this.tableViewer != null) {
            this.tableViewer.setInput(this.features);
            this.tableViewer.getTable().clearAll();
        }
    }

    protected void createTableViewer(Composite parent) {
        int style = 0x10010300;
        if (this.tableViewer != null) {
            this.disposeTableViewer();
        }
        Table table = new Table(parent, style);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        FeatureTableContentProvider ftp = new FeatureTableContentProvider(this, this.progressMonitorProvider);
        FeatureTableLabelProvider flp = new FeatureTableLabelProvider(this);
        flp.setSelectionColor(this.selectionColor);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)ftp);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)flp);
        this.createAttributeColumns(table, this.tableViewer, layout);
        table.setHeaderVisible(true);
        this.addSelectionListener(table);
        if (this.features instanceof IAdaptable && ((IAdaptable)this.features).getAdapter(ICellModifier.class) != null) {
            IAdaptable adaptable = (IAdaptable)this.features;
            SimpleFeatureType schema = (SimpleFeatureType)this.features.getSchema();
            int attributeCount = schema.getAttributeCount();
            this.setCellEditors(adaptable, attributeCount);
            this.setCellValidators(adaptable);
            this.addCellEditorListeners(adaptable);
            this.tableViewer.setCellModifier((ICellModifier)adaptable.getAdapter(ICellModifier.class));
            String[] properties = new String[attributeCount + 1];
            int i = 0;
            while (i < properties.length) {
                properties[i] = i == 0 ? FEATURE_ID_COLUMN_PROPERTY : schema.getDescriptor(i - 1).getName().getLocalPart();
                ++i;
            }
            this.tableViewer.setColumnProperties(properties);
        }
        if (this.contextMenu != null) {
            Menu menu = this.contextMenu.createContextMenu(this.tableViewer.getControl());
            this.tableViewer.getControl().setMenu(menu);
        }
        this.book.showPage(this.tableViewer.getControl());
        UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", this.getClass(), "createTableViewer(): showing table View", null);
        if (this.features != null) {
            this.tableViewer.setInput(this.features);
        }
    }

    private void addSelectionListener(final Table table) {
        table.addListener(3, new Listener(){
            int lastIndex = -1;

            public void handleEvent(Event e) {
                if (e.button != 1) {
                    return;
                }
                int index = table.getSelectionIndex();
                FeatureTableContentProvider provider = (FeatureTableContentProvider)FeatureTableControl.this.tableViewer.getContentProvider();
                Collection<String> selectionFids = FeatureTableControl.this.selectionProvider.getSelectionFids();
                table.deselect(index);
                if ((e.stateMask & SWT.MOD2) != 0 && this.lastIndex != -1) {
                    if (this.lastIndex == index) {
                        return;
                    }
                    this.handleSelecteRange(table, index, provider, selectionFids);
                } else if ((e.stateMask & SWT.MOD1) != 0) {
                    this.handleXORSelect(table, index, provider, selectionFids);
                } else {
                    if (this.lastIndex == index) {
                        return;
                    }
                    this.handleDefault(table, index, provider, selectionFids);
                }
                FeatureTableControl.this.selectionProvider.notifyListeners();
            }

            private void handleDefault(Table table2, int index, FeatureTableContentProvider provider, Collection<String> selectionFids) {
                if (index == -1) {
                    selectionFids.clear();
                    table2.clearAll();
                } else {
                    String fid = provider.features.get(index).getID();
                    selectionFids.clear();
                    selectionFids.add(fid);
                    table2.clearAll();
                }
                this.lastIndex = index;
            }

            private void handleXORSelect(Table table2, int index, FeatureTableContentProvider provider, Collection<String> selectionFids) {
                String fid = provider.features.get(index).getID();
                if (selectionFids.contains(fid)) {
                    selectionFids.remove(fid);
                } else {
                    selectionFids.add(fid);
                }
                table2.clear(index);
                this.lastIndex = index;
            }

            private void handleSelecteRange(Table table2, int index, FeatureTableContentProvider provider, Collection<String> selectionFids) {
                selectionFids.clear();
                int low = Math.min(this.lastIndex, index);
                int high = Math.max(this.lastIndex, index);
                if (low == -1 || high == -1) {
                    table2.clearAll();
                    return;
                }
                List<SimpleFeature> toAdd = provider.features.subList(low, high + 1);
                boolean foundUnselectedItem = false;
                for (SimpleFeature feature : toAdd) {
                    if (!selectionFids.add(feature.getID())) continue;
                    foundUnselectedItem = true;
                }
                if (foundUnselectedItem) {
                    table2.clearAll();
                }
            }
        });
    }

    private void disposeTableViewer() {
        Control control;
        IBaseLabelProvider labelProvider;
        if (this.tableViewer == null) {
            return;
        }
        IContentProvider contentProvider = this.tableViewer.getContentProvider();
        if (contentProvider != null) {
            contentProvider.dispose();
        }
        if ((labelProvider = this.tableViewer.getLabelProvider()) != null) {
            labelProvider.dispose();
        }
        if ((control = this.tableViewer.getControl()) != null) {
            control.dispose();
        }
        this.tableViewer = null;
    }

    private void setCellEditors(IAdaptable adaptable, int attributeCount) {
        if (adaptable.getAdapter(CellEditor[].class) != null) {
            CellEditor[] editors = (CellEditor[])adaptable.getAdapter(Array.class);
            if (editors.length < attributeCount) {
                UiPlugin.log("not enough cell editors for feature type so not used", new Exception());
                this.createCellEditors();
            } else {
                CellEditor[] copy = new CellEditor[editors.length + 1];
                if (editors.length == attributeCount) {
                    System.arraycopy(editors, 0, copy, 1, attributeCount);
                } else {
                    System.arraycopy(editors, 1, copy, 1, attributeCount);
                }
                this.tableViewer.setCellEditors(copy);
            }
        } else {
            this.createCellEditors();
        }
    }

    private void addCellEditorListeners(IAdaptable adaptable) {
        CellEditor[] editors = this.tableViewer.getCellEditors();
        int offset = 1;
        ICellEditorListener[] listener = null;
        if (adaptable.getAdapter(ICellEditorListener[].class) != null) {
            int attributeCount;
            listener = (ICellEditorListener[])adaptable.getAdapter(ICellEditorListener[].class);
            if (listener.length < (attributeCount = ((SimpleFeatureType)this.features.getSchema()).getAttributeCount())) {
                UiPlugin.log("not enough cell editors for feature type so not used", new Exception());
                return;
            }
            if (listener.length == attributeCount + 1) {
                offset = 0;
            }
        }
        int i = 0;
        while (i < editors.length - offset) {
            CellEditor editor = editors[i + offset];
            if (editor != null) {
                if (listener != null && listener[i] != null) {
                    editor.addListener(listener[i]);
                }
                editor.addListener((ICellEditorListener)new DisplayErrorCellListener(editor));
            }
            ++i;
        }
    }

    private void setCellValidators(IAdaptable adaptable) {
        CellEditor[] editors = this.tableViewer.getCellEditors();
        SimpleFeatureType schema = (SimpleFeatureType)this.features.getSchema();
        int offset = 1;
        ICellEditorValidator[] validators = null;
        if (adaptable.getAdapter(ICellEditorValidator[].class) != null) {
            int attributeCount;
            validators = (ICellEditorValidator[])adaptable.getAdapter(ICellEditorValidator[].class);
            if (validators.length < (attributeCount = ((SimpleFeatureType)this.features.getSchema()).getAttributeCount())) {
                UiPlugin.log("not enough cell editors for feature type so not used", new Exception());
                validators = null;
            } else if (validators.length == attributeCount) {
                offset = 0;
            }
        }
        int i = 0;
        while (i < editors.length - offset) {
            CellEditor editor = editors[i + offset];
            if (editor != null) {
                if (validators != null && validators[i] != null) {
                    editor.setValidator(validators[i]);
                } else {
                    editor.setValidator((ICellEditorValidator)new AttributeValidator(schema.getDescriptor(i), schema));
                }
            }
            ++i;
        }
    }

    private void createCellEditors() {
        SimpleFeatureType schema = (SimpleFeatureType)this.features.getSchema();
        CellEditor[] editors = new CellEditor[schema.getAttributeCount() + 1];
        int i = 0;
        while (i < schema.getAttributeCount()) {
            Object textCellEditor;
            AttributeDescriptor aType = schema.getDescriptor(i);
            Class concreteType = aType.getType().getBinding();
            Composite control = (Composite)this.tableViewer.getControl();
            if (concreteType.isAssignableFrom(String.class)) {
                textCellEditor = new BasicTypeCellEditor(control, String.class);
                editors[i + 1] = textCellEditor;
            } else if (concreteType.isAssignableFrom(Integer.class)) {
                textCellEditor = new BasicTypeCellEditor(control, Integer.class);
                editors[i + 1] = textCellEditor;
            } else if (concreteType.isAssignableFrom(Double.class)) {
                textCellEditor = new BasicTypeCellEditor(control, Double.class);
                editors[i + 1] = textCellEditor;
            } else if (concreteType.isAssignableFrom(Float.class)) {
                textCellEditor = new BasicTypeCellEditor(control, Float.class);
                editors[i + 1] = textCellEditor;
            } else if (concreteType.isAssignableFrom(Boolean.class)) {
                textCellEditor = new BooleanCellEditor(control);
                editors[i + 1] = textCellEditor;
            } else if (concreteType.isAssignableFrom(Character.class)) {
                textCellEditor = new BasicTypeCellEditor(control, Character.class);
                editors[i + 1] = textCellEditor;
            } else if (concreteType.isAssignableFrom(Byte.class)) {
                textCellEditor = new BasicTypeCellEditor(control, Byte.class);
                editors[i + 1] = textCellEditor;
            } else if (concreteType.isAssignableFrom(Short.class)) {
                textCellEditor = new BasicTypeCellEditor(control, Short.class);
                editors[i + 1] = textCellEditor;
            } else if (concreteType.isAssignableFrom(Long.class)) {
                textCellEditor = new BasicTypeCellEditor(control, Long.class);
                editors[i + 1] = textCellEditor;
            } else {
                textCellEditor = new WarningCellEditor(control, String.valueOf(Messages.FeatureTableControl_noEditor1) + concreteType.getSimpleName() + Messages.FeatureTableControl_noEditor2);
                editors[i + 1] = textCellEditor;
            }
            ++i;
        }
        this.tableViewer.setCellEditors(editors);
    }

    private void createAttributeColumns(Table table, TableViewer viewer, TableLayout layout) {
        if (this.features == null) {
            TableColumn column = new TableColumn(table, 0x1000800);
            column.setText(Messages.FeatureTableControl_1);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        } else {
            SimpleFeatureType schema = (SimpleFeatureType)this.features.getSchema();
            TableColumn column = new TableColumn(table, 0x1000800);
            column.setText("FID");
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 150, true));
            column.setMoveable(true);
            column.addListener(13, (Listener)new AttributeColumnSortListener(this, FEATURE_ID_COLUMN_PROPERTY));
            int i = 0;
            while (i < schema.getAttributeCount()) {
                AttributeDescriptor aType = schema.getDescriptor(i);
                column = new TableColumn(table, 0x1000800);
                if (Geometry.class.isAssignableFrom(aType.getType().getBinding())) {
                    column.setText("GEOMETRY");
                } else {
                    column.setText(aType.getName().getLocalPart());
                }
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
                column.setMoveable(true);
                column.addListener(13, (Listener)new AttributeColumnSortListener(this, aType.getName().getLocalPart()));
                ++i;
            }
        }
    }

    public void setFocus() {
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> features) {
        this.checkWidget();
        if (this.features != null && this.features == features) {
            return;
        }
        this.features = features;
        this.createTableViewer((Composite)this.book);
    }

    private void checkWidget() {
        if (Display.getCurrent() == null) {
            SWT.error((int)22);
        }
    }

    public void clear() {
        this.features = null;
        this.selectionProvider.getSelectionFids().clear();
        this.update();
    }

    public void message(String text, Color background, Color foreground) {
        this.checkWidget();
        Color background2 = background;
        Color foreground2 = foreground;
        if (background2 == null) {
            background2 = this.messageBackground;
        }
        if (foreground2 == null) {
            foreground2 = this.messageForeground;
        }
        this.message.setBackground(background2);
        this.message.setForeground(foreground2);
        if (text == null || text.trim().length() == 0) {
            this.message.setText("");
            if (this.tableViewer != null) {
                this.book.showPage(this.tableViewer.getControl());
                UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", this.getClass(), "message(String,Color,Color): showing table View", null);
            }
        } else {
            this.message.setText(text);
            this.book.showPage((Control)this.message);
            UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", this.getClass(), "message(String,Color,Color): showing message", null);
        }
    }

    public void message(String text) {
        this.message(text, null, null);
    }

    public ISelection getSelection() {
        this.checkWidget();
        return this.selectionProvider.getSelection();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection newSelection) {
        this.checkWidget();
        this.selectionProvider.setSelection(newSelection);
    }

    public void promoteSelection() {
        this.checkWidget();
        this.tableViewer.cancelEditing();
        Table table = this.tableViewer.getTable();
        table.setSortColumn(null);
        Id filter = this.selectionProvider.getId();
        this.sort(new SelectionComparator((Filter)filter, 128, new FIDComparator(1024)), 128, null);
        table.setTopIndex(0);
    }

    public void sort(Comparator<SimpleFeature> comparator, int dir, TableColumn sortColumn) {
        Table table;
        this.checkWidget();
        FeatureTableContentProvider provider = (FeatureTableContentProvider)this.tableViewer.getContentProvider();
        boolean sorted = false;
        if (!comparator.equals(this.currentComparator)) {
            sorted = true;
            this.currentComparator = comparator;
            Collections.sort(provider.features, this.currentComparator);
        }
        if ((table = this.tableViewer.getTable()).getSortColumn() != sortColumn) {
            sorted = true;
            table.setSortColumn(sortColumn);
            while (Display.getCurrent().readAndDispatch()) {
            }
        }
        if (table.getSortColumn() != null && dir != table.getSortDirection()) {
            sorted = true;
            table.setSortDirection(dir);
            while (Display.getCurrent().readAndDispatch()) {
            }
        }
        if (sorted) {
            table.deselectAll();
            table.clearAll();
        }
    }

    void sort(boolean refreshTable) {
        if (this.currentComparator == null) {
            return;
        }
        FeatureTableContentProvider provider = (FeatureTableContentProvider)this.tableViewer.getContentProvider();
        Collections.sort(provider.features, this.currentComparator);
        this.tableViewer.getTable().deselectAll();
        if (refreshTable) {
            this.tableViewer.getTable().clearAll();
        }
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    FeatureTableSelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void setSelection(StructuredSelection selection, boolean reveal) {
        this.selectionProvider.setSelection((ISelection)selection, reveal);
    }

    public int getSelectionCount() {
        return this.selectionProvider.getSelectionFids().size();
    }

    public void select(Set<FeatureId> selection) {
        this.getSelectionProvider().getSelectionFids().clear();
        int j = 0;
        int firstMatch = -1;
        for (FeatureId id : selection) {
            this.selectionProvider.getSelectionFids().add(id.getID());
            if (firstMatch == -1) {
                firstMatch = j;
            }
            ++j;
        }
        Table table = this.tableViewer.getTable();
        if (firstMatch != -1) {
            table.setTopIndex(firstMatch);
        }
        table.clearAll();
        this.selectionProvider.notifyListeners();
    }

    public void select(String cql, boolean selectAll) throws CQLException {
        Filter filter = CQL.toFilter((String)cql);
        FeatureTableContentProvider provider = (FeatureTableContentProvider)this.tableViewer.getContentProvider();
        List<SimpleFeature> toSearch = provider.features;
        IProgressMonitor progressMonitor = this.getSelectionProvider().progressMonitor;
        if (progressMonitor != null) {
            progressMonitor.setCanceled(true);
        }
        this.getSelectionProvider().getSelectionFids().clear();
        int j = 0;
        int firstMatch = -1;
        for (SimpleFeature feature : toSearch) {
            if (filter.evaluate((Object)feature)) {
                this.selectionProvider.getSelectionFids().add(feature.getID());
                if (firstMatch == -1) {
                    firstMatch = j;
                }
                if (!selectAll) break;
            }
            ++j;
        }
        Table table = this.tableViewer.getTable();
        if (firstMatch != -1) {
            table.setTopIndex(firstMatch);
        }
        table.clearAll();
        this.selectionProvider.notifyListeners();
    }

    public void select(String text, String[] attributes, boolean selectAll) throws PatternSyntaxException {
        Pattern pattern = this.compilePattern(text);
        if (pattern == null) {
            return;
        }
        FeatureTableContentProvider provider = (FeatureTableContentProvider)this.tableViewer.getContentProvider();
        List<SimpleFeature> toSearch = provider.features;
        IProgressMonitor progressMonitor = this.getSelectionProvider().progressMonitor;
        if (progressMonitor != null) {
            progressMonitor.setCanceled(true);
        }
        this.getSelectionProvider().getSelectionFids().clear();
        int j = 0;
        int firstMatch = -1;
        for (SimpleFeature feature : toSearch) {
            if (this.searchFeature(feature, pattern, attributes)) {
                if (firstMatch == -1) {
                    firstMatch = j;
                }
                if (!selectAll) break;
            }
            ++j;
        }
        Table table = this.tableViewer.getTable();
        if (firstMatch != -1) {
            table.setTopIndex(firstMatch);
        }
        table.clearAll();
        this.selectionProvider.notifyListeners();
    }

    private Pattern compilePattern(String text) {
        Pattern pattern;
        String[] parts = text.split("\\|");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String pre = ".*";
            String post = ".*";
            if (string.startsWith("^") || string.startsWith(".") || string.startsWith("\\A")) {
                pre = "";
            }
            if (string.startsWith("&") || string.startsWith("\\Z") || string.startsWith("\\z")) {
                post = "";
            }
            builder.append(pre);
            builder.append(string);
            builder.append(post);
            builder.append('|');
            ++n2;
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        try {
            pattern = Pattern.compile(builder.toString(), 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                pattern = Pattern.compile(".*" + this.convertToLiteral(text) + ".*");
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
        return pattern;
    }

    private boolean searchFeature(SimpleFeature feature, Pattern pattern, String[] attributes) {
        int i;
        SimpleFeatureType featureType = feature.getFeatureType();
        if (attributes == ALL) {
            i = 0;
            while (i < featureType.getAttributeCount()) {
                if (this.matches(pattern, feature.getAttribute(i))) {
                    this.selectionProvider.getSelectionFids().add(feature.getID());
                    return true;
                }
                ++i;
            }
        }
        i = 0;
        while (i < attributes.length) {
            if (this.matches(pattern, feature.getAttribute(attributes[i]))) {
                this.getSelectionProvider().getSelectionFids().add(feature.getID());
                return true;
            }
            ++i;
        }
        return false;
    }

    private String convertToLiteral(String text) {
        String text2 = text.replace("\\", "\\\\");
        text2 = text2.replace("*", "\\*");
        text2 = text2.replace("+", "\\+");
        text2 = text2.replace(".", "\\.");
        text2 = text2.replace("?", "\\?");
        text2 = text2.replace("[", "\\[");
        text2 = text2.replace("]", "\\]");
        text2 = text2.replace("^", "\\^");
        text2 = text2.replace("-", "\\-");
        text2 = text2.replace("&", "\\&");
        text2 = text2.replace("(", "\\(");
        text2 = text2.replace(")", "\\)");
        text2 = text2.replace("|", "\\|");
        return text2;
    }

    private boolean matches(Pattern pattern, Object attribute) {
        if (attribute == null) {
            attribute = "";
        }
        String stringValue = attribute.toString();
        return pattern.matcher(stringValue).matches();
    }

    public void addLoadingListener(IFeatureTableLoadingListener listener) {
        this.loadingListeners.add(listener);
    }

    public void remove(IFeatureTableLoadingListener listener) {
        this.loadingListeners.remove(listener);
    }

    protected void notifyLoadingListeners(LoadingEvent event) {
        this.checkWidget();
        if (event.loading) {
            if (event.monitor == null) {
                throw new NullPointerException();
            }
            for (IFeatureTableLoadingListener listener : this.loadingListeners) {
                try {
                    listener.loadingStarted(event.monitor);
                }
                catch (Throwable e) {
                    UiPlugin.log(listener + " threw an exception", e);
                }
            }
        } else {
            for (IFeatureTableLoadingListener listener : this.loadingListeners) {
                try {
                    listener.loadingStopped(event.canceled);
                }
                catch (Throwable e) {
                    UiPlugin.log(listener + " threw an exception", e);
                }
            }
        }
    }

    public void update(FeatureCollection<SimpleFeatureType, SimpleFeature> features2) {
        if (this.features == null) {
            return;
        }
        FeatureTableContentProvider provider = (FeatureTableContentProvider)this.tableViewer.getContentProvider();
        provider.update(features2);
    }

    public void assertInternallyConsistent() {
        if (this.tableViewer.getContentProvider() != null) {
            FeatureTableContentProvider provider = (FeatureTableContentProvider)this.tableViewer.getContentProvider();
            provider.assertInternallyConsistent();
        }
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> deleteSelection() {
        FeatureTableContentProvider provider = (FeatureTableContentProvider)this.tableViewer.getContentProvider();
        return provider.deleteSelection();
    }

    public void setMenuManager(MenuManager contextMenu) {
        this.checkWidget();
        this.contextMenu = contextMenu;
        if (this.tableViewer != null && this.tableViewer.getControl() != null) {
            Menu oldMenu = this.tableViewer.getControl().getMenu();
            if (oldMenu != null) {
                oldMenu.dispose();
            }
            Menu menu = contextMenu.createContextMenu(this.tableViewer.getControl());
            this.tableViewer.getControl().setMenu(menu);
        }
    }

    public void setSelectionColor(IProvider<RGB> selectionColor) {
        this.selectionColor = selectionColor;
        if (this.tableViewer != null) {
            FeatureTableLabelProvider labelProvider = (FeatureTableLabelProvider)this.tableViewer.getLabelProvider();
            labelProvider.setSelectionColor(selectionColor);
        }
    }
}

