/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExceptionDetailsDialog
extends Dialog {
    private final Object throwable;
    private final String title;
    private final String message;
    private final Image image;
    private Button detailsButton;
    private Control detailsArea;
    private Point cachedWindowSize;

    private ExceptionDetailsDialog(Shell parentShell, String title, String message, IStatus status, Throwable throwable) {
        super((IShellProvider)new SameShellProvider((Control)parentShell));
        this.title = ExceptionDetailsDialog.getTitle(title, throwable);
        this.image = ExceptionDetailsDialog.getImage(status);
        this.message = ExceptionDetailsDialog.getMessage(message, throwable);
        this.throwable = throwable;
        this.setShellStyle(67696);
    }

    public static void openError(final String title, final String message, final int istatus, final String pluginID, final Throwable throwable) {
        PlatformGIS.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                Status status = new Status(istatus, pluginID, istatus, throwable.getLocalizedMessage(), throwable);
                String msg = message;
                if (msg == null) {
                    msg = "";
                }
                msg = String.valueOf(msg) + Messages.ExceptionDetailsEditorMessage;
                ExceptionDetailsDialog dialog = new ExceptionDetailsDialog(Display.getDefault().getActiveShell(), title, msg, (IStatus)status, throwable, null);
                dialog.open();
            }
        });
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(768));
        if (this.image != null) {
            ((GridLayout)composite.getLayout()).numColumns = 2;
            label = new Label(composite, 0);
            this.image.setBackground(label.getBackground());
            label.setImage(this.image);
            label.setLayoutData((Object)new GridData(66));
        }
        label = new Label(composite, 64);
        if (this.message != null) {
            label.setText(this.message);
        }
        GridData data = new GridData(772);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void toggleDetailsArea() {
        Point oldWindowSize = this.getShell().getSize();
        Point newWindowSize = this.cachedWindowSize;
        this.cachedWindowSize = oldWindowSize;
        if (this.detailsArea == null) {
            this.detailsArea = this.createDetailsArea((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        } else {
            this.detailsArea.dispose();
            this.detailsArea = null;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        }
        Point oldSize = this.getContents().getSize();
        Point newSize = this.getContents().computeSize(-1, -1);
        if (newWindowSize == null) {
            newWindowSize = new Point(oldWindowSize.x, oldWindowSize.y + (newSize.y - oldSize.y));
        }
        Point windowLoc = this.getShell().getLocation();
        Rectangle screenArea = this.getContents().getDisplay().getClientArea();
        if (newWindowSize.y > screenArea.height - (windowLoc.y - screenArea.y)) {
            newWindowSize.y = screenArea.height - (windowLoc.y - screenArea.y);
        }
        this.getShell().setSize(newWindowSize);
        ((Composite)this.getContents()).layout();
    }

    public static String getTitle(String title, Object details) {
        if (title != null) {
            return title;
        }
        if (details instanceof Throwable) {
            Throwable e = (Throwable)details;
            while (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            String name = e.getClass().getName();
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return "Exception";
    }

    public static Image getImage(Object details) {
        Display display = Display.getCurrent();
        if (details instanceof IStatus) {
            switch (((IStatus)details).getSeverity()) {
                case 4: {
                    return display.getSystemImage(1);
                }
                case 2: {
                    return display.getSystemImage(8);
                }
                case 1: {
                    return display.getSystemImage(2);
                }
                case 0: {
                    return null;
                }
            }
        }
        return display.getSystemImage(1);
    }

    public static String getMessage(String message, Object details) {
        if (details instanceof Throwable) {
            Throwable e = (Throwable)details;
            while (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (message == null) {
                return e.toString();
            }
            return MessageFormat.format(message, e.toString());
        }
        if (details instanceof IStatus) {
            String statusMessage = ((IStatus)details).getMessage();
            if (message == null) {
                return statusMessage;
            }
            return MessageFormat.format(message, statusMessage);
        }
        if (message != null) {
            return message;
        }
        return "An Exception occurred.";
    }

    public static void appendException(PrintWriter writer, Throwable ex) {
        if (ex instanceof CoreException) {
            ExceptionDetailsDialog.appendStatus(writer, ((CoreException)ex).getStatus(), 0);
            writer.println();
        }
        ExceptionDetailsDialog.appendStackTrace(writer, ex);
        if (ex instanceof InvocationTargetException) {
            ExceptionDetailsDialog.appendException(writer, ((InvocationTargetException)ex).getTargetException());
        }
    }

    public static void appendStatus(PrintWriter writer, IStatus status, int nesting) {
        int i = 0;
        while (i < nesting) {
            writer.print("  ");
            ++i;
        }
        writer.println(status.getMessage());
        IStatus[] children = status.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            ExceptionDetailsDialog.appendStatus(writer, children[i2], nesting + 1);
            ++i2;
        }
    }

    public static void appendStackTrace(PrintWriter writer, Throwable ex) {
        ex.printStackTrace(writer);
    }

    protected Control createDetailsArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        this.createDetailsViewer(panel);
        return panel;
    }

    protected Control createDetailsViewer(Composite parent) {
        if (this.throwable == null) {
            return null;
        }
        Text text = new Text(parent, 2826);
        text.setLayoutData((Object)new GridData(1808));
        StringWriter writer = new StringWriter(1000);
        if (this.throwable instanceof Throwable) {
            ExceptionDetailsDialog.appendException(new PrintWriter(writer), (Throwable)this.throwable);
        } else if (this.throwable instanceof IStatus) {
            ExceptionDetailsDialog.appendStatus(new PrintWriter(writer), (IStatus)this.throwable, 0);
        }
        text.setText(writer.toString());
        return text;
    }

    /* synthetic */ ExceptionDetailsDialog(Shell shell, String string, String string2, IStatus iStatus, Throwable throwable, ExceptionDetailsDialog exceptionDetailsDialog) {
        this(shell, string, string2, iStatus, throwable);
    }
}

