/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedMap;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

public final class CharsetSelectionDialog
extends FilteredItemsSelectionDialog {
    public CharsetSelectionDialog(Shell shell, boolean multi) {
        this(shell, false, "*");
    }

    public CharsetSelectionDialog(Shell shell, boolean multi, String initialSelection) {
        super(shell, multi);
        this.setTitle(Messages.CharsetSelectionDialog_title);
        this.setSelectionHistory(new CharsetSelectionHistory());
        this.setInitialPattern(initialSelection);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Charset)o1).compareTo((Charset)o2);
            }
        };
    }

    public String getElementName(Object item) {
        return ((Charset)item).displayName();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection("CharsetChange");
        if (section == null) {
            section = settings.addNewSection("CharsetChange");
        }
        return section;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        progressMonitor.beginTask("Searching", charsets.size());
        for (Charset charset : charsets.values()) {
            contentProvider.add((Object)charset, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        SearchPattern searchPattern = new SearchPattern(){

            public void setPattern(String stringPattern) {
                if (stringPattern.length() == 0) {
                    super.setPattern("*");
                } else {
                    super.setPattern(stringPattern);
                }
            }
        };
        FilteredItemsSelectionDialog.ItemsFilter itemsFilter = new FilteredItemsSelectionDialog.ItemsFilter(this, searchPattern){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                return this.matches(((Charset)item).name()) || this.matches(((Charset)item).displayName());
            }
        };
        return itemsFilter;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public void setPattern(String value) {
        this.setResult(Collections.singletonList(Charset.forName(value)));
    }

    public class CharsetSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }
}

