/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.Controller;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CRSChooser {
    private static final String WKT_ID = "WKT";
    private static final String ALIASES_ID = "ALIASES";
    private static final String LAST_ID = "LAST_ID";
    private static final String NAME_ID = "NAME_ID";
    private static final String CUSTOM_ID = "CRS.Custom.Services";
    private static final Controller DEFAULT = new Controller(){

        @Override
        public void handleClose() {
        }

        @Override
        public void handleOk() {
        }
    };
    ListViewer codesList;
    Text searchText;
    Text wktText;
    Text keywordsText;
    CoordinateReferenceSystem selectedCRS;
    Matcher matcher = Pattern.compile(".*?\\(([^(]*)\\)$").matcher("");
    private TabFolder folder;
    private Controller parentPage;
    private HashMap<String, String> crsCodeMap;
    private CoordinateReferenceSystem sourceCRS;

    public CRSChooser(Controller parentPage) {
        this.parentPage = parentPage;
    }

    public CRSChooser() {
        this(DEFAULT);
    }

    private Control createCustomCRSControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        Label keywordsLabel = new Label(composite, 0);
        keywordsLabel.setText(Messages.CRSChooser_keywordsLabel);
        keywordsLabel.setLayoutData((Object)gridData);
        keywordsLabel.setToolTipText(Messages.CRSChooser_tooltip);
        gridData = new GridData(4, 0, true, false);
        this.keywordsText = new Text(composite, 2052);
        this.keywordsText.setLayoutData((Object)gridData);
        this.keywordsText.setToolTipText(Messages.CRSChooser_tooltip);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        Label editorLabel = new Label(composite, 0);
        editorLabel.setText(Messages.CRSChooser_label_crsWKT);
        editorLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.wktText = new Text(composite, 2818);
        if (this.selectedCRS != null) {
            this.wktText.setText(this.selectedCRS.toWKT());
        }
        this.wktText.setLayoutData((Object)gridData);
        this.wktText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CRSChooser.this.keywordsText.isEnabled()) {
                    CRSChooser.this.keywordsText.setEnabled(true);
                }
            }
        });
        this.searchText.setFocus();
        return composite;
    }

    private Control createStandardCRSControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        Label codesLabel = new Label(composite, 0);
        codesLabel.setText(Messages.CRSChooser_label_crs);
        codesLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, false, false);
        this.searchText = new Text(composite, 2436);
        this.searchText.setLayoutData((Object)gridData);
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CRSChooser.this.fillCodesList();
            }
        });
        this.searchText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x1000002) {
                    CRSChooser.this.codesList.getControl().setFocus();
                }
            }
        });
        gridData = new GridData(400, 300);
        this.codesList = new ListViewer(composite);
        this.codesList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.codesList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.codesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CRSChooser.this.selectedCRS = null;
                String crsCode = (String)((IStructuredSelection)CRSChooser.this.codesList.getSelection()).getFirstElement();
                if (crsCode == null) {
                    return;
                }
                CRSChooser.this.matcher.reset(crsCode);
                if (CRSChooser.this.matcher.matches()) {
                    CRSChooser.this.selectedCRS = CRSChooser.this.createCRS(CRSChooser.this.matcher.group(1));
                    if (CRSChooser.this.selectedCRS != null && CRSChooser.this.wktText != null) {
                        CRSChooser.this.wktText.setEditable(true);
                        String wkt = null;
                        try {
                            wkt = CRSChooser.this.selectedCRS.toWKT();
                        }
                        catch (Exception exception) {
                            wkt = CRSChooser.this.selectedCRS.toString();
                            CRSChooser.this.wktText.setEditable(false);
                        }
                        CRSChooser.this.wktText.setText(wkt);
                        Preferences node = CRSChooser.this.findNode(CRSChooser.this.matcher.group(1));
                        if (node != null) {
                            Preferences kn = node.node(CRSChooser.ALIASES_ID);
                            try {
                                String[] keywords = kn.keys();
                                if (keywords.length > 0) {
                                    StringBuffer buffer = new StringBuffer();
                                    String[] stringArray = keywords;
                                    int n = keywords.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String string = stringArray[n2];
                                        buffer.append(", ");
                                        buffer.append(string);
                                        ++n2;
                                    }
                                    buffer.delete(0, 2);
                                    CRSChooser.this.keywordsText.setText(buffer.toString());
                                }
                            }
                            catch (BackingStoreException e) {
                                UiPlugin.log("", e);
                            }
                        } else {
                            CRSChooser.this.keywordsText.setText("");
                        }
                    }
                }
            }
        });
        this.codesList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CRSChooser.this.parentPage.handleOk();
                CRSChooser.this.parentPage.handleClose();
            }
        });
        this.codesList.getControl().setLayoutData((Object)gridData);
        this.fillCodesList();
        this.searchText.setFocus();
        return composite;
    }

    public void setFocus() {
        this.searchText.setFocus();
    }

    public Control createControl(Composite parent, CoordinateReferenceSystem crs) {
        Control control = this.createControl(parent);
        this.selectedCRS = crs;
        this.gotoCRS(this.selectedCRS);
        return control;
    }

    public void clearSearch() {
        this.searchText.setText("");
    }

    public void gotoCRS(CoordinateReferenceSystem crs) {
        if (crs != null) {
            org.eclipse.swt.widgets.List list = this.codesList.getList();
            HashSet identifiers = new HashSet(crs.getIdentifiers());
            HashSet<Integer> candidates = new HashSet<Integer>();
            int i = 0;
            while (i < list.getItemCount()) {
                for (Identifier identifier : identifiers) {
                    String item;
                    if (this.sameEPSG(crs, identifier, item = list.getItem(i)) || this.exactMatch(crs, identifier, item)) {
                        this.codesList.setSelection((ISelection)new StructuredSelection((Object)item), false);
                        list.setTopIndex(i);
                        return;
                    }
                    if (!this.isMatch(crs, identifier, item)) continue;
                    candidates.add(i);
                }
                ++i;
            }
            if (candidates.isEmpty()) {
                List input = (List)this.codesList.getInput();
                String sourceCRSName = crs.getName().toString();
                this.sourceCRS = crs;
                input.add(0, sourceCRSName);
                this.codesList.setInput((Object)input);
                this.codesList.setSelection((ISelection)new StructuredSelection((Object)sourceCRSName), false);
                list.setTopIndex(0);
                try {
                    String toWKT = crs.toWKT();
                    this.wktText.setText(toWKT);
                }
                catch (RuntimeException e) {
                    UiPlugin.log(String.valueOf(crs.toString()) + " cannot be formatted as WKT", e);
                    this.wktText.setText(Messages.CRSChooser_unknownWKT);
                }
            } else {
                Integer next = (Integer)candidates.iterator().next();
                this.codesList.setSelection((ISelection)new StructuredSelection((Object)list.getItem(next.intValue())), false);
                list.setTopIndex(next.intValue());
            }
        }
    }

    private boolean exactMatch(CoordinateReferenceSystem crs, Identifier identifier, String item) {
        return crs == DefaultGeographicCRS.WGS84 && item.equals("WGS 84 (4326)") || item.equalsIgnoreCase(identifier.toString()) || this.isInCodeMap(identifier, item);
    }

    private boolean isInCodeMap(Identifier identifier, String item) {
        String name = this.crsCodeMap.get(identifier.getCode());
        if (name == null) {
            return false;
        }
        return name.equals(item);
    }

    private boolean sameEPSG(CoordinateReferenceSystem crs, Identifier identifier, String item) {
        String toString = identifier.toString();
        return toString.contains("EPSG:") && item.contains(toString);
    }

    private boolean isMatch(CoordinateReferenceSystem crs, Identifier identifier, String item) {
        return crs == DefaultGeographicCRS.WGS84 && item.contains("4326") || item.contains(identifier.toString());
    }

    public Control createControl(Composite parent) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, true);
        this.folder = new TabFolder(parent, 0);
        this.folder.setLayoutData((Object)gridData);
        TabItem standard = new TabItem(this.folder, 0);
        standard.setText(Messages.CRSChooser_tab_standardCRS);
        Control stdCRS = this.createStandardCRSControl((Composite)this.folder);
        standard.setControl(stdCRS);
        TabItem custom = new TabItem(this.folder, 0);
        custom.setText(Messages.CRSChooser_tab_customCRS);
        Control cstCRS = this.createCustomCRSControl((Composite)this.folder);
        custom.setControl(cstCRS);
        return this.folder;
    }

    protected boolean matchesFilter(String input, String[] filter) {
        String[] stringArray = filter;
        int n = filter.length;
        int n2 = 0;
        while (n2 < n) {
            String match = stringArray[n2];
            if (!input.contains(match)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Set<String> filterCRSNames(String[] filter) {
        this.crsCodeMap = new HashMap();
        TreeSet<String> descriptions = new TreeSet<String>();
        for (Object object : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)object;
            try {
                Set codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
                for (Object codeObj : codes) {
                    String description;
                    String code = (String)codeObj;
                    try {
                        description = factory.getDescriptionText(code).toString();
                    }
                    catch (Exception exception) {
                        description = Messages.CRSChooser_unnamed;
                    }
                    description = String.valueOf(description) + " (" + code + ")";
                    this.crsCodeMap.put(code, description);
                    if (!this.matchesFilter(description.toUpperCase(), filter)) continue;
                    descriptions.add(description);
                }
            }
            catch (FactoryException e) {
                UiPlugin.trace(CRSChooser.class, "CRS Authority:" + e.getMessage(), e);
            }
        }
        return descriptions;
    }

    protected void fillCodesList() {
        String[] searchParms = this.searchText.getText().toUpperCase().split(" ");
        Set<String> descriptions = this.filterCRSNames(searchParms);
        descriptions = this.filterCustomCRSs(descriptions, searchParms);
        ArrayList<String> list = new ArrayList<String>(descriptions);
        this.codesList.setInput(list);
        if (list != null && !list.isEmpty()) {
            this.codesList.setSelection((ISelection)new StructuredSelection(list.get(0)));
        } else {
            this.codesList.setSelection((ISelection)new StructuredSelection());
        }
    }

    private Set<String> filterCustomCRSs(Set<String> descriptions, String[] searchParms) {
        try {
            Preferences root = UiPlugin.getUserPreferences();
            Preferences node = root.node("instance").node(CUSTOM_ID);
            String[] stringArray = node.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Preferences child = node.node(id);
                String string = child.get(NAME_ID, null);
                if (string != null && this.matchesFilter(string.toUpperCase(), searchParms)) {
                    descriptions.add(string);
                } else {
                    Preferences aliases = child.node(ALIASES_ID);
                    String[] stringArray2 = aliases.keys();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String alias = stringArray2[n4];
                        if (this.matchesFilter(alias.toUpperCase(), searchParms)) {
                            descriptions.add(string);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            UiPlugin.log("", e);
        }
        return descriptions;
    }

    protected CoordinateReferenceSystem createCRS(String code) {
        if (code == null) {
            return null;
        }
        for (Object object : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)object;
            try {
                return (CoordinateReferenceSystem)factory.createObject(code);
            }
            catch (FactoryException factoryException) {
            }
            catch (Exception e) {
                UiPlugin.log("Error creating CRS object, trying more...", e);
            }
        }
        try {
            String wkt;
            Preferences child = this.findNode(code);
            if (child != null && (wkt = child.get(WKT_ID, null)) != null) {
                try {
                    return ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(wkt);
                }
                catch (Exception e) {
                    UiPlugin.log(wkt, e);
                    child.removeNode();
                }
            }
        }
        catch (Exception e) {
            UiPlugin.log(null, e);
        }
        return null;
    }

    private Preferences findNode(String code) {
        try {
            Preferences root = UiPlugin.getUserPreferences();
            Preferences node = root.node("instance").node(CUSTOM_ID);
            if (node.nodeExists(code)) {
                return node.node(code);
            }
            String[] stringArray = node.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Preferences child = node.node(id);
                String name = child.get(NAME_ID, null);
                if (name != null && this.matchesFilter(name, new String[]{code})) {
                    return child;
                }
                ++n2;
            }
            return null;
        }
        catch (BackingStoreException e) {
            UiPlugin.log("Error loading", e);
            return null;
        }
    }

    public CoordinateReferenceSystem getCRS() {
        if (this.folder == null) {
            return this.selectedCRS;
        }
        if (this.folder.getSelectionIndex() == 1) {
            try {
                String text = this.wktText.getText();
                CoordinateReferenceSystem createdCRS = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(text);
                if (this.keywordsText.getText().trim().length() > 0) {
                    Preferences node = this.findNode(createdCRS.getName().getCode());
                    if (node != null) {
                        Preferences kn = node.node(ALIASES_ID);
                        String[] keywords = this.keywordsText.getText().split(",");
                        kn.clear();
                        String[] stringArray = keywords;
                        int n = keywords.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string = stringArray[n2];
                            if ((string = string.trim().toUpperCase()).length() > 0) {
                                kn.put(string, string);
                            }
                            ++n2;
                        }
                        kn.flush();
                    } else {
                        CoordinateReferenceSystem found = this.createCRS(createdCRS.getName().getCode());
                        if (found != null && CRS.findMathTransform((CoordinateReferenceSystem)found, (CoordinateReferenceSystem)createdCRS, (boolean)true).isIdentity()) {
                            this.saveKeywords(found);
                            return found;
                        }
                        HashSet identifiers = new HashSet(createdCRS.getIdentifiers());
                        for (Identifier identifier : identifiers) {
                            found = this.createCRS(identifier.toString());
                            if (found == null || !CRS.findMathTransform((CoordinateReferenceSystem)found, (CoordinateReferenceSystem)createdCRS, (boolean)true).isIdentity()) continue;
                            this.saveKeywords(found);
                            return found;
                        }
                        return this.saveCustomizedCRS(text, true, createdCRS);
                    }
                }
                return createdCRS;
            }
            catch (Exception e) {
                UiPlugin.log("", e);
            }
        }
        if (this.selectedCRS == null) {
            String crsCode = (String)((IStructuredSelection)this.codesList.getSelection()).getFirstElement();
            if (this.sourceCRS != null && crsCode != null && crsCode.equals(this.sourceCRS.getName().toString())) {
                System.out.println("source crs: " + this.sourceCRS.getName().toString());
                return this.sourceCRS;
            }
            return this.createCRS(this.searchText.getText());
        }
        return this.selectedCRS;
    }

    private void saveKeywords(CoordinateReferenceSystem found) throws CoreException, IOException, BackingStoreException {
        String[] keywords = this.keywordsText.getText().split(",");
        if (keywords.length > 0) {
            boolean legalKeyword = false;
            int i = 0;
            while (i < keywords.length) {
                String string = keywords[i];
                if ((string = string.trim().toUpperCase()).length() > 0) {
                    legalKeyword = true;
                    break;
                }
                ++i;
            }
            if (legalKeyword) {
                this.saveCustomizedCRS(found.toWKT(), false, found);
            }
        }
        this.keywordsText.setText("");
        this.wktText.setText(found.toWKT());
    }

    private CoordinateReferenceSystem saveCustomizedCRS(String text, boolean processWKT, CoordinateReferenceSystem createdCRS) throws CoreException, IOException, BackingStoreException {
        String newWKT;
        String name;
        String code;
        Preferences root = UiPlugin.getUserPreferences();
        Preferences node = root.node("instance").node(CUSTOM_ID);
        if (processWKT) {
            int lastID = Integer.parseInt(node.get(LAST_ID, "0"));
            code = "UDIG:" + lastID;
            name = String.valueOf(createdCRS.getName().toString()) + "(" + code + ")";
            node.putInt(LAST_ID, ++lastID);
            newWKT = this.processingWKT(text, lastID);
        } else {
            Set ids = createdCRS.getIdentifiers();
            if (!ids.isEmpty()) {
                Identifier id = (Identifier)ids.iterator().next();
                code = id.toString();
                name = String.valueOf(createdCRS.getName().getCode()) + " (" + code + ")";
            } else {
                name = code = createdCRS.getName().getCode();
            }
            newWKT = text;
        }
        Preferences child = node.node(code);
        child.put(NAME_ID, name);
        child.put(WKT_ID, newWKT);
        String[] keywords = this.keywordsText.getText().split(",");
        if (keywords.length > 0) {
            Preferences keyworkNode = child.node(ALIASES_ID);
            String[] stringArray = keywords;
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                string = string.trim().toUpperCase();
                keyworkNode.put(string, string);
                ++n2;
            }
        }
        node.flush();
        return createdCRS;
    }

    private String processingWKT(String text, int lastID) {
        String newWKT;
        String[] prep = text.split(",");
        if (prep[prep.length - 2].toUpperCase().contains("AUTHORITY")) {
            String substring = text.substring(0, text.lastIndexOf(44));
            newWKT = String.valueOf(substring.substring(0, substring.lastIndexOf(44))) + ", AUTHORITY[\"UDIG\",\"" + (lastID - 1) + "\"]]";
        } else {
            newWKT = String.valueOf(text.substring(0, text.lastIndexOf(93))) + ", AUTHORITY[\"UDIG\",\"" + (lastID - 1) + "\"]]";
        }
        this.wktText.setText(newWKT);
        return newWKT;
    }

    public void setController(Controller controller) {
        this.parentPage = controller;
    }
}

