/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class BasicTypeCellEditor
extends TextCellEditor {
    private Class<? extends Object> type;
    private Object lastLegalValue;

    public BasicTypeCellEditor(Composite composite, Class<? extends Object> type) {
        super(composite);
        if (!this.isLegalType(type)) {
            throw new IllegalArgumentException(type + " is not a supported type by this editor");
        }
        this.type = type;
    }

    protected boolean isCorrect(Object value) {
        if (value == null) {
            return super.isCorrect(value);
        }
        try {
            return super.isCorrect(this.convertToType(value.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return super.isCorrect(value);
        }
    }

    protected Object doGetValue() {
        return this.safeConvertToType(super.doGetValue());
    }

    private Object safeConvertToType(Object value2) {
        String value = (String)value2;
        value = value.trim();
        try {
            Object convertToType;
            this.lastLegalValue = convertToType = this.convertToType(value);
            return convertToType;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.lastLegalValue != null) {
                return this.lastLegalValue;
            }
            return 0;
        }
    }

    protected void doSetValue(Object value) {
        String stringValue;
        if (value != null && !this.isLegalType(value.getClass())) {
            throw new IllegalArgumentException(this.type + " is not a supported type by this editor");
        }
        if (value == null) {
            stringValue = "";
        } else {
            stringValue = value.toString();
            this.lastLegalValue = value;
        }
        super.doSetValue((Object)stringValue);
    }

    private boolean isLegalType(Class<? extends Object> type) {
        if (type == Short.class) {
            return true;
        }
        if (type == String.class) {
            return true;
        }
        if (type == Integer.class) {
            return true;
        }
        if (type == Byte.class) {
            return true;
        }
        if (type == Character.class) {
            return true;
        }
        if (type == Long.class) {
            return true;
        }
        if (type == Double.class) {
            return true;
        }
        if (type == Float.class) {
            return true;
        }
        if (type == BigDecimal.class) {
            return true;
        }
        return type == BigInteger.class;
    }

    private Object convertToType(String value) {
        if (this.type == Short.class) {
            return Short.valueOf(value);
        }
        if (this.type == String.class) {
            return value;
        }
        if (this.type == Integer.class) {
            return Integer.valueOf(value);
        }
        if (this.type == Byte.class) {
            return Byte.valueOf(value);
        }
        if (this.type == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        if (this.type == Long.class) {
            return Long.valueOf(value);
        }
        if (this.type == Double.class) {
            return Double.valueOf(value);
        }
        if (this.type == Float.class) {
            return Float.valueOf(value);
        }
        if (this.type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (this.type == BigInteger.class) {
            return new BigInteger(value);
        }
        return null;
    }
}

