/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.Comparator;
import net.refractions.udig.ui.AttributeComparator;
import net.refractions.udig.ui.FIDComparator;
import net.refractions.udig.ui.FeatureTableControl;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.opengis.feature.simple.SimpleFeature;

class AttributeColumnSortListener
implements Listener {
    private TableViewer viewer;
    private String columnProperty;
    private FeatureTableControl featureTable;

    public AttributeColumnSortListener(FeatureTableControl featureTable, String columnProperty) {
        this.viewer = featureTable.getViewer();
        this.featureTable = featureTable;
        this.columnProperty = columnProperty;
    }

    public void handleEvent(Event e) {
        TableColumn sortColumn = this.viewer.getTable().getSortColumn();
        TableColumn selectedColumn = (TableColumn)e.widget;
        int dir = this.viewer.getTable().getSortDirection();
        dir = sortColumn == selectedColumn ? (dir == 128 ? 1024 : 128) : 1024;
        Comparator<SimpleFeature> comparator = this.getComparator(selectedColumn, 1024);
        this.featureTable.sort(comparator, dir, selectedColumn);
    }

    private Comparator<SimpleFeature> getComparator(TableColumn currentColumn, int dir) {
        if (this.columnProperty.equals("FeatureIDProperty")) {
            return new FIDComparator(dir);
        }
        return new AttributeComparator(dir, this.columnProperty);
    }
}

