/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui.operations;

import java.util.ArrayList;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.internal.ui.operations.OperationContentProvider;
import net.refractions.udig.internal.ui.operations.OperationLabelProvider;
import net.refractions.udig.internal.ui.operations.OperationMenuFactory;
import net.refractions.udig.internal.ui.operations.OperationSorter;
import net.refractions.udig.ui.internal.Messages;
import net.refractions.udig.ui.operations.OpAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RunOperationDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "RunOperationDialog";
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 250;
    private static final String STORE_EXPANDED_CATEGORIES_ID = "RunOperationDialog.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_OPERATION_ID = "RunOperationDialog.STORE_SELECTED_OPERATION_ID";
    private TreeViewer tree;
    private Button okButton;
    private OpAction[] opActions = new OpAction[0];
    private OperationMenuFactory opMenuFactory;

    public RunOperationDialog(Shell parentShell, OperationMenuFactory opMenuFactory) {
        super(parentShell);
        this.opMenuFactory = opMenuFactory;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(buttonId);
    }

    protected void cancelPressed() {
        this.opActions = new OpAction[0];
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.RunOperationDialog_run_operation);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createViewer(composite);
        this.layoutTopControl(this.tree.getControl());
        this.restoreWidgetValues();
        return composite;
    }

    private void createViewer(Composite parent) {
        this.tree = new TreeViewer(parent, 2818);
        this.tree.setLabelProvider((IBaseLabelProvider)new OperationLabelProvider());
        this.tree.setContentProvider((IContentProvider)new OperationContentProvider());
        this.tree.setSorter((ViewerSorter)new OperationSorter());
        this.tree.setInput((Object)this.opMenuFactory);
        this.tree.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tree.addDoubleClickListener((IDoubleClickListener)this);
        this.tree.getTree().setFont(parent.getFont());
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (this.tree.isExpandable(element)) {
            this.tree.setExpandedState(element, !this.tree.getExpandedState(element));
        } else if (this.opActions.length > 0) {
            this.saveWidgetValues();
            this.setReturnCode(0);
            this.close();
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTING_SECTION_NAME);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTING_SECTION_NAME);
        }
        return section;
    }

    public OpAction[] getSelection() {
        OpAction[] copy = new OpAction[this.opActions.length];
        System.arraycopy(this.opActions, 0, copy, 0, this.opActions.length);
        return copy;
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        spec.widthHint = 250;
        spec.heightHint = 300;
        control.setLayoutData((Object)spec);
    }

    protected void restoreWidgetValues() {
        OpAction action;
        String selectedOperationID;
        IDialogSettings settings = this.getDialogSettings();
        String[] expandedCategoryIds = settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (expandedCategoryIds == null) {
            return;
        }
        ArrayList<OperationCategory> categoriesToExpand = new ArrayList<OperationCategory>(expandedCategoryIds.length);
        int i = 0;
        while (i < expandedCategoryIds.length) {
            OperationCategory category = this.opMenuFactory.findCategory(expandedCategoryIds[i]);
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++i;
        }
        if (!categoriesToExpand.isEmpty()) {
            this.tree.setExpandedElements(categoriesToExpand.toArray());
        }
        if ((selectedOperationID = settings.get(STORE_SELECTED_OPERATION_ID)) != null && (action = this.opMenuFactory.find(selectedOperationID)) != null) {
            this.tree.setSelection((ISelection)new StructuredSelection((Object)action), true);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        Object[] expandedElements = this.tree.getExpandedElements();
        String[] expandedCategoryIds = new String[expandedElements.length];
        int i = 0;
        while (i < expandedElements.length) {
            expandedCategoryIds[i] = ((OperationCategory)((Object)expandedElements[i])).getId();
            ++i;
        }
        settings.put(STORE_EXPANDED_CATEGORIES_ID, expandedCategoryIds);
        String selectedOperationID = "";
        if (this.opActions.length > 0) {
            selectedOperationID = this.opActions[0].getId();
        }
        settings.put(STORE_SELECTED_OPERATION_ID, selectedOperationID);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.getSelection().length > 0);
        }
    }

    protected void updateSelection(SelectionChangedEvent event) {
        ArrayList descs = new ArrayList();
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        for (Object o : sel) {
            if (!(o instanceof OpAction)) continue;
            descs.add(o);
        }
        this.opActions = new OpAction[descs.size()];
        descs.toArray(this.opActions);
    }
}

