/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui.operations;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.ui.operations.OpAction;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;

public class OperationCategory
extends MenuManager {
    List<OpAction> actions = new ArrayList<OpAction>();
    MenuManager manager;
    String description;

    public OperationCategory(IConfigurationElement element) {
        super(element.getAttribute("name"), element.getAttribute("id"));
        this.description = element.getAttribute("description");
    }

    public MenuManager createContextMenu() {
        this.manager = new MenuManager(this.getMenuText(), this.getId());
        for (OpAction action : this.actions) {
            if (!action.isEnabled()) continue;
            this.manager.add((IAction)action);
        }
        return this.manager;
    }

    public String getDescription() {
        return this.description;
    }

    public void add(IAction action) {
        assert (action instanceof OpAction);
        this.actions.add((OpAction)action);
        ((OpAction)action).setCategory(this);
        super.add(action);
    }

    public void setSelection(ISelection selection) {
        for (OpAction action : this.actions) {
            action.selectionChanged(null, selection);
        }
    }

    public void enablementChanged() {
        boolean enabled = false;
        for (OpAction action : this.actions) {
            if (!action.isEnabled()) continue;
            enabled = true;
            break;
        }
        if (this.getMenu() != null && this.getMenu().getParentItem() != null) {
            this.getMenu().getParentItem().setEnabled(enabled);
        }
    }

    public List<OpAction> getActions() {
        return this.actions;
    }

    public String toString() {
        return this.getMenuText();
    }
}

