/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import com.google.common.base.Function;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.refractions.udig.core.AbstractUdigUIPlugin;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.internal.ui.UDIGAuthenticator;
import net.refractions.udig.internal.ui.operations.OperationMenuFactory;
import net.refractions.udig.ui.MenuBuilder;
import net.refractions.udig.ui.UDIGMenuBuilder;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public class UiPlugin
extends AbstractUdigUIPlugin {
    public static final String ICONS_PATH = "icons/";
    public static final String ID = "net.refractions.udig.ui";
    public static final String DROP_ACTIONS_ID = "net.refractions.udig.ui.dropActions";
    public static final String DROP_TRANSFERS_ID = "net.refractions.udig.ui.dropTransfers";
    public static final String MAPPINGS_FILENAME = "about.mappings";
    private static final String UDIG_VERSION_KEY = "1";
    private static final String UDIG_PRODUCT_ID = "net.refractions.udig.product";
    private URL iconsUrl;
    private OperationMenuFactory operationMenuFactory;
    private MenuBuilder menuBuilder;
    private String version;
    private static UiPlugin INSTANCE;
    private static final String PROXYQUOTES = "'";

    public UiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.iconsUrl = context.getBundle().getEntry(ICONS_PATH);
        Authenticator.setDefault(new UDIGAuthenticator());
        UiPlugin.disableCerts();
        try {
            this.loadVersion();
            System.setProperty("http.agent", "uDig " + this.getVersion() + " (http://udig.refractions.net)");
            System.setProperty("https.agent", "uDig " + this.getVersion() + " (http://udig.refractions.net)");
        }
        catch (Throwable e) {
            UiPlugin.log("error determining version", e);
        }
    }

    private static void disableCerts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {}
        try {
            URL url = new URL("https://hostname/index.html");
            url.toString();
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void loadVersion() {
        ResourceBundle bundle;
        block20: {
            IProduct product = Platform.getProduct();
            if (product == null || !UDIG_PRODUCT_ID.equals(product.getId())) {
                String message = "Unable to parse version from about.mappings file. Defaulting to a blank string.";
                this.getLog().log((IStatus)new Status(1, ID, 0, message, null));
                this.version = "";
                return;
            }
            Bundle pluginBundle = product.getDefiningBundle();
            URL mappingsURL = FileLocator.find((Bundle)pluginBundle, (IPath)new Path(MAPPINGS_FILENAME), null);
            if (mappingsURL != null) {
                try {
                    mappingsURL = FileLocator.resolve((URL)mappingsURL);
                }
                catch (IOException e) {
                    mappingsURL = null;
                    String message = "Unable to find " + mappingsURL + " Defaulting to a blank string.";
                    this.getLog().log((IStatus)new Status(4, ID, 0, message, (Throwable)e));
                }
            }
            bundle = null;
            if (mappingsURL != null) {
                InputStream is = null;
                try {
                    try {
                        is = mappingsURL.openStream();
                        bundle = new PropertyResourceBundle(is);
                    }
                    catch (IOException e) {
                        bundle = null;
                        String message = "Unable to parse version from about.mappings file. Defaulting to a blank string.";
                        this.getLog().log((IStatus)new Status(4, ID, 0, message, (Throwable)e));
                        try {
                            if (is != null) {
                                is.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException) {}
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (bundle != null) {
            this.version = bundle.getString(UDIG_VERSION_KEY);
        }
    }

    public String getVersion() {
        return this.version;
    }

    synchronized ImageDescriptor create(String id) {
        URL url = null;
        try {
            url = new URL(this.iconsUrl, id);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
        this.getImageRegistry().put(id, image);
        return image;
    }

    public static UiPlugin getDefault() {
        return INSTANCE;
    }

    public OperationMenuFactory getOperationMenuFactory() {
        if (this.operationMenuFactory == null) {
            this.operationMenuFactory = new OperationMenuFactory();
        }
        return this.operationMenuFactory;
    }

    public static void log(Class clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format("Exception in {0}.{1}: {2}", clazz.getName(), methodName, t);
        UiPlugin.log(msg, t);
    }

    public static void log(String message2, Throwable e) {
        String message = message2;
        if (message == null) {
            message = "";
        }
        UiPlugin.getDefault().getLog().log((IStatus)new Status(1, ID, 0, message, e));
    }

    public static void log(IStatus status) {
        UiPlugin.getDefault().getLog().log(status);
    }

    private static void trace(String message, Throwable e) {
        if (UiPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace(System.out);
            }
        }
    }

    public static void trace(String traceID, Class<?> caller, String message, Throwable e) {
        if (UiPlugin.isDebugging(traceID)) {
            UiPlugin.trace(caller, message, e);
        }
    }

    public static void trace(Class<?> caller, String message, Throwable e) {
        UiPlugin.trace(String.valueOf(caller.getSimpleName()) + ": " + message, e);
    }

    public static boolean isDebugging(String trace) {
        return UiPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public MenuBuilder getMenuFactory() {
        if (this.menuBuilder == null) {
            this.menuBuilder = this.lookupMenuBuilder();
        }
        return this.menuBuilder;
    }

    private MenuBuilder lookupMenuBuilder() {
        Class<MenuBuilder> interfaceClass = MenuBuilder.class;
        String prefConstant = "menuBuilder";
        String xpid = "net.refractions.udig.ui.menuBuilders";
        String idField = "id";
        String classField = "class";
        MenuBuilder mb = (MenuBuilder)UiPlugin.lookupConfigurationObject(interfaceClass, this.getPreferenceStore(), ID, prefConstant, xpid, idField, classField);
        if (mb != null) {
            return mb;
        }
        return new UDIGMenuBuilder();
    }

    public static int getMaxHeapSize() throws IOException {
        final Pattern pattern = Pattern.compile("Xmx([0-9]+)([mMgGkKbB])");
        final int[] heapS = new int[1];
        UiPlugin.processAppIni(true, new Function<String, String>(){

            public String apply(String line) {
                if (line.matches(".*Xmx.*")) {
                    Matcher matcher = pattern.matcher(line);
                    matcher.find();
                    int num = Integer.parseInt(matcher.group(1));
                    String unit = matcher.group(2).toLowerCase();
                    if (unit.equals("m")) {
                        heapS[0] = num * 1;
                    } else if (unit.equals("g")) {
                        heapS[0] = num * 1024;
                    } else if (unit.equals("k")) {
                        heapS[0] = num / 1024;
                    } else if (unit.equals("b")) {
                        heapS[0] = num / 0x100000;
                    }
                }
                return line;
            }
        });
        return heapS[0];
    }

    public static void setMaxHeapSize(final String maxHeapSize) throws FileNotFoundException, IOException {
        UiPlugin.processAppIni(false, new Function<String, String>(){

            public String apply(String line) {
                if (line.matches(".*Xmx([0-9]+)([mMgGkKbB]).*")) {
                    line = line.replaceFirst("Xmx([0-9]+)([mMgGkKbB])", "Xmx" + maxHeapSize + "M");
                }
                return line;
            }
        });
    }

    public static void setProxy(String proxyHost, String proxyPort, String proxyNonHost) throws FileNotFoundException, IOException {
        File iniFile = UiPlugin.getIniFile();
        BufferedReader bR = null;
        StringBuilder sB = new StringBuilder();
        try {
            bR = new BufferedReader(new FileReader(iniFile));
            String line = null;
            while ((line = bR.readLine()) != null) {
                if (line.matches(".*Dhttp.proxy.*") || line.matches(".*Dhttp.nonProxy.*") || line.matches("")) continue;
                sB.append(line).append("\n");
            }
        }
        finally {
            bR.close();
        }
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null && proxyPort.length() > 0) {
            sB.append("-Dhttp.proxyHost=").append(proxyHost).append("\n");
            sB.append("-Dhttp.proxyPort=").append(proxyPort).append("\n");
            if (proxyNonHost != null && proxyNonHost.length() > 0) {
                proxyNonHost = PROXYQUOTES + proxyNonHost + PROXYQUOTES;
                sB.append("-Dhttp.nonProxyHosts=").append(proxyNonHost).append("\n");
            }
        }
        BufferedWriter bW = null;
        try {
            bW = new BufferedWriter(new FileWriter(iniFile));
            bW.write(sB.toString());
        }
        finally {
            bW.close();
        }
    }

    public static Properties getProxySettings() throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        File iniFile = UiPlugin.getIniFile();
        BufferedReader bR = new BufferedReader(new FileReader(iniFile));
        String line = null;
        while ((line = bR.readLine()) != null) {
            if (line.matches(".*Dhttp.proxyHost.*")) {
                String proxyHost = line.split("=")[1].trim();
                properties.put("http.proxyHost", proxyHost);
            }
            if (line.matches(".*Dhttp.proxyPort.*")) {
                String proxyPort = line.split("=")[1].trim();
                properties.put("http.proxyPort", proxyPort);
            }
            if (!line.matches(".*Dhttp.nonProxyHosts.*")) continue;
            String proxyNonHosts = line.split("=")[1].trim();
            proxyNonHosts = proxyNonHosts.replaceAll(PROXYQUOTES, "");
            properties.put("http.nonProxyHosts", proxyNonHosts);
        }
        bR.close();
        return properties;
    }

    private static void processAppIni(boolean readOnly, Function<String, String> func) throws IOException {
        File iniFile = UiPlugin.getIniFile();
        if (iniFile != null && iniFile.exists()) {
            BufferedReader bR = null;
            BufferedWriter bW = null;
            try {
                ArrayList<String> updatedLines = new ArrayList<String>();
                bR = new BufferedReader(new FileReader(iniFile));
                String line = null;
                while ((line = bR.readLine()) != null) {
                    String newLine = (String)func.apply((Object)line);
                    updatedLines.add(newLine);
                    updatedLines.add("\n");
                }
                if (!readOnly) {
                    bW = new BufferedWriter(new FileWriter(iniFile));
                    for (String string : updatedLines) {
                        bW.write(string);
                    }
                }
            }
            finally {
                try {
                    if (bR != null) {
                        bR.close();
                    }
                }
                finally {
                    if (bW != null) {
                        bW.close();
                    }
                }
            }
        }
        if (!readOnly) {
            UiPlugin.log("udig.ini changed:" + iniFile, null);
        }
    }

    private static File getIniFile() {
        URL installLoc = Platform.getInstallLocation().getURL();
        File appFolder = new File(installLoc.getFile());
        String[] list = appFolder.list();
        String iniName = null;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            if (l.endsWith(".ini")) {
                iniName = l;
            }
            ++n2;
        }
        if (iniName == null) {
            return null;
        }
        File iniFile = new File(appFolder, iniName);
        return iniFile;
    }

    public static Object lookupConfigurationObject(Class<?> interfaceClass, IPreferenceStore store, String pluginID, String prefConstant, String xpid, final String idField, final String classField) {
        final String configurationID = store.getString(prefConstant);
        if (configurationID != null && !configurationID.equals("")) {
            try {
                final Object[] configObj = new Object[1];
                final Throwable[] error = new Throwable[1];
                ExtensionPointProcessor p = new ExtensionPointProcessor(){

                    public void process(IExtension extension, IConfigurationElement element) throws Exception {
                        try {
                            if (element.getAttribute(idField) != null && element.getAttribute(idField).equals(configurationID)) {
                                Object obj;
                                configObj[0] = obj = element.createExecutableExtension(classField);
                            }
                        }
                        catch (Exception e) {
                            configObj[0] = null;
                            error[0] = e;
                        }
                    }
                };
                ExtensionPointUtil.process((Plugin)UiPlugin.getDefault(), (String)xpid, (ExtensionPointProcessor)p);
                if (configObj[0] != null) {
                    return configObj[0];
                }
                MessageFormat format = new MessageFormat(Messages.UDIGWorkbenchWindowAdvisor_specifiedButNotFound);
                Object[] args = new Object[]{configurationID, interfaceClass.getName()};
                StringBuffer message = format.format(args, new StringBuffer(), (FieldPosition)null);
                Throwable e = null;
                if (error[0] != null) {
                    e = error[0];
                }
                UiPlugin.log(message.toString(), e);
            }
            catch (Exception e) {
                UiPlugin.log(MessageFormat.format(Messages.UDIGWorkbenchWindowAdvisor_classNotFound, new Object[]{configurationID}, interfaceClass.getName()), e);
            }
        }
        return null;
    }

    public static Preferences getUserPreferences() {
        return new InstanceScope().getNode(ID);
    }

    public IPath getIconPath() {
        return new Path(ICONS_PATH);
    }
}

