/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.internal.ui.TipDialog;
import net.refractions.udig.internal.ui.UDIGActionBarAdvisor;
import net.refractions.udig.internal.ui.UDIGWorkbenchConfiguration;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import net.refractions.udig.ui.WorkbenchConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.osgi.service.prefs.Preferences;

public class UDIGWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public UDIGWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        WorkbenchConfiguration configuration = this.lookupConfiguration();
        configuration.configureWorkbench(configurer);
        UDIGDragDropUtilities.registerUDigDND(configurer);
    }

    private WorkbenchConfiguration lookupConfiguration() {
        Class<WorkbenchConfiguration> interfaceClass = WorkbenchConfiguration.class;
        String prefConstant = "workbenchConfiguration";
        String xpid = "net.refractions.udig.ui.workbenchConfigurations";
        String idField = "id";
        String classField = "class";
        WorkbenchConfiguration config = (WorkbenchConfiguration)UiPlugin.lookupConfigurationObject(interfaceClass, UiPlugin.getDefault().getPreferenceStore(), "net.refractions.udig.ui", prefConstant, xpid, idField, classField);
        if (config == null) {
            return new UDIGWorkbenchConfiguration();
        }
        return config;
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new UDIGActionBarAdvisor(configurer);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        try {
            Preferences userPreferences = UiPlugin.getUserPreferences();
            if (!userPreferences.nodeExists("net.refractions.udig.ui.firstRun")) {
                this.firstRun();
            } else {
                this.showTip();
            }
        }
        catch (Exception e) {
            UiPlugin.log("", e);
        }
    }

    private void showTip() {
        try {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            if (store.getBoolean("showTips") && TipDialog.hasTips() && !CorePlugin.isDeveloping()) {
                TipDialog dialog = new TipDialog(this.getWindowConfigurer().getWindow().getShell());
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        }
        catch (Exception e) {
            UiPlugin.log("", e);
        }
    }

    private void firstRun() throws Exception {
        Preferences userPreferences = UiPlugin.getUserPreferences();
        userPreferences.node("net.refractions.udig.ui.firstRun").putBoolean("net.refractions.udig.ui.isFirstRun", false);
    }
}

