/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.internal.ui.UDIGDropHandler;
import net.refractions.udig.ui.UDIGDropTargetListener;
import net.refractions.udig.ui.ViewerDropLocation;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;

public class UDIGViewerDropAdapter
extends ViewerDropAdapter
implements UDIGDropTargetListener {
    UDIGDropHandler handler;
    private IDropTargetProvider defaultTarget;

    public UDIGViewerDropAdapter(Viewer viewer, IDropTargetProvider defaultTarget) {
        super(viewer);
        this.setFeedbackEnabled(true);
        this.handler = new UDIGDropHandler();
        this.defaultTarget = defaultTarget;
    }

    private void initHandler(DropTargetEvent event) {
        Object target = super.determineTarget(event);
        if (target == null) {
            target = this.defaultTarget.getTarget(event);
        }
        this.handler.setTarget(target);
        this.handler.setViewerLocation(ViewerDropLocation.valueOf(this.getCurrentLocation()));
    }

    public UDIGDropHandler getDropHandler() {
        return this.handler;
    }

    public void dragEnter(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.dragEnter(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.dragOperationChanged(event);
    }

    public void dragOver(DropTargetEvent event) {
        this.initHandler(event);
        super.dragOver(event);
        this.handler.dragOver(event);
    }

    public void dropAccept(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.dropAccept(event);
    }

    public void drop(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.drop(event);
    }

    public boolean performDrop(Object data) {
        this.handler.performDrop(data, null);
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return true;
    }

    @Override
    public IDropTargetProvider getDropTargetProvider() {
        return this.defaultTarget;
    }

    @Override
    public void setDropTargetProvider(IDropTargetProvider newProvider) {
        this.defaultTarget = newProvider;
    }

    protected int determineLocation(DropTargetEvent event) {
        if (!(event.item instanceof Item)) {
            return 4;
        }
        Item item = (Item)event.item;
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.getViewer().getControl().toControl(coordinates);
        if (item != null) {
            Rectangle bounds = this.getBounds(item);
            if (bounds == null) {
                return 4;
            }
            int thirdOfItem = bounds.height / 3;
            if (coordinates.y - bounds.y < thirdOfItem) {
                return 1;
            }
            if (bounds.y + bounds.height - coordinates.y < thirdOfItem) {
                return 2;
            }
        }
        return 3;
    }
}

