/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.awt.Rectangle;
import java.rmi.server.UID;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ShutdownTaskList;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;

public class UDIGStartup
implements IStartup {
    public void earlyStartup() {
        UDIGStartup.checkForGDI();
        UDIGStartup.loadCommonlyUsedObject();
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)ShutdownTaskList.instance());
        this.standByWelcome();
    }

    private void standByWelcome() {
        PlatformGIS.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
                IIntroPart intro = introManager.getIntro();
                if (intro != null) {
                    introManager.setIntroStandby(intro, true);
                }
            }
        });
    }

    protected static void loadCommonlyUsedObject() {
        new UID();
    }

    public static boolean checkForGDI() {
        final boolean[] status = new boolean[1];
        if (Platform.getOS().equals("win32")) {
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Image image = null;
                    Path path = null;
                    try {
                        try {
                            image = new Image((Device)display, 10, 10);
                            path = AWTSWTImageUtils.convertToPath(new Rectangle(0, 0, 8, 8), (Device)display);
                            status[0] = true;
                        }
                        catch (Exception exception) {
                            String message = String.valueOf(Messages.UDIGApplication_error1) + Messages.UDIGApplication_error2 + "http://www.microsoft.com/downloads/details.aspx?FamilyID=6A63AB9C-DF12-4D41-933C-BE590FEAA05A&displaylang=en";
                            UiPlugin.log(message, null);
                            MessageDialog dialog = new MessageDialog(display.getActiveShell(), Messages.UDIGApplication_title, null, message, 1, new String[]{"Exit", "Continue"}, 0);
                            int answer = dialog.open();
                            if (answer == 0) {
                                PlatformUI.getWorkbench().close();
                            }
                            if (image != null) {
                                image.dispose();
                            }
                            if (path != null) {
                                path.dispose();
                            }
                        }
                    }
                    finally {
                        if (image != null) {
                            image.dispose();
                        }
                        if (path != null) {
                            path.dispose();
                        }
                    }
                }
            });
        }
        return status[0];
    }
}

