/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class UDIGExportedPreferences
implements IExportedPreferences {
    private IPreferenceStore store;
    private CopyOnWriteArraySet<IEclipsePreferences.INodeChangeListener> nodeChangeListeners = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<IEclipsePreferences.IPreferenceChangeListener> preferenceChangeListeners = new CopyOnWriteArraySet();
    private String nodePath;
    private Map<String, String> map = new HashMap<String, String>();
    private Map<String, UDIGExportedPreferences> children = new HashMap<String, UDIGExportedPreferences>();

    public UDIGExportedPreferences(IPreferenceStore store, String nodePath) {
        if (nodePath.contains(":")) {
            throw new IllegalArgumentException("Node name cannot contain a ':'");
        }
        if (nodePath.contains("$")) {
            throw new IllegalArgumentException("Node name cannot contain a '$'");
        }
        this.store = store;
        this.nodePath = nodePath;
        try {
            this.sync();
        }
        catch (Exception e) {
            UiPlugin.log("", e);
        }
    }

    public boolean isExportRoot() {
        return false;
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.nodeChangeListeners.add(listener);
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.nodeChangeListeners.remove(listener);
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.preferenceChangeListeners.add(listener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.preferenceChangeListeners.remove(listener);
    }

    public void removeNode() throws BackingStoreException {
        this.store.setToDefault(this.nodePath);
    }

    public Preferences node(String path) {
        String string = String.valueOf(this.nodePath) + "/" + path;
        if (this.children.get(path) != null) {
            return (Preferences)this.children.get(path);
        }
        UDIGExportedPreferences preferences = new UDIGExportedPreferences(this.store, string);
        this.children.put(path, preferences);
        return preferences;
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        visitor.visit((IEclipsePreferences)this);
    }

    public void put(String key, String value) {
        this.map.put(key, value);
    }

    public String get(String key, String def) {
        return this.map.get(key);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void clear() throws BackingStoreException {
        this.map.clear();
    }

    public void putInt(String key, int value) {
        this.map.put(key, String.valueOf(value));
    }

    public int getInt(String key, int def) {
        String string = this.map.get(key);
        if (string == null) {
            return def;
        }
        return Integer.parseInt(string);
    }

    public void putLong(String key, long value) {
        this.map.put(key, String.valueOf(value));
    }

    public long getLong(String key, long def) {
        String string = this.map.get(key);
        if (string == null) {
            return def;
        }
        return Long.parseLong(string);
    }

    public void putBoolean(String key, boolean value) {
        this.map.put(key, String.valueOf(value));
    }

    public boolean getBoolean(String key, boolean def) {
        String string = this.map.get(key);
        if (string == null) {
            return def;
        }
        return Boolean.parseBoolean(string);
    }

    public void putFloat(String key, float value) {
        this.map.put(key, String.valueOf(value));
    }

    public float getFloat(String key, float def) {
        String string = this.map.get(key);
        if (string == null) {
            return def;
        }
        return Float.parseFloat(string);
    }

    public void putDouble(String key, double value) {
        this.map.put(key, String.valueOf(value));
    }

    public double getDouble(String key, double def) {
        String string = this.map.get(key);
        if (string == null) {
            return def;
        }
        return Double.parseDouble(string);
    }

    public void putByteArray(String key, byte[] value) {
        this.map.put(key, String.valueOf(value));
    }

    public byte[] getByteArray(String key, byte[] def) {
        String string = this.map.get(key);
        if (string == null) {
            return def;
        }
        return string.getBytes();
    }

    public String[] keys() throws BackingStoreException {
        return this.map.keySet().toArray(new String[0]);
    }

    public String[] childrenNames() throws BackingStoreException {
        return this.children.keySet().toArray(new String[0]);
    }

    public Preferences parent() {
        return null;
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        String s = this.store.getString(String.valueOf(this.nodePath) + "/" + pathName);
        return s.length() > 0;
    }

    public String name() {
        int lastIndexOf = this.nodePath.lastIndexOf(47);
        if (lastIndexOf == -1) {
            return "";
        }
        return this.nodePath.substring(lastIndexOf);
    }

    public String absolutePath() {
        return this.nodePath;
    }

    public void flush() throws BackingStoreException {
        StringBuilder builder = null;
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (builder == null) {
                builder = new StringBuilder();
            } else {
                builder.append(":");
            }
            builder.append(entry.getKey());
            builder.append(":");
            builder.append(entry.getValue());
        }
        if (builder != null) {
            this.store.putValue(this.nodePath, builder.toString());
        }
        StringBuilder encodedChildren = null;
        for (String entry : this.children.keySet()) {
            if (encodedChildren == null) {
                encodedChildren = new StringBuilder();
            } else {
                encodedChildren.append(":");
            }
            encodedChildren.append(String.valueOf(this.nodePath) + "/" + entry);
        }
        if (encodedChildren != null) {
            this.store.putValue(String.valueOf(this.nodePath) + "$children", encodedChildren.toString());
        }
        for (UDIGExportedPreferences p : this.children.values()) {
            if (p == null) continue;
            p.flush();
        }
    }

    public void sync() throws BackingStoreException {
        String[] encodedChildren;
        String[] data = this.store.getString(this.nodePath).split(":");
        if (data.length > 1) {
            int i = 0;
            while (i < data.length) {
                String key = data[i];
                String value = null;
                if (data.length > ++i) {
                    value = data[i];
                }
                this.map.put(key, value);
                ++i;
            }
        }
        if ((encodedChildren = this.store.getString(String.valueOf(this.nodePath) + "$children").split(":")).length > 1) {
            String[] stringArray = encodedChildren;
            int n = encodedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.length() > 0) {
                    String[] name = string.split("/");
                    this.children.put(name[name.length - 1], null);
                }
                ++n2;
            }
        }
    }
}

